/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xml4j.internal.s1.xpointer;

import com.ibm.xml.xml4j.internal.s1.impl.XMLErrorReporter;
import com.ibm.xml.xml4j.internal.s1.util.SymbolTable;
import com.ibm.xml.xml4j.internal.s1.util.XMLChar;
import com.ibm.xml.xml4j.internal.s1.xni.Augmentations;
import com.ibm.xml.xml4j.internal.s1.xni.QName;
import com.ibm.xml.xml4j.internal.s1.xni.XMLAttributes;
import com.ibm.xml.xml4j.internal.s1.xni.XNIException;
import com.ibm.xml.xml4j.internal.s1.xni.parser.XMLErrorHandler;
import com.ibm.xml.xml4j.internal.s1.xpointer.ShortHandPointer;
import com.ibm.xml.xml4j.internal.s1.xpointer.XPointerErrorHandler;
import com.ibm.xml.xml4j.internal.s1.xpointer.XPointerMessageFormatter;
import com.ibm.xml.xml4j.internal.s1.xpointer.XPointerPart;
import java.util.HashMap;

final class ElementSchemePointer
implements XPointerPart {
    private String fSchemeName;
    private String fSchemeData;
    private String fShortHandPointerName;
    private boolean fIsResolveElement = false;
    private boolean fIsElementFound = false;
    private boolean fWasOnlyEmptyElementFound = false;
    boolean fIsShortHand = false;
    int fFoundDepth = 0;
    private int[] fChildSequence;
    private int fCurrentChildPosition = 1;
    private int fCurrentChildDepth = 0;
    private int[] fCurrentChildSequence;
    private boolean fIsFragmentResolved = false;
    private ShortHandPointer fShortHandPointer;
    protected XMLErrorReporter fErrorReporter;
    protected XMLErrorHandler fErrorHandler;
    private SymbolTable fSymbolTable;

    public ElementSchemePointer() {
    }

    public ElementSchemePointer(SymbolTable symbolTable) {
        this.fSymbolTable = symbolTable;
    }

    public ElementSchemePointer(SymbolTable symbolTable, XMLErrorReporter xMLErrorReporter) {
        this.fSymbolTable = symbolTable;
        this.fErrorReporter = xMLErrorReporter;
    }

    public void parseXPointer(String string2) throws XNIException {
        this.init();
        Tokens tokens = new Tokens(this.fSymbolTable);
        Scanner scanner = new Scanner(this.fSymbolTable){

            protected void addToken(Tokens tokens, int n2) throws XNIException {
                if (n2 == 1 || n2 == 0) {
                    super.addToken(tokens, n2);
                    return;
                }
                ElementSchemePointer.this.reportError("InvalidElementSchemeToken", new Object[]{tokens.getTokenString(n2)});
            }
        };
        int n2 = string2.length();
        boolean bl = scanner.scanExpr(this.fSymbolTable, tokens, string2, 0, n2);
        if (!bl) {
            this.reportError("InvalidElementSchemeXPointer", new Object[]{string2});
        }
        int[] nArray = new int[tokens.getTokenCount() / 2 + 1];
        int n3 = 0;
        block4: while (tokens.hasMore()) {
            int n4 = tokens.nextToken();
            switch (n4) {
                case 0: {
                    n4 = tokens.nextToken();
                    this.fShortHandPointerName = tokens.getTokenString(n4);
                    this.fShortHandPointer = new ShortHandPointer(this.fSymbolTable);
                    this.fShortHandPointer.setSchemeName(this.fShortHandPointerName);
                    continue block4;
                }
                case 1: {
                    nArray[n3] = tokens.nextToken();
                    ++n3;
                    continue block4;
                }
            }
            this.reportError("InvalidElementSchemeXPointer", new Object[]{string2});
        }
        this.fChildSequence = new int[n3];
        this.fCurrentChildSequence = new int[n3];
        System.arraycopy(nArray, 0, this.fChildSequence, 0, n3);
    }

    public String getSchemeName() {
        return this.fSchemeName;
    }

    public String getSchemeData() {
        return this.fSchemeData;
    }

    public void setSchemeName(String string2) {
        this.fSchemeName = string2;
    }

    public void setSchemeData(String string2) {
        this.fSchemeData = string2;
    }

    public boolean resolveXPointer(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations, int n2) throws XNIException {
        boolean bl = false;
        if (this.fShortHandPointerName != null) {
            bl = this.fShortHandPointer.resolveXPointer(qName, xMLAttributes, augmentations, n2);
            if (bl) {
                this.fIsResolveElement = true;
                this.fIsShortHand = true;
            } else {
                this.fIsResolveElement = false;
            }
        } else {
            this.fIsResolveElement = true;
        }
        this.fIsFragmentResolved = this.fChildSequence.length > 0 ? this.matchChildSequence(qName, n2) : (bl && this.fChildSequence.length <= 0 ? bl : false);
        return this.fIsFragmentResolved;
    }

    protected boolean matchChildSequence(QName qName, int n2) throws XNIException {
        if (this.fCurrentChildDepth >= this.fCurrentChildSequence.length) {
            int[] nArray = new int[this.fCurrentChildSequence.length];
            System.arraycopy(this.fCurrentChildSequence, 0, nArray, 0, this.fCurrentChildSequence.length);
            this.fCurrentChildSequence = new int[this.fCurrentChildDepth * 2];
            System.arraycopy(nArray, 0, this.fCurrentChildSequence, 0, nArray.length);
        }
        if (this.fIsResolveElement) {
            if (n2 == 0) {
                this.fCurrentChildSequence[this.fCurrentChildDepth] = this.fCurrentChildPosition;
                ++this.fCurrentChildDepth;
                this.fCurrentChildPosition = 1;
                if (this.fCurrentChildDepth <= this.fFoundDepth || this.fFoundDepth == 0) {
                    if (this.checkMatch()) {
                        this.fIsElementFound = true;
                        this.fFoundDepth = this.fCurrentChildDepth;
                    } else {
                        this.fIsElementFound = false;
                        this.fFoundDepth = 0;
                    }
                }
            } else if (n2 == 1) {
                if (this.fCurrentChildDepth == this.fFoundDepth) {
                    this.fIsElementFound = true;
                } else if (this.fCurrentChildDepth < this.fFoundDepth && this.fFoundDepth != 0 || this.fCurrentChildDepth > this.fFoundDepth && this.fFoundDepth == 0) {
                    this.fIsElementFound = false;
                }
                this.fCurrentChildSequence[this.fCurrentChildDepth] = 0;
                --this.fCurrentChildDepth;
                this.fCurrentChildPosition = this.fCurrentChildSequence[this.fCurrentChildDepth] + 1;
            } else if (n2 == 2) {
                this.fCurrentChildSequence[this.fCurrentChildDepth] = this.fCurrentChildPosition++;
                if (this.checkMatch()) {
                    this.fWasOnlyEmptyElementFound = !this.fIsElementFound;
                    this.fIsElementFound = true;
                } else {
                    this.fIsElementFound = false;
                    this.fWasOnlyEmptyElementFound = false;
                }
            }
        }
        return this.fIsElementFound;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean checkMatch() {
        if (!this.fIsShortHand) {
            if (this.fChildSequence.length > this.fCurrentChildDepth + 1) return false;
            for (int i = 0; i < this.fChildSequence.length; ++i) {
                if (this.fChildSequence[i] == this.fCurrentChildSequence[i]) continue;
                return false;
            }
            return true;
        } else {
            if (this.fChildSequence.length > this.fCurrentChildDepth + 1) return false;
            for (int i = 0; i < this.fChildSequence.length; ++i) {
                if (this.fCurrentChildSequence.length < i + 2) {
                    return false;
                }
                if (this.fChildSequence[i] == this.fCurrentChildSequence[i + 1]) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isFragmentResolved() throws XNIException {
        return this.fIsFragmentResolved;
    }

    public boolean isChildFragmentResolved() {
        if (this.fIsShortHand && this.fShortHandPointer != null && this.fChildSequence.length <= 0) {
            return this.fShortHandPointer.isChildFragmentResolved();
        }
        return this.fWasOnlyEmptyElementFound ? !this.fWasOnlyEmptyElementFound : this.fIsFragmentResolved && this.fCurrentChildDepth >= this.fFoundDepth;
    }

    protected void reportError(String string2, Object[] objectArray) throws XNIException {
        throw new XNIException(this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/XPTR").formatMessage(this.fErrorReporter.getLocale(), string2, objectArray));
    }

    protected void initErrorReporter() {
        if (this.fErrorReporter == null) {
            this.fErrorReporter = new XMLErrorReporter();
        }
        if (this.fErrorHandler == null) {
            this.fErrorHandler = new XPointerErrorHandler();
        }
        this.fErrorReporter.putMessageFormatter("http://www.w3.org/TR/XPTR", new XPointerMessageFormatter());
    }

    protected void init() {
        this.fSchemeName = null;
        this.fSchemeData = null;
        this.fShortHandPointerName = null;
        this.fIsResolveElement = false;
        this.fIsElementFound = false;
        this.fWasOnlyEmptyElementFound = false;
        this.fFoundDepth = 0;
        this.fCurrentChildPosition = 1;
        this.fCurrentChildDepth = 0;
        this.fIsFragmentResolved = false;
        this.fShortHandPointer = null;
        this.initErrorReporter();
    }

    private class Scanner {
        private static final byte CHARTYPE_INVALID = 0;
        private static final byte CHARTYPE_OTHER = 1;
        private static final byte CHARTYPE_MINUS = 2;
        private static final byte CHARTYPE_PERIOD = 3;
        private static final byte CHARTYPE_SLASH = 4;
        private static final byte CHARTYPE_DIGIT = 5;
        private static final byte CHARTYPE_LETTER = 6;
        private static final byte CHARTYPE_UNDERSCORE = 7;
        private static final byte CHARTYPE_NONASCII = 8;
        private final byte[] fASCIICharMap = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 1, 1, 1, 1, 1, 1, 1, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 1, 1, 1, 1, 7, 1, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 1, 1, 1, 1, 1};
        private SymbolTable fSymbolTable;

        private Scanner(SymbolTable symbolTable) {
            this.fSymbolTable = symbolTable;
        }

        private boolean scanExpr(SymbolTable symbolTable, Tokens tokens, String string2, int n2, int n3) throws XNIException {
            String string3 = null;
            while (n2 != n3) {
                int n4 = string2.charAt(n2);
                int n5 = n4 >= 128 ? 8 : this.fASCIICharMap[n4];
                switch (n5) {
                    case 4: {
                        if (++n2 == n3) {
                            return false;
                        }
                        this.addToken(tokens, 1);
                        n4 = string2.charAt(n2);
                        int n6 = 0;
                        while (n4 >= 48 && n4 <= 57) {
                            n6 = n6 * 10 + (n4 - 48);
                            if (++n2 == n3) break;
                            n4 = string2.charAt(n2);
                        }
                        if (n6 == 0) {
                            ElementSchemePointer.this.reportError("InvalidChildSequenceCharacter", new Object[]{new Character((char)n4)});
                            return false;
                        }
                        tokens.addToken(n6);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        int n7 = n2;
                        n2 = this.scanNCName(string2, n3, n2);
                        if (n2 == n7) {
                            ElementSchemePointer.this.reportError("InvalidNCNameInElementSchemeData", new Object[]{string2});
                            return false;
                        }
                        n4 = n2 < n3 ? (int)string2.charAt(n2) : -1;
                        string3 = symbolTable.addSymbol(string2.substring(n7, n2));
                        this.addToken(tokens, 0);
                        tokens.addToken(string3);
                    }
                }
            }
            return true;
        }

        private int scanNCName(String string2, int n2, int n3) {
            byte by2;
            char c = string2.charAt(n3);
            if (c >= '\u0080' ? !XMLChar.isNameStart(c) : (by2 = this.fASCIICharMap[c]) != 6 && by2 != 7) {
                return n3;
            }
            while (++n3 < n2 && !((c = string2.charAt(n3)) >= '\u0080' ? !XMLChar.isName(c) : (by2 = this.fASCIICharMap[c]) != 6 && by2 != 5 && by2 != 3 && by2 != 2 && by2 != 7)) {
            }
            return n3;
        }

        protected void addToken(Tokens tokens, int n2) throws XNIException {
            tokens.addToken(n2);
        }
    }

    private final class Tokens {
        private static final int XPTRTOKEN_ELEM_NCNAME = 0;
        private static final int XPTRTOKEN_ELEM_CHILD = 1;
        private final String[] fgTokenNames = new String[]{"XPTRTOKEN_ELEM_NCNAME", "XPTRTOKEN_ELEM_CHILD"};
        private static final int INITIAL_TOKEN_COUNT = 256;
        private int[] fTokens = new int[256];
        private int fTokenCount = 0;
        private int fCurrentTokenIndex;
        private SymbolTable fSymbolTable;
        private HashMap fTokenNames = new HashMap();

        private Tokens(SymbolTable symbolTable) {
            this.fSymbolTable = symbolTable;
            this.fTokenNames.put(new Integer(0), "XPTRTOKEN_ELEM_NCNAME");
            this.fTokenNames.put(new Integer(1), "XPTRTOKEN_ELEM_CHILD");
        }

        private String getTokenString(int n2) {
            return (String)this.fTokenNames.get(new Integer(n2));
        }

        private Integer getToken(int n2) {
            return (Integer)this.fTokenNames.get(new Integer(n2));
        }

        private void addToken(String string2) {
            Integer n2 = (Integer)this.fTokenNames.get(string2);
            if (n2 == null) {
                n2 = new Integer(this.fTokenNames.size());
                this.fTokenNames.put(n2, string2);
            }
            this.addToken(n2);
        }

        private void addToken(int n2) {
            try {
                this.fTokens[this.fTokenCount] = n2;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                int[] nArray = this.fTokens;
                this.fTokens = new int[this.fTokenCount << 1];
                System.arraycopy(nArray, 0, this.fTokens, 0, this.fTokenCount);
                this.fTokens[this.fTokenCount] = n2;
            }
            ++this.fTokenCount;
        }

        private void rewind() {
            this.fCurrentTokenIndex = 0;
        }

        private boolean hasMore() {
            return this.fCurrentTokenIndex < this.fTokenCount;
        }

        private int nextToken() throws XNIException {
            if (this.fCurrentTokenIndex == this.fTokenCount) {
                ElementSchemePointer.this.reportError("XPointerElementSchemeProcessingError", null);
            }
            return this.fTokens[this.fCurrentTokenIndex++];
        }

        private int peekToken() throws XNIException {
            if (this.fCurrentTokenIndex == this.fTokenCount) {
                ElementSchemePointer.this.reportError("XPointerElementSchemeProcessingError", null);
            }
            return this.fTokens[this.fCurrentTokenIndex];
        }

        private String nextTokenAsString() throws XNIException {
            String string2 = this.getTokenString(this.nextToken());
            if (string2 == null) {
                ElementSchemePointer.this.reportError("XPointerElementSchemeProcessingError", null);
            }
            return string2;
        }

        private int getTokenCount() {
            return this.fTokenCount;
        }
    }
}

