/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.p2plb.clerver;

import com.cognos.p2plb.clerver.AdditionalServices;
import com.cognos.p2plb.clerver.AdditionalServicesFactory;
import com.cognos.p2plb.config.ClusterManager;
import com.cognos.pogo.config.DispatcherList;
import com.cognos.pogo.monitoring.jmx.remote.proxy.chooser.updates.RemoteDispatcherUpdates;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.util.PogoLogger;

public class AdditionalServicesUpdater
extends RemoteDispatcherUpdates {
    private static final PogoLogger log = PogoLogger.getLogger();
    private final ClusterManager clusterManager;
    private Configuration configuration;
    private AdditionalServices additionalServices;
    protected AdditionalServicesFactory factory;

    public AdditionalServicesUpdater() {
        this(null);
    }

    public AdditionalServicesUpdater(ClusterManager clusterManager) {
        this(new AdditionalServicesFactory(), clusterManager);
    }

    public AdditionalServicesUpdater(AdditionalServicesFactory factory, ClusterManager clusterManager) {
        this.factory = factory;
        this.clusterManager = clusterManager;
        this.additionalServices = this.createAdditionalServices();
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    protected AdditionalServices createAdditionalServices() {
        return this.factory.createAdditionalServices();
    }

    public void createClusterFromConfiguration() {
        this.additionalServices.addToDispatcherList(this.getDispatcherList());
        this.clusterManager.createClusterFromConfiguration(this.configuration);
    }

    protected DispatcherList getDispatcherList() {
        return (DispatcherList)this.configuration.getDispatcherList();
    }

    public void addDispatchers(String[] dispatchers) {
    }

    public void removeDispatchers(String[] dispatchers) {
    }

    @Override
    public void updateDispatchers(String[] addedDispatchers, String[] removedDispatchers) {
        AdditionalServices additionalServices = this.createAdditionalServices();
        for (String dispatcher : addedDispatchers) {
            additionalServices.addServicesForDispatcher(dispatcher, this.getDispatcherList());
        }
        this.createClusterFromConfiguration();
    }

    @Override
    public void update() {
        log.debug("update");
        this.notifyCheckProxyHandler();
        this.createClusterFromConfiguration();
    }

    ClusterManager getClusterManager() {
        return this.clusterManager;
    }
}

