/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.p2plb.clerver;

import com.cognos.p2plb.clerver.ConnectionPoolMap;
import com.cognos.p2plb.clerver.ConnectionTracker;
import com.cognos.p2plb.clerver.ConnectionTrackerFactory;
import com.cognos.p2plb.model.NodeID;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConnectionTrackers {
    static final int DEFAULT_TIMEOUT_CHECKS = 5;
    private int timeoutChecks = 5;
    private final ConnectionPoolMap owner;
    private final ConnectionTrackerFactory connectionTrackerFactory;
    private final Map<NodeID, ConnectionTracker> connectionTrackersMap = Collections.synchronizedMap(new HashMap());

    public ConnectionTrackers(ConnectionPoolMap owner, ConnectionTrackerFactory connectionTrackerFactory) {
        this.owner = owner;
        this.connectionTrackerFactory = connectionTrackerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionTracker getConnectionTracker(NodeID nodeID) {
        Map<NodeID, ConnectionTracker> map = this.connectionTrackersMap;
        synchronized (map) {
            ConnectionTracker tracker = this.connectionTrackersMap.get(nodeID);
            if (tracker == null) {
                tracker = this.createConnectionTracker(nodeID);
            }
            return tracker;
        }
    }

    private ConnectionTracker createConnectionTracker(NodeID nodeID) {
        ConnectionTracker tracker = this.connectionTrackerFactory.createConnectionTracker(this.owner, nodeID, this.timeoutChecks);
        this.connectionTrackersMap.put(nodeID, tracker);
        return tracker;
    }

    public int getTimeoutChecks() {
        return this.timeoutChecks;
    }

    public void setTimeoutChecks(int timeoutChecks) {
        this.timeoutChecks = timeoutChecks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Map<NodeID, ConnectionTracker> map = this.connectionTrackersMap;
        synchronized (map) {
            for (ConnectionTracker tracker : this.connectionTrackersMap.values()) {
                tracker.dispose();
            }
            this.connectionTrackersMap.clear();
        }
    }

    public int getPoolSize(NodeID nodeID) {
        return this.getConnectionTracker(nodeID).getCurrentSize();
    }

    public List<NodeID> getActiveNodes() {
        ArrayList<NodeID> activeNodes = new ArrayList<NodeID>();
        this.addActiveNodesToList(activeNodes);
        return activeNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addActiveNodesToList(List<NodeID> activeNodes) {
        Map<NodeID, ConnectionTracker> map = this.connectionTrackersMap;
        synchronized (map) {
            for (Map.Entry<NodeID, ConnectionTracker> mapEntry : this.connectionTrackersMap.entrySet()) {
                if (!this.isNodeActive(mapEntry)) continue;
                this.addNodeToList(mapEntry, activeNodes);
            }
        }
    }

    private boolean isNodeActive(Map.Entry<NodeID, ConnectionTracker> mapEntry) {
        ConnectionTracker tracker = mapEntry.getValue();
        return this.hasActiveConnection(tracker);
    }

    private boolean hasActiveConnection(ConnectionTracker tracker) {
        return tracker.getCurrentSize() > 0;
    }

    private void addNodeToList(Map.Entry<NodeID, ConnectionTracker> mapEntry, List<NodeID> activeNodes) {
        NodeID nodeID = mapEntry.getKey();
        activeNodes.add(nodeID);
    }

    public boolean isReachable(NodeID nodeID) {
        ConnectionTracker tracker = this.getConnectionTracker(nodeID);
        return this.hasNoActiveConnections(tracker) || tracker.isReachable();
    }

    private boolean hasNoActiveConnections(ConnectionTracker tracker) {
        return !this.hasActiveConnection(tracker);
    }

    public void markAsUnreachable(NodeID nodeID) {
        this.getConnectionTracker(nodeID).setIsReachable(false);
    }

    public void markAsReachable(NodeID nodeID) {
        this.getConnectionTracker(nodeID).setIsReachable(true);
    }
}

