/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.p2plb.clerver;

import com.cognos.p2plb.config.ClusterManager;
import com.cognos.p2plb.model.ClusterNodeView;
import com.cognos.p2plb.model.ClusterView;
import com.cognos.p2plb.model.NodeID;
import com.cognos.p2plb.model.NodeIdGuidMapper;
import com.cognos.p2plb.strategy.wt_round_robin.Candidate;
import com.cognos.p2plb.strategy.wt_round_robin.CandidateList;
import com.cognos.pogo.config.DispatcherList;
import com.cognos.pogo.config.DispatcherListElement;
import com.cognos.pogo.config.DispatcherListService;
import com.cognos.pogo.handlers.debug.UtilHandlerBase;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class LBDiagHandler
extends UtilHandlerBase {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(LBDiagHandler.class.getName());
    private PogoEngine pogoEngine;
    private ClusterManager clusterManager;
    private Configuration localConfig;

    public LBDiagHandler() {
        super(cat);
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        ByteArrayOutputStream baosXML = new ByteArrayOutputStream();
        try {
            PrintWriter pw = new PrintWriter(baosXML);
            pw.println("This dispatcher is: " + NodeID.getSelf().toString());
            pw.println("GUID=" + NodeID.getSelf().getGuid());
            pw.println("Using CM: " + NodeIdGuidMapper.getContentManagerNID().toString());
            pw.println("Current time: " + DateFormat.getDateTimeInstance(2, 0).format(new Date()));
            pw.println("Configured dispatchers and services:");
            this.sayConfig(pw);
            pw.println("\nPerceived state of the cluster:");
            this.sayClusterState(pw);
            pw.close();
            LBDiagHandler.prepareResponse(mc, "text/plain", baosXML.toByteArray());
        }
        catch (IOException x) {
            Fault f = new Fault("IOexception preparing response.", x);
            mc.setFault(f);
        }
    }

    private void sayConfig(PrintWriter pw) {
        pw.println("this dispatcher is : \"" + this.localConfig.getLocalSearchPath() + "\"");
        pw.println("this dispatcher is in serverGroup : \"" + this.localConfig.getLocalServerGroup() + "\"");
        pw.println("\r\nAll known dispatchers:");
        DispatcherList dispatcherList = (DispatcherList)this.localConfig.getDispatcherList();
        Iterator<DispatcherListElement> it = dispatcherList.getAllDispatcherListElements();
        while (it.hasNext()) {
            DispatcherListElement dle = it.next();
            pw.println("\tDispatcher: " + dle.getPath());
            pw.println("\t\tname: " + dle.getName());
            pw.println("\t\tdispatcherID: " + dle.getGuid());
            pw.println("\t\tcapacity: " + dle.getCapacityAsDouble());
            pw.println("\t\tSSL: " + dle.isSslEnabled());
            String serverGroup = dle.getServerGroup();
            if (serverGroup == null || "".equals(serverGroup)) {
                serverGroup = "";
            }
            pw.println("\t\tserverGroup: " + serverGroup);
            pw.println("\t\tloadBalancingMode: " + dle.getLoadBalancingMode());
            pw.println("\t\tedition: " + dle.getEdition());
            pw.println("\t\tServices:");
            Iterator<DispatcherListService> itSrvc = dle.iterator();
            while (itSrvc.hasNext()) {
                DispatcherListService srvc = itSrvc.next();
                String serviceName = srvc.getName();
                if ("installedComponent".equals(serviceName)) continue;
                pw.println("\t\t\tService name: " + srvc.getName() + " disabled? " + (srvc.getDisabled() ? "true" : "false"));
            }
        }
    }

    private void dumpClusterState(PrintWriter pw, String clusterName) {
        ClusterView cv = this.clusterManager.getClusterView(clusterName);
        pw.println();
        pw.print("Server group: ");
        if (clusterName == null || clusterName.length() == 0) {
            pw.println("(default)");
        } else {
            pw.println(clusterName);
        }
        pw.println();
        Iterator<Map.Entry<NodeID, ClusterNodeView>> inode = cv.iterator();
        while (inode.hasNext()) {
            Map.Entry<NodeID, ClusterNodeView> me = inode.next();
            ClusterNodeView cnv = me.getValue();
            pw.print(cnv.getNodeID().toString());
            pw.print(" is ");
            pw.println(cnv.getStateString());
        }
        pw.println("\n\rLoad balancer statistics: ");
        Map<String, CandidateList> candidateLists = cv.getAllCandidateLists();
        for (Map.Entry<String, CandidateList> entry : candidateLists.entrySet()) {
            String serviceName = entry.getKey();
            CandidateList candidateList = entry.getValue();
            if ("installedComponent".equals(serviceName)) continue;
            pw.println("");
            pw.println(serviceName);
            Iterator<Candidate> candidateIterator = candidateList.iterator();
            while (candidateIterator.hasNext()) {
                Candidate candidate = candidateIterator.next();
                pw.print("Times used out of the last 20 requests : ");
                pw.print(candidate.getTimesUsed());
                pw.print("\t");
                pw.print("Total times used since last cluster change: ");
                pw.print(candidate.getRawCount());
                pw.print("\t");
                ClusterNodeView nodeView = (ClusterNodeView)candidate.getObject();
                pw.println(nodeView.getNodeID().toString());
            }
        }
    }

    private void sayClusterState(PrintWriter pw) throws IOException {
        if (this.clusterManager == null) {
            pw.println("logic error clusterManager is null");
            return;
        }
        DispatcherList dispatcherList = (DispatcherList)this.localConfig.getDispatcherList();
        for (String clusterName : dispatcherList.getServerGroups()) {
            this.dumpClusterState(pw, clusterName);
        }
    }

    @Override
    public void initialize() {
        this.clusterManager = (ClusterManager)this.pogoEngine.getContextAttribute("com.cognos.p2plb.clusterManager");
    }

    @Override
    public void configure(Configuration configuration) {
        this.localConfig = configuration;
    }

    @Override
    public void reconfigure(Configuration configuration) {
        this.configure(configuration);
    }

    @Override
    public void compose_impl(PogoEngine engine) throws PogoException {
        this.pogoEngine = engine;
    }
}

