/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.p2plb.clerver;

import com.cognos.p2plb.clerver.ConnectionPoolMap;
import com.cognos.p2plb.clerver.ConnectionTracker;
import com.cognos.p2plb.clerver.TimeoutPostMethod;
import com.cognos.p2plb.model.NodeID;
import com.cognos.pogo.http.ConnectionPool;
import com.cognos.pogo.http.ServerConnection;

public class LoadBalanceConnectionTracker
implements ConnectionTracker {
    private final ConnectionPoolMap poolMap;
    private final NodeID nodeId;
    private final int timeoutChecks;
    private ConnectionPool pool;
    private boolean isReachable;

    public LoadBalanceConnectionTracker(ConnectionPoolMap poolMap, NodeID nid, int timeoutChecks) {
        this.poolMap = poolMap;
        this.nodeId = nid;
        this.timeoutChecks = timeoutChecks;
    }

    private ConnectionPool getPool() {
        if (this.pool == null) {
            this.pool = this.createPool();
        }
        return this.pool;
    }

    private ConnectionPool createPool() {
        boolean ssl = !this.nodeId.getProtocol().equalsIgnoreCase("http");
        return new ConnectionPool(this.nodeId.getHost(), this.nodeId.getPort(), ssl, 0);
    }

    @Override
    public ServerConnection getConnection() {
        ServerConnection serverConnection = this.getPool().getConnection();
        serverConnection.setPostMethod(new TimeoutPostMethod(this.poolMap, this.nodeId, this.timeoutChecks));
        return serverConnection;
    }

    @Override
    public int getCurrentSize() {
        return this.getPool().getCurrentSize();
    }

    @Override
    public void dispose() {
        this.getPool().dispose();
    }

    @Override
    public boolean isReachable() {
        return this.isReachable;
    }

    @Override
    public void setIsReachable(boolean isReachable) {
        this.isReachable = isReachable;
    }
}

