/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.p2plb.clerver;

import com.cognos.p2plb.clerver.LBEnvelope;
import com.cognos.p2plb.core.MessageTimes;
import com.cognos.p2plb.model.ClusterView;
import com.cognos.p2plb.model.NodeID;
import com.cognos.p2plb.model.NodeView;
import com.cognos.pogo.bibus.BIBusCommand;
import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.bibus.SoapFaultException;
import com.cognos.pogo.http.ServerConnection;
import com.cognos.pogo.http.StandaloneServerConnection;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.common.BodyFaultDetail;
import com.cognos.pogo.pdk.common.BodyFaultException;
import java.net.ConnectException;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Element;

public class Pinger
extends BIBusCommand {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(Pinger.class.getName());
    private NodeID target_nid;
    private MessageTimes message_times;
    private boolean doSSL;
    private String pingResult;
    private String errorCode;

    public boolean ping(NodeView nv, ClusterView cv) {
        block13: {
            this.target_nid = nv.getNodeID();
            this.doSSL = nv.getSSLRequired();
            StringBuffer sb = null;
            if (cat.isDebugEnabled()) {
                sb = new StringBuffer();
                sb.append("pinging node: ").append(this.target_nid.toString());
                if (cv != null) {
                    sb.append(", cluster: ").append(cv.getClusterName());
                }
                cat.debug(sb.toString());
            }
            if (!this.target_nid.resolveHostInetAddress()) {
                if (cat.isDebugEnabled()) {
                    cat.error("Cannot ping because cannot resolve IP address of Node: " + this.target_nid.toString());
                }
                this.errorCode = "UNKNOWN_HOST";
                return false;
            }
            try {
                this.createMessageTimes();
                this.execute();
                BIBusEnvelope response_env = this.getResponseEnvelope();
                nv.getNodeTime().set(this.message_times);
                if (cat.isDebugEnabled()) {
                    cat.debug("Message times:\n" + this.message_times.getDiagString());
                }
                if (cat.isDebugEnabled()) {
                    cat.debug("ping succeeded, set clock offset to: " + this.message_times.getClockOffset());
                }
                this.pingResult = response_env.getDispatcherTransportValue("p2plb_result");
                this.errorCode = null;
                return true;
            }
            catch (SoapFaultException sfx) {
                String soapError = this.extractErrorCode(this.getResponseEnvelope());
                String string = this.errorCode = soapError != null ? soapError : sfx.getDetail();
                if (cat.isDebugEnabled()) {
                    cat.debug("Ping failed, reply was a SOAPFault:" + sfx.getMessage() + ", " + sfx.getDetail());
                }
            }
            catch (CommandExecutionException cxx) {
                if (cxx.getTargetException() instanceof ConnectException) {
                    cat.debug("ping failed, could not connect.");
                    this.errorCode = "CONNECT_FAIL";
                }
                if (cxx.getTargetException() != null) {
                    this.errorCode = cxx.getTargetException().getMessage();
                    if (cat.isDebugEnabled()) {
                        cat.debug("ping failed for more malign reason, root cause:", cxx.getTargetException());
                    }
                }
                this.errorCode = cxx.getMessage();
                if (!cat.isDebugEnabled()) break block13;
                cat.debug("ping failed for more malign reason:", (Throwable)cxx);
            }
        }
        return false;
    }

    String extractErrorCode(BIBusEnvelope response) {
        BodyFaultDetail detail = response.getBodyFault().getDetail();
        for (BodyFaultException exception : detail.getExceptions()) {
            if (!exception.isPresent()) continue;
            return exception.getErrorCode();
        }
        return null;
    }

    @Override
    protected void addExtraSOAPHeaders() {
        BIBusEnvelope request_env = this.getRequestEnvelope();
        request_env.setDispatcherTransport("p2plb_messagetimes", this.message_times.toString());
        request_env.setDispatcherTransport("targetGUID", this.target_nid.getGuid());
        request_env.setDispatcherTransport("sourceGUID", NodeID.getSelf().getGuid());
    }

    @Override
    protected void addExtraHTTPHeaders(ServerConnection connection) {
        super.addExtraHTTPHeaders(connection);
        connection.setRequestHeader("SOAPAction", "p2plbPing");
        this.message_times.setSrcOut();
        this.getRequestEnvelope().setDispatcherTransport("p2plb_messagetimes", this.message_times.toString());
    }

    public long getClockOffset() {
        return this.message_times.getClockOffset();
    }

    public MessageTimes getMessageTimes() {
        return this.message_times;
    }

    void createMessageTimes() {
        this.message_times = new MessageTimes();
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    @Override
    protected ServerConnection fetchServerConnection() {
        return new StandaloneServerConnection(this.target_nid.getHost(), this.target_nid.getPort(), this.getSsl());
    }

    private boolean getSsl() {
        return this.doSSL;
    }

    @Override
    protected String fetchRequestContext() {
        return this.target_nid.getPath();
    }

    @Override
    protected void handleResponseImpl(Element responseElement) throws CommandExecutionException {
        this.message_times.fromString(this.getResponseEnvelope().getDispatcherTransportValue("p2plb_messagetimes"));
        this.message_times.setSrcIn();
    }

    @Override
    protected void executeImpl(Element bodyElement) throws CommandExecutionException {
        Element eOldPingReq = bodyElement.element(LBEnvelope.qn_p2plbPingRequest);
        if (eOldPingReq != null) {
            eOldPingReq.detach();
        }
        bodyElement.addElement(LBEnvelope.qn_p2plbPingRequest);
    }

    public String getPingResult() {
        return this.pingResult;
    }

    @Override
    public void setResponseEnvelope(BIBusEnvelope envelope) {
        super.setResponseEnvelope(envelope);
    }
}

