/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.p2plb.clerver;

import com.cognos.p2plb.clerver.LoadBalanceHandler;
import com.cognos.p2plb.model.NodeID;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.reqlog.RequestLog;
import javax.mail.internet.InternetHeaders;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class RedirectBalancedHandler
extends BasicHandler {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(RedirectBalancedHandler.class.getName());

    public RedirectBalancedHandler() {
        super(cat);
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        RequestLog rlog = (RequestLog)mc.getProperty("reqlog");
        if (rlog != null) {
            rlog.addNote("isBalanced", "true");
        }
        BIBusEnvelope env = (BIBusEnvelope)mc.getProperty("request.envelope");
        String originalSOAPAction = env.getDispatcherTransportValue("originalSOAPAction");
        String localSOAPAction = LoadBalanceHandler.makeLocal(originalSOAPAction);
        mc.setProperty("request.soapaction", localSOAPAction);
        ((InternetHeaders)mc.getProperty("request.headers")).setHeader("SOAPAction", localSOAPAction);
        if (cat.isDebugEnabled()) {
            cat.debug("remapped load balanced request to: " + localSOAPAction);
        }
        mc.setProperty("isBalanced", Boolean.TRUE);
        env.setConversationContextNodeID(NodeID.getSelf().getGuid());
    }
}

