/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.p2plb.clerver.actions;

import com.cognos.p2plb.clerver.actions.BalancingParameters;
import com.cognos.p2plb.clerver.actions.ForwardingParams;
import com.cognos.p2plb.clerver.actions.RemoteBalanceHandlerMBean;
import com.cognos.pogo.monitoring.jmx.PogoMBeanServer;
import com.cognos.pogo.monitoring.jmx.utils.MBeanUtils;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Element;

public class RemoteBalanceHandler
extends BasicHandler
implements RemoteBalanceHandlerMBean {
    private static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(RemoteBalanceHandler.class.getName());
    private String serviceName;
    private ForwardingParams forwardingParams;
    private String[] soapActions;
    private static boolean kubernetesMode = Boolean.parseBoolean(System.getenv("KUBERNETES_MODE"));

    public RemoteBalanceHandler() {
        super(cat);
    }

    @Override
    public void contextualize(Element config) throws PogoException {
        super.contextualize(config);
        BalancingParameters balancingParameters = new BalancingParameters(config.element("service"));
        this.serviceName = balancingParameters.getServiceName();
        this.forwardingParams = balancingParameters.getForwardingParams();
        this.soapActions = balancingParameters.getSoapActions();
    }

    @Override
    public void initialize() {
        if (!kubernetesMode) {
            try {
                MBeanServer beanServer = this.getMBeanServer();
                beanServer.registerMBean(this, MBeanUtils.getObjectName(this.serviceName, "loadBalancing"));
            }
            catch (JMException e) {
                cat.warn("Unable to register load balancing MBean for service = " + this.serviceName);
            }
        } else {
            cat.warn("Load Balancing disabled, not registering load balancing MBean for service = " + this.serviceName);
        }
    }

    MBeanServer getMBeanServer() {
        return PogoMBeanServer.getInstance().getServer();
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
    }

    @Override
    public CompositeData getForwardingParams() throws OpenDataException {
        return this.forwardingParams.getComposite();
    }

    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public String[] getSoapActions() {
        return (String[])this.soapActions.clone();
    }
}

