/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.p2plb.clerver.balancer;

import com.cognos.p2plb.clerver.actions.ForwardingParams;
import com.cognos.p2plb.clerver.balancer.LoadBalanceRequestParameters;
import com.cognos.p2plb.clerver.balancer.RequestForwarder;
import com.cognos.p2plb.clerver.balancer.RequestForwardingResult;
import com.cognos.p2plb.model.ClusterNodeView;
import com.cognos.p2plb.model.ClusterView;
import com.cognos.p2plb.model.ClusterViewInterface;
import com.cognos.p2plb.model.NodeID;
import com.cognos.p2plb.model.NodeIdGuidMapper;
import com.cognos.p2plb.strategy.wt_round_robin.Candidate;
import com.cognos.pogo.bibus.RequestAffinity;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.util.PogoLogger;
import java.util.HashSet;

public class LoadBalanceRequest {
    private static final PogoLogger cat = PogoLogger.getLogger();
    private RequestForwarder requestForwarder;
    private String soapAction;
    private String serviceName;
    private final LoadBalanceRequestParameters parameters;
    final MessageContext mc;

    public LoadBalanceRequest(LoadBalanceRequestParameters loadBalanceRequestParameters) {
        this.parameters = loadBalanceRequestParameters;
        this.mc = loadBalanceRequestParameters.getMessageContext();
    }

    public void processRequest(RequestForwarder requestForwarder) {
        this.setRequestForwarder(requestForwarder);
        this.processRequest();
    }

    public void processRequest() {
        String nodeID;
        this.soapAction = this.parameters.extractSoapActionFromMessageContext();
        RequestAffinity affinity = RequestAffinity.determineAffinity(this.soapAction);
        this.serviceName = this.getServiceNameFromSoapAction();
        cat.debug("Will attempt to load balance request for soapAction=", this.soapAction, ", service name=", this.serviceName);
        BIBusEnvelope requestEnvelope = this.extractRequestEnvelope();
        requestEnvelope.setDispatcherTransport("originalSOAPAction", this.soapAction);
        if (affinity == RequestAffinity.ABSOLUTE || affinity == RequestAffinity.GET || affinity == RequestAffinity.CONTROL || affinity == RequestAffinity.SERVER) {
            this.processAbsoluteAffinityRequest();
            return;
        }
        ClusterView cv = this.getClusterViewForServerGroup();
        if (cv == null) {
            return;
        }
        if (affinity == RequestAffinity.HIGH) {
            this.processHighAffinityRequest(cv);
            return;
        }
        if (affinity == RequestAffinity.SESSION && (nodeID = this.getConversationContextNodeID()) != null && nodeID.length() > 0) {
            this.processHighAffinityRequest(cv);
            return;
        }
        if (cv.balanceToSelfOnly(this.serviceName)) {
            cat.debug("process locally");
            this.getRequestForwarder().forwardToSelf(this.soapAction, this.mc, true);
            return;
        }
        if (this.preferLocal()) {
            if (this.isLocalServiceAvailable(cv)) {
                cat.debug("Attempt to process request locally.");
                RequestForwardingResult forwardResult = this.getRequestForwarder().forwardToSelf(this.soapAction, this.mc, false);
                if (forwardResult.isSuccess()) {
                    return;
                }
            } else {
                cat.debug("preferlocal mode, but service not available, so will load balance request.");
            }
        }
        this.processNoAffinityRequest();
    }

    protected boolean isLocalServiceAvailable(ClusterView cv) {
        return cv.isLocalServiceAvailable(this.serviceName);
    }

    protected boolean preferLocal() {
        return this.parameters.isClusterCompatibleMode() || this.parameters.isPreferLocal();
    }

    private BIBusEnvelope extractRequestEnvelope() {
        BIBusEnvelope requestEnvelope = (BIBusEnvelope)this.mc.getProperty("request.envelope");
        this.parameters.setRequestEnvelope(requestEnvelope);
        return requestEnvelope;
    }

    protected String getServiceNameFromSoapAction() {
        return this.parameters.getServiceNameFromSoapAction();
    }

    private String getConversationContextNodeID() {
        return this.parameters.getConversationContextNodeID();
    }

    protected ClusterView getClusterViewForServerGroup() {
        return this.parameters.getClusterViewForServerGroup();
    }

    private void processAbsoluteAffinityRequest() {
        cat.debug("Request is absolutely affine because the soapAction is: ", this.soapAction);
        if (!this.forwardToAffineNode()) {
            this.parameters.setFault("CANNOT_FORWARD_TO_ABSOLUTE_AFFINITY_NODE");
            return;
        }
    }

    private void processHighAffinityRequest(ClusterView cv) {
        ClusterNodeView clusterNodeView;
        NodeID nodeID;
        if (this.getRequestRoutingServerGroup() != null && (nodeID = this.getNodeIdFromEnvelope()) != null && (clusterNodeView = cv.getClusterNodeView(nodeID)) == null) {
            this.processNoAffinityRequest();
            return;
        }
        if (this.forwardToAffineNode()) {
            return;
        }
        this.resetFault();
        this.clearConversationContext();
        this.processNoAffinityRequest();
    }

    private String getRequestRoutingServerGroup() {
        return this.parameters.getRequestRoutingServerGroup();
    }

    private void resetFault() {
        this.parameters.resetFault();
    }

    private void clearConversationContext() {
        this.parameters.clearConversationContext();
    }

    private boolean forwardToAffineNode() {
        NodeID nid = this.getNodeIdFromEnvelope();
        if (nid == null) {
            if (RequestAffinity.determineAffinity(this.soapAction) != RequestAffinity.SESSION) {
                this.logErrorNoNodeID();
            }
            return false;
        }
        ClusterNodeView affineCNV = this.getClusterNodeViewFromGlobal(nid);
        if (affineCNV == null) {
            cat.error("Cannot forward affine request because target node: ", nid.toString(), " not available.");
            return false;
        }
        cat.debug("Forwarding to affine target ", nid.toString());
        this.parameters.setMessageContextProperty("jmeter.target_nid", nid);
        RequestForwardingResult forwardRequest = this.getRequestForwarder().forwardRequest(affineCNV, this.parameters);
        return forwardRequest.isSuccess();
    }

    private ClusterNodeView getClusterNodeViewFromGlobal(NodeID nid) {
        ClusterView cv = this.getGlobalClusterView();
        return cv.getClusterNodeView(nid);
    }

    private ClusterView getGlobalClusterView() {
        return this.parameters.getGlobalClusterView();
    }

    private void logErrorNoNodeID() {
        cat.warn("Cannot forward affine request because no node ID was specified.", " The request is malformed.  SOAPAction is: ", this.soapAction);
        cat.debug("Request header was: ", this.parameters.getRequestEnvelope().getBiBusHeader());
    }

    private NodeID getNodeIdFromEnvelope() {
        String targetGuid = this.getConversationContextNodeID();
        if (targetGuid == null) {
            return null;
        }
        cat.debug("Forwarding to affine target node: ", targetGuid);
        NodeID nid = this.getNodeIDForGuid(targetGuid);
        if (nid == null) {
            cat.error("Cannot forward affine request because the node ID", " is not known to this dispatcher: ", targetGuid);
            return null;
        }
        return nid;
    }

    protected NodeID getNodeIDForGuid(String targetGuid) {
        return NodeIdGuidMapper.getInstance().get(targetGuid);
    }

    void processNoAffinityRequest() {
        int maxAttempts;
        ForwardingParams fwdParam = this.parameters.getForwardingParameters();
        int iAttempts = maxAttempts = fwdParam != null ? fwdParam.getMaxAttempts() : 0;
        while (iAttempts > 0) {
            --iAttempts;
            ClusterView clusterView = this.getClusterViewForServerGroup();
            if (this.forwardToBestNode(clusterView)) {
                return;
            }
            cat.error("no nodes for this service are up.");
            if (iAttempts <= 0) {
                cat.error("and we've reached the attempt limit, give up.");
                break;
            }
            long delay = fwdParam.getDelayBetweenAttempts();
            if (delay <= 0L) continue;
            cat.debug("sleep for ", delay, " ms and try again.");
            try {
                this.sleep(delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            cat.debug("finished sleeping.");
        }
        this.faultOnNoNodes();
    }

    protected void sleep(long delay) throws InterruptedException {
        Thread.sleep(delay);
    }

    private void faultOnNoNodes() {
        cat.warn("No nodes were available or became available within the time and retry limit.");
        this.parameters.setFault("NO_NODES_TO_FORWARD_TO", this.serviceName);
    }

    boolean forwardToBestNode(ClusterViewInterface cv) {
        HashSet<Candidate> visited = new HashSet<Candidate>();
        Candidate best = cv.getFastestCandidate(this.serviceName, visited);
        while (best != null) {
            cat.debug("Chose ", best.getClusterNodeView().getNodeID(), " as best node for no-affinity request.");
            visited.add(best);
            RequestForwardingResult forwardRequest = this.getRequestForwarder().forwardRequest(best.getClusterNodeView(), this.parameters);
            if (forwardRequest.isSuccess()) {
                cat.debug("forwarded successfully.");
                return true;
            }
            if (forwardRequest.isBusy()) {
                cat.info("Forward non-affine request to node: ", best.getClusterNodeView().getNodeID(), " was busy.  Trying another node.");
                this.clearFault();
            } else {
                cat.info("Failed to forward non-affine request to node: ", best.getClusterNodeView().getNodeID());
            }
            best = cv.getFastestCandidate(this.serviceName, visited);
        }
        return false;
    }

    private void clearFault() {
        MessageContext mc = this.parameters.getMessageContext();
        mc.setFault(null);
    }

    void setRequestForwarder(RequestForwarder requestForwarder) {
        this.requestForwarder = requestForwarder;
    }

    RequestForwarder getRequestForwarder() {
        return this.requestForwarder;
    }
}

