/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.p2plb.config;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cclcorej.util.CCLUsageData;
import com.cognos.indications.LogIPFControl;
import com.cognos.p2pd.util.PropertyInserter;
import com.cognos.p2plb.model.NodeID;
import com.cognos.p2plb.model.NodeIdGuidMapper;
import com.cognos.p2plb.model.NodeViewPool;
import com.cognos.p2plb.util.ActionQueue;
import com.cognos.pogo.impl.DispatcherStrings;
import com.cognos.pogo.logging.LoggingContext;
import com.cognos.pogo.logging.LoggingRealm;
import com.cognos.pogo.logging.LoggingRealmFactory;
import com.cognos.pogo.pdk.PogoConfigException;
import com.cognos.pogo.pdk.performance.servlet.PerformanceIndicatorWrappedServlet;
import com.cognos.pogo.pdk.xml.SAXReaderPool;
import com.cognos.pogo.util.PogoIPFLog;
import com.cognos.pogo.util.Version;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Element;

public class ConfigStoreServlet
extends PerformanceIndicatorWrappedServlet {
    private static final long serialVersionUID = -6270484396523291331L;
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(ConfigStoreServlet.class.getName());
    NodeViewPool node_pool;

    private String getServerInfo(ServletConfig config) {
        ServletContext cntxt = this.getServletContext();
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader webappLoader = null;
        Object o = cntxt.getAttribute("originalClassloader");
        if (o != null && o instanceof ClassLoader) {
            webappLoader = (ClassLoader)o;
            Thread.currentThread().setContextClassLoader(webappLoader);
        }
        String serverInfo = cntxt.getServerInfo();
        if (webappLoader != null) {
            Thread.currentThread().setContextClassLoader(currentLoader);
        }
        return serverInfo;
    }

    public void init(ServletConfig config) throws ServletException {
        ActionQueue action_queue;
        super.init(config);
        ServletContext cntxt = this.getServletContext();
        String serverInfo = this.getServerInfo(config);
        System.setProperty("com.cognos.pogo.serverInfo", serverInfo);
        LoggingRealmFactory.createInstance("DISP", "DISP", Version.getVersion());
        try {
            LogIPFControl.start();
        }
        catch (Exception x) {
            System.out.println("LogIPFControl.start() threw an exception: " + x.getMessage());
        }
        try {
            ResourceBundle.getBundle("DispatcherMessages", Locale.getDefault());
        }
        catch (Throwable ex) {
            throw new ServletException("Localized messages for " + Locale.getDefault() + " not found", ex);
        }
        ICCLConfiguration icclconfig = null;
        try {
            icclconfig = CCLConfigurationFactory.createConfiguration();
            icclconfig.init();
            Class<?> logServiceClass = Class.forName("com.cognos.logserver.LogService");
            Object logService = logServiceClass.newInstance();
            cntxt.setAttribute("com.cognos.logserver.LogService", logService);
            Method runMethod = logServiceClass.getMethod("configure", ICCLConfiguration.class);
            runMethod.invoke(logService, icclconfig);
            Method initMethod = logServiceClass.getMethod("initialize", new Class[0]);
            initMethod.invoke(logService, (Object[])null);
            Method startMethod = logServiceClass.getMethod("start", new Class[0]);
            startMethod.invoke(logService, (Object[])null);
        }
        catch (Exception e) {
            cat.error("Encountered error during construction of log service.");
            PogoIPFLog.getInstance().logStartupError(DispatcherStrings.getInstance().getString("ConfigStoreServlet.logServiceStart"));
        }
        final LoggingRealm realm = LoggingRealmFactory.getInstance("DISP");
        LoggingContext loggingContext = realm.getLoggingContext();
        loggingContext.setSessionID("init");
        loggingContext.setStepID("0");
        loggingContext.setRequestID("na");
        loggingContext.setSubRequestID("na");
        Version.getVersion();
        if (cat.isInfoEnabled()) {
            cat.info("DISP version is: " + Version.getVersionStr());
            File cwd = new File(".");
            cat.info("Current working directory is: " + cwd.getAbsolutePath());
            cat.info("serverInfo is " + serverInfo);
        }
        this.initUsageTracking();
        Properties deployment_props = new Properties();
        deployment_props.setProperty("com.cognos.pogo.serverInfo", serverInfo);
        Enumeration eip = config.getInitParameterNames();
        while (eip.hasMoreElements()) {
            String name = (String)eip.nextElement();
            deployment_props.put(name, config.getInitParameter(name));
        }
        if (cat.isDebugEnabled()) {
            if (deployment_props.size() > 0) {
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    deployment_props.store(baos, null);
                    cat.debug("deploy properties initialized from servlet init params:\n" + baos.toString());
                }
                catch (IOException baos) {}
            } else {
                cat.debug("No servlet init params to initialize deploy properties\n");
            }
        }
        try {
            InputStream is = cntxt.getResourceAsStream("/WEB-INF/p2pd_deploy_defaults.properties");
            if (is == null) {
                cat.warn("no p2pd_deploy_defaults.properties in the web application");
            } else {
                deployment_props.load(is);
                is.close();
                if (cat.isDebugEnabled()) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    deployment_props.store(baos, null);
                    cat.debug("default deploy properties:\n" + baos.toString());
                }
            }
        }
        catch (Exception e) {
            cat.fatalError("error loading p2pd_deploy_defaults.properties", (Throwable)e);
            throw new ServletException(DispatcherStrings.getInstance().getString("ConfigStoreServlet.P2PDDeployPropertiesNotLoaded"), (Throwable)e);
        }
        this.initExtraProperties(cntxt, deployment_props);
        String sPoolingEnabled = deployment_props.getProperty("SAXReaderPool.enabled");
        boolean poolingEnabled = Boolean.valueOf(sPoolingEnabled);
        int numSticky = 0;
        try {
            numSticky = Integer.parseInt(deployment_props.getProperty("SAXReaderPool.numSticky"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        cat.info("pogo SAXReader pooling enabled? " + poolingEnabled);
        cat.info("pogo SAXReader pooling number of sticky readers=" + numSticky);
        SAXReaderPool.prepare(poolingEnabled, numSticky);
        this.getCCLConfigurationProperties(deployment_props);
        this.addDispatcherNameProperty(deployment_props);
        String axis_client_config = deployment_props.getProperty("axis.client.config");
        if (axis_client_config != null && axis_client_config.length() > 0) {
            cat.debug("set path to axis client config to: " + axis_client_config);
            System.setProperty("axis.ClientConfigFile", axis_client_config);
        }
        PropertyInserter.setProperties(deployment_props);
        String tempDirName = PropertyInserter.getProperty("dispatcher.temp", "../temp/dispatcher");
        tempDirName = icclconfig.resolveEffectivePath(tempDirName);
        PropertyInserter.setProperty("dispatcher.temp", tempDirName);
        File tempDir = new File(tempDirName);
        if (tempDir.exists() && tempDir.isDirectory()) {
            cat.debug("Using dispatcher temp dir: " + tempDir);
        } else if (tempDir.mkdirs()) {
            cat.info("Created dispatcher temp dir: " + tempDir);
        }
        try {
            NodeID.setSelf(deployment_props.getProperty("dispatcher.uri"));
            NodeID.setSelf(deployment_props.getProperty("internalDispatcher.uri"));
            this.checkCmUrlsForSelf();
            cat.info("This dispatcher is: " + NodeID.getSelf().toString() + " AKA " + NodeID.getSelf().toInetString());
        }
        catch (Exception x) {
            cat.error("bad NodeID string for NodeID.setSelf(): \"" + deployment_props.getProperty("dispatcher.uri") + "\"");
        }
        if (PropertyInserter.getProperty("os.shared.lib.extension") == null) {
            String shellExtension;
            String sharedLibExtension;
            String exeExtension;
            String osname = System.getProperty("os.name");
            if (osname == null) {
                cat.warn("Cannot determine operating system.  Assuming Win32.");
                osname = "Windows";
            } else {
                cat.debug("operating system is " + osname);
            }
            if (osname.indexOf("HP-UX") != -1) {
                exeExtension = "";
                sharedLibExtension = ".sl";
                shellExtension = ".sh";
            } else if (osname.indexOf("indows") != -1) {
                exeExtension = ".exe";
                sharedLibExtension = ".dll";
                shellExtension = ".bat";
            } else {
                exeExtension = "";
                sharedLibExtension = ".so";
                shellExtension = ".sh";
            }
            PropertyInserter.setProperty("os.shared.lib.extension", sharedLibExtension);
            PropertyInserter.setProperty("os.executable.extension", exeExtension);
            PropertyInserter.setProperty("os.shell.extension", shellExtension);
            cat.debug("Using file extensions: " + exeExtension + ", " + shellExtension + " and " + sharedLibExtension);
        }
        if ((action_queue = (ActionQueue)cntxt.getAttribute("com.cognos.p2plb.action_queue")) == null) {
            action_queue = new ActionQueue();
            action_queue.start();
            cntxt.setAttribute("com.cognos.p2plb.action_queue", (Object)action_queue);
        }
        Timer timer = new Timer(true);
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                Thread.currentThread().setName("pogo.HouseKeepingTimerThread");
                LoggingContext loggingContext = realm.getLoggingContext();
                loggingContext.setSessionID("backgroundTimerTasks");
                loggingContext.setStepID("0");
                loggingContext.setRequestID("na");
                loggingContext.setSubRequestID("na");
            }
        }, 0L);
        cntxt.setAttribute("com.cognos.p2plb.housekeepingtimer", (Object)timer);
    }

    void initExtraProperties(ServletContext cntxt, Properties deployment_props) {
        try {
            Set propertiesPaths = cntxt.getResourcePaths("/WEB-INF/properties");
            if (propertiesPaths != null) {
                for (String path : propertiesPaths) {
                    InputStream is;
                    if (!path.endsWith(".properties")) continue;
                    if (cat.isDebugEnabled()) {
                        cat.debug("loading properties: " + path);
                    }
                    if ((is = cntxt.getResourceAsStream(path)) != null) {
                        deployment_props.load(is);
                        is.close();
                    }
                    if (!cat.isDebugEnabled()) continue;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    deployment_props.store(baos, null);
                    cat.debug("properties:\n" + baos.toString());
                }
            }
        }
        catch (Exception e) {
            cat.warn("error loading properties from /WEB-INFO/properties", (Throwable)e);
        }
    }

    public int initUsageTracking() {
        CCLUsageData usageData = new CCLUsageData();
        int usageResult = usageData.registerUsageTracking();
        if (cat.isInfoEnabled()) {
            cat.info("CCLUsageData.registerUsageTracking, return code = " + usageResult);
        }
        return usageResult;
    }

    public void destroy() {
        ActionQueue action_queue;
        cat.debug("ConfigStoreServlet.destroy() called.");
        ServletContext cntxt = this.getServletContext();
        Timer timer = (Timer)cntxt.getAttribute("com.cognos.p2plb.housekeepingtimer");
        if (timer != null) {
            timer.cancel();
        }
        if ((action_queue = (ActionQueue)cntxt.getAttribute("com.cognos.p2plb.action_queue")) != null) {
            action_queue.stop();
        }
        LogIPFControl.stop();
    }

    private void getCCLConfigurationProperties(Properties deployment_properties) throws MissingResourceException, ServletException {
        ICCLConfiguration config = CCLConfigurationFactory.getInstance();
        try {
            config.init();
            this.getComponentProperties(deployment_properties, config, "externalDispatcher", "dispatcher", true);
            this.getComponentProperties(deployment_properties, config, "internalDispatcher", "internalDispatcher", false);
            this.getContentManagerList(config);
        }
        catch (Exception e) {
            PogoIPFLog.getInstance().logStartupError(DispatcherStrings.getInstance().getString("ConfigStoreServlet.ConfigPropertiesMissing"));
            cat.fatalError("error loading CCL Configuration properties", (Throwable)e);
            throw new ServletException(DispatcherStrings.getInstance().getString("ConfigStoreServlet.ConfigPropertiesMissing"), (Throwable)e);
        }
    }

    private void addDispatcherNameProperty(Properties deployment_properties) {
        StringBuffer dispatcherName = new StringBuffer();
        dispatcherName.append(deployment_properties.getProperty("dispatcher.protocol"));
        dispatcherName.append("://");
        dispatcherName.append(deployment_properties.getProperty("dispatcher.host"));
        dispatcherName.append(":");
        dispatcherName.append(deployment_properties.getProperty("dispatcher.port"));
        String name = dispatcherName.toString();
        deployment_properties.setProperty("dispatcher.name", name + deployment_properties.getProperty("dispatcher.context"));
        dispatcherName.append(deployment_properties.getProperty("dispatcher.url"));
        deployment_properties.setProperty("dispatcher.uri", dispatcherName.toString());
        dispatcherName.setLength(0);
        dispatcherName.append(deployment_properties.getProperty("internalDispatcher.protocol"));
        dispatcherName.append("://");
        dispatcherName.append(deployment_properties.getProperty("internalDispatcher.host"));
        dispatcherName.append(":");
        dispatcherName.append(deployment_properties.getProperty("internalDispatcher.port"));
        name = dispatcherName.toString();
        deployment_properties.setProperty("internalDispatcher.name", name + deployment_properties.getProperty("internalDispatcher.context"));
        dispatcherName.append(deployment_properties.getProperty("internalDispatcher.url"));
        deployment_properties.setProperty("internalDispatcher.uri", dispatcherName.toString());
    }

    private void getComponentProperties(Properties deployment_properties, ICCLConfiguration config, String component, String compAbbr, boolean localhostResolve) {
        String value = null;
        try {
            value = config.getValue(component, false);
            deployment_properties.setProperty(compAbbr + ".uri", value);
            if (cat.isDebugEnabled()) {
                cat.debug("CCL property -> " + component + "=" + value);
            }
            URL tmpUrl = new URL(value);
            deployment_properties.setProperty(compAbbr + ".protocol", tmpUrl.getProtocol());
            String host = tmpUrl.getHost();
            if ("localhost".equalsIgnoreCase(host) && localhostResolve) {
                try {
                    host = InetAddress.getLocalHost().getHostName();
                    cat.info("resolved localhost to: " + host);
                }
                catch (UnknownHostException uhe) {
                    cat.error("cannot determine host name of local machine.");
                    host = "localhost";
                }
            }
            host = host.toLowerCase();
            deployment_properties.setProperty(compAbbr + ".host", host);
            deployment_properties.setProperty(compAbbr + ".port", String.valueOf(tmpUrl.getPort()));
            String path = tmpUrl.getPath();
            deployment_properties.setProperty(compAbbr + ".url", path);
            int slash = path.indexOf(47, 1);
            String context = path.substring(0, slash);
            deployment_properties.setProperty(compAbbr + ".context", context);
            deployment_properties.setProperty(compAbbr + ".scriptname", path.substring(slash));
        }
        catch (CCLConfigurationException e) {
            cat.error("trouble getting config for " + component, (Throwable)e);
        }
        catch (MalformedURLException ex) {
            cat.fatalError("Cannot parse URL " + value, (Throwable)ex);
        }
    }

    private void getContentManagerList(ICCLConfiguration config) throws CCLConfigurationException, PogoConfigException {
        Element cmElement = config.getValueElement("contentManagers", false);
        if (cmElement == null) {
            throw new PogoConfigException("no contentManagers");
        }
        Iterator iter = cmElement.elementIterator("item");
        while (iter.hasNext()) {
            Element itemElement = (Element)iter.next();
            String cmUrl = itemElement.getTextTrim();
            NodeIdGuidMapper.getInstance().addCmUrl(cmUrl);
        }
    }

    private void checkCmUrlsForSelf() {
        for (NodeID cmNode : NodeIdGuidMapper.getInstance().getCmUrlList()) {
            if (!cmNode.isLocalToSelf()) continue;
            PropertyInserter.setProperty("localCM", "true");
            ServletContext context = this.getServletContext();
            context.setAttribute("localCmNodeId", (Object)cmNode);
        }
    }
}

