/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.p2plb.core;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class MessageTimes {
    protected long src_out = 0L;
    protected long dest_in = 0L;
    protected long dest_out = 0L;
    protected long src_in = 0L;

    public long getSrcOut() {
        return this.src_out;
    }

    public long getSrcIn() {
        return this.src_in;
    }

    public long getDestOut() {
        return this.dest_out;
    }

    public long getDestIn() {
        return this.dest_in;
    }

    public void setSrcOut(long t) {
        this.src_out = t;
    }

    public void setSrcIn(long t) {
        this.src_in = t;
    }

    public void setDestOut(long t) {
        this.dest_out = t;
    }

    public void setDestIn(long t) {
        this.dest_in = t;
    }

    public void setSrcOut() {
        this.src_out = System.currentTimeMillis();
    }

    public void setSrcIn() {
        this.src_in = System.currentTimeMillis();
    }

    public void setDestOut() {
        this.dest_out = System.currentTimeMillis();
    }

    public void setDestIn() {
        this.dest_in = System.currentTimeMillis();
    }

    public long getClockOffset() {
        return (this.dest_in - this.src_out + (this.dest_out - this.src_in)) / 2L;
    }

    public long getDelay() {
        return this.src_in - this.src_out - (this.dest_out - this.dest_in);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.src_out).append(',').append(this.dest_in).append(',').append(this.dest_out).append(',').append(this.src_in);
        return sb.toString();
    }

    public void fromString(String s) {
        this.reset();
        if (s == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(s, ",");
        try {
            this.src_out = Long.parseLong(st.nextToken());
            this.dest_in = Long.parseLong(st.nextToken());
            this.dest_out = Long.parseLong(st.nextToken());
            this.src_in = Long.parseLong(st.nextToken());
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void reset() {
        this.src_out = 0L;
        this.dest_in = 0L;
        this.dest_out = 0L;
        this.src_in = 0L;
    }

    public boolean isValid() {
        return this.src_out != 0L && this.src_in != 0L;
    }

    public String getDiagString() {
        StringBuffer sb = new StringBuffer();
        long t = this.getSrcOut();
        sb.append("SrcOut:\tDestIn:\tDestOut:\tSrcIn:\n");
        sb.append(this.getSrcOut() - t).append("\t");
        sb.append(this.getDestIn() - t).append("\t");
        sb.append(this.getDestOut() - t).append("\t");
        sb.append(this.getSrcIn() - t).append("\n");
        System.out.println(sb.toString());
        sb.setLength(0);
        sb.append("delay 1: ").append(this.getDestIn() - this.getSrcOut()).append("\n");
        sb.append("delay 2: ").append(this.getSrcIn() - this.getDestOut()).append("\n");
        sb.append("clock offset: ").append(this.getClockOffset()).append("\n");
        return sb.toString();
    }
}

