/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.p2plb.model;

import com.cognos.p2plb.model.ClusterView;
import com.cognos.p2plb.model.NodeID;
import com.cognos.p2plb.model.NodeView;
import com.cognos.pogo.util.PogoLogger;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class ClusterNodeView
implements Observer {
    static final PogoLogger cat = PogoLogger.getLogger();
    static final Logger cat_decay = Hierarchy.getDefaultHierarchy().getLoggerFor(ClusterNodeView.class.getName() + ".DECAY");
    public static final int UP = 1;
    public static final int DOWN = 2;
    protected int state = 1;
    protected long determined_at = 0L;
    protected NodeView node_view = null;
    protected ClusterView my_cluster_view;
    protected double capacity = 1.0;
    protected HashSet<String> providerNames = new HashSet();
    private String toString;
    private boolean zombie = false;

    public ClusterNodeView(NodeView node_view, ClusterView cluster_view) {
        this.node_view = node_view;
        node_view.addObserver(this);
        this.my_cluster_view = cluster_view;
    }

    public ClusterNodeView() {
    }

    public ClusterView getClusterView() {
        return this.my_cluster_view;
    }

    synchronized void retire() {
        this.node_view.deleteObserver(this);
    }

    public synchronized void setStateString(String s) {
        this.setState(s.equals("up") ? 1 : 2);
    }

    public synchronized void setState(int state) {
        if (this.state == state) {
            return;
        }
        this.state = state;
        this.determined_at = System.currentTimeMillis();
    }

    public int getState() {
        return this.state;
    }

    public long getDeterminedAt() {
        return this.determined_at;
    }

    public void setDeterminedAt(long l) {
        this.determined_at = l;
    }

    public String getStateString() {
        return this.state == 1 ? "up" : "down";
    }

    public NodeID getNodeID() {
        return this.node_view.getNodeID();
    }

    public NodeView getNodeView() {
        return this.node_view;
    }

    void setZombie(boolean b) {
        this.zombie = b;
    }

    boolean isZombie() {
        return this.zombie;
    }

    public double getCapacity() {
        return this.capacity;
    }

    public void setCapacity(double d) {
        this.capacity = d;
    }

    public Iterator<String> getProviderNameIterator() {
        return this.providerNames.iterator();
    }

    public synchronized void addProviderName(String providerName) {
        cat.debug("addProviderName: ", providerName);
        this.providerNames.add(providerName);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o == this.node_view) {
            cat.debug("update called, node_view.state = " + this.node_view.getState());
            this.setState(this.node_view.getState());
            if (this.getState() == 2) {
                this.my_cluster_view.removeCNV(this);
            } else {
                this.my_cluster_view.addCNV(this);
            }
        } else {
            cat.debug("o didn't match node_view!");
        }
    }

    public void clearProviders() {
        cat.debug("clearProviders");
        this.providerNames.clear();
    }

    public void setStateFromNodeView() {
        if (this.getNodeView().getState() == 2) {
            this.setState(2);
        } else {
            this.setState(1);
        }
    }

    public String toString() {
        if (this.toString == null) {
            this.toString = this.getClass().getSimpleName() + "(nodeID=" + this.getNodeID() + ")";
        }
        return this.toString;
    }
}

