/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.p2plb.model;

import com.cognos.p2pd.util.PropertyInserter;
import com.cognos.p2plb.config.CfgNode;
import com.cognos.p2plb.model.CVNMap;
import com.cognos.p2plb.model.ClusterNodeView;
import com.cognos.p2plb.model.ClusterViewInterface;
import com.cognos.p2plb.model.InProgressRequestFactor;
import com.cognos.p2plb.model.NodeID;
import com.cognos.p2plb.model.NodeIdGuidMapper;
import com.cognos.p2plb.model.NodeTime;
import com.cognos.p2plb.model.NodeView;
import com.cognos.p2plb.model.NodeViewPool;
import com.cognos.p2plb.model.ProcessTimings;
import com.cognos.p2plb.strategy.wt_round_robin.Candidate;
import com.cognos.p2plb.strategy.wt_round_robin.CandidateList;
import com.cognos.p2plb.util.ActionQueue;
import com.cognos.pogo.config.DispatcherList;
import com.cognos.pogo.config.DispatcherListElement;
import com.cognos.pogo.config.DispatcherListService;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.util.PogoLogger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class ClusterView
implements ClusterViewInterface {
    static final String classname = ClusterView.class.getName();
    static final PogoLogger cat = PogoLogger.getLogger();
    static final Logger catDebugDigest = Hierarchy.getDefaultHierarchy().getLoggerFor(classname + ".DEBUGDIGEST");
    private String cluster_name;
    protected CVNMap nodes_by_id;
    HashMap<String, CandidateList> mapCandidateListByProvider = new HashMap();
    NodeViewPool node_pool;
    ActionQueue actionQueue;
    boolean retired;
    private final InProgressRequestFactor inProgressRequestFactor;

    public ClusterView(String cluster_name, NodeViewPool node_pool, ActionQueue actionQueue) {
        this(cluster_name, node_pool, actionQueue, new InProgressRequestFactor());
    }

    public ClusterView(String cluster_name, NodeViewPool node_pool, ActionQueue actionQueue, InProgressRequestFactor inProgressRequestFactor) {
        this.nodes_by_id = new CVNMap();
        this.node_pool = node_pool;
        this.cluster_name = cluster_name;
        this.actionQueue = actionQueue;
        this.inProgressRequestFactor = inProgressRequestFactor;
    }

    public NodeViewPool getNodePool() {
        return this.node_pool;
    }

    public synchronized void retire() {
        this.retired = true;
    }

    public synchronized boolean isRetired() {
        return this.retired;
    }

    public String getClusterName() {
        return this.cluster_name;
    }

    public synchronized ClusterNodeView getClusterNodeView(NodeID nid) {
        return (ClusterNodeView)this.nodes_by_id.get(nid);
    }

    @Override
    public synchronized ClusterNodeView getFastest(String provider) {
        return this.getFastestCandidate(provider, null).getClusterNodeView();
    }

    @Override
    public synchronized Candidate getFastestCandidate(String serviceName, HashSet<Candidate> visited) {
        CandidateList cl = this.getCandidateList(serviceName);
        if (cl != null) {
            return cl.getBest(visited);
        }
        return null;
    }

    public synchronized boolean balanceToSelfOnly(String provider) {
        CandidateList cl = this.getCandidateList(provider);
        if (cl != null) {
            return cl.balanceToSelfOnly();
        }
        cat.warn("unknown provider: ", provider);
        return false;
    }

    public synchronized boolean anyCandidates(String provider) {
        CandidateList cl = this.getCandidateList(provider);
        if (cl != null) {
            return cl.size() > 0;
        }
        cat.warn("unknown provider: ", provider);
        return false;
    }

    synchronized void removeCNV(ClusterNodeView cnv) {
        cat.debug("removing cluster view: ", this.cluster_name, " - ", cnv.getNodeID());
        for (CandidateList candidateList : this.mapCandidateListByProvider.values()) {
            if (candidateList.remove(cnv) == null) continue;
            candidateList.prepare();
        }
    }

    synchronized void addCNV(ClusterNodeView cnv) {
        cat.debug("adding cluster node view: ", this.cluster_name, " - ", cnv.getNodeID());
        Iterator<String> itProviderNames = cnv.getProviderNameIterator();
        while (itProviderNames.hasNext()) {
            String providerName = itProviderNames.next();
            CandidateList candidateList = this.getCandidateList(providerName);
            if (candidateList == null) {
                cat.error("Logic error: no candidate list for provider name: ", providerName);
                continue;
            }
            candidateList.add(new Candidate(cnv.getCapacity(), cnv));
            candidateList.prepare();
        }
    }

    public void reviseNodeView(NodeID nid, NodeTime node_time, ProcessTimings pt, boolean affine) {
        ClusterNodeView cnv = this.getClusterNodeView(nid);
        if (cnv == null) {
            return;
        }
        NodeView nv = cnv.getNodeView();
        nv.setState(1);
        nv.setNodeTime(node_time);
    }

    public synchronized void prepareFromCfig(Configuration configuration) {
        this.inProgressRequestFactor.updateConfiguration(configuration);
        DispatcherList dispatcherList = (DispatcherList)configuration.getDispatcherList();
        if (null == dispatcherList) {
            cat.debug("attempt to get prepare cluster before configuration is available.");
            return;
        }
        Iterator<DispatcherListElement> itDisp = this.cluster_name == null ? dispatcherList.getAllDispatcherListElements() : dispatcherList.getDispatcherListElements(this.cluster_name).iterator();
        while (itDisp.hasNext()) {
            DispatcherListElement dle = itDisp.next();
            CfgNode cfgNode = this.checkDispatcher(dle);
            if (cfgNode == null) continue;
            String dispServerGroup = dle.getServerGroup();
            NodeID nid = cfgNode.getNodeID();
            NodeView nv = this.node_pool.get(nid);
            if (nv == null) continue;
            double weight = cfgNode.getWeight() * nv.getWeight();
            if (weight == 0.0) {
                cat.debug("Node ", nv.getNodeID(), " has capacity of zero, so not added to cluster.");
                continue;
            }
            ClusterNodeView cnv = this.createClusterNodeView(nv);
            cnv.setCapacity(weight);
            cnv.clearProviders();
            this.checkDispatcherServices(dle, dispServerGroup, nv, weight, cnv);
            cnv.setStateFromNodeView();
        }
        this.prepareCandidateLists();
    }

    private void checkDispatcherServices(DispatcherListElement dle, String dispServerGroup, NodeView nv, double weight, ClusterNodeView cnv) {
        boolean sameServerGroup = this.checkSameServerGroup(dispServerGroup);
        Iterator<DispatcherListService> itServices = dle.iterator();
        while (itServices.hasNext()) {
            DispatcherListService dls = itServices.next();
            if (dls.getDisabled()) {
                cat.debug("skip stopped provider: ", cnv.getNodeID(), " [", dls.getName(), "]");
                continue;
            }
            if (sameServerGroup || dls.isGlobalService()) {
                cnv.addProviderName(dls.getName());
                if (nv.getState() != 1) continue;
                cat.debug("Add candidate: ", cnv.getNodeID(), " [", dls.getName(), "]");
                this.getCandidateList(dls.getName()).add(new Candidate(weight, cnv));
                continue;
            }
            cat.debug("skipped candidate in different serverGroup: ", dispServerGroup, ", ", cnv.getNodeID(), " [", dls.getName(), "]");
        }
    }

    private boolean checkSameServerGroup(String dispServerGroup) {
        boolean sameServerGroup = this.cluster_name == null ? true : this.isSameServerGroup(this.cluster_name, dispServerGroup);
        return sameServerGroup;
    }

    private void prepareCandidateLists() {
        for (CandidateList candidateList : this.mapCandidateListByProvider.values()) {
            candidateList.prepare();
        }
    }

    private ClusterNodeView createClusterNodeView(NodeView nodeView) {
        NodeID nodeID = nodeView.getNodeID();
        ClusterNodeView clusterNodeView = this.nodes_by_id.getNode(nodeID);
        if (clusterNodeView == null) {
            clusterNodeView = new ClusterNodeView(nodeView, this);
            this.addNode(nodeID, clusterNodeView);
        }
        return clusterNodeView;
    }

    void addNode(NodeID nodeID, ClusterNodeView clusterNodeView) {
        this.nodes_by_id.putNode(nodeID, clusterNodeView);
    }

    private boolean isSameServerGroup(String myServerGroup, String dispServerGroup) {
        if (myServerGroup == null) {
            return dispServerGroup == null;
        }
        return myServerGroup.equals(dispServerGroup);
    }

    CfgNode checkDispatcher(DispatcherListElement dle) {
        String oldGuid;
        cat.debug("processing dispatcher: ", dle.getName(), " capacity=", dle.getCapacityAsDouble());
        double weight = dle.getCapacityAsDouble();
        if (weight == 0.0) {
            cat.debug("Node \"", dle.getName(), "\" ignored because it has capacity of 0.");
            return null;
        }
        NodeID configNid = this.decodeNid(dle);
        NodeView nv = this.node_pool.getOrCreate(configNid);
        NodeID nid = nv.getNodeID();
        String newGuid = dle.getGuid();
        if (!newGuid.equals(oldGuid = nid.getGuid())) {
            cat.debug("GUID of a dispatcher ", nid.toString(), " changed from ", oldGuid, " to ", newGuid);
            if (oldGuid != null) {
                NodeIdGuidMapper.getInstance().remove(oldGuid);
            }
        }
        nid.setGuid(newGuid);
        NodeID nidByGuid = NodeIdGuidMapper.getInstance().get(newGuid);
        if (nidByGuid != null) {
            cat.debug("GUID=", newGuid, " was already mapped to node ", nidByGuid);
        }
        cat.debug("add/update mapping in NodeIdGuidMapper: GUID=", newGuid, " ==> nid:", nid);
        NodeIdGuidMapper.getInstance().put(newGuid, nid);
        nv.setSSLRequired(dle.isSslEnabled());
        nv.setWeight(1.0);
        nv.setEdition(dle.getEdition());
        return new CfgNode(nid, weight);
    }

    private NodeID decodeNid(DispatcherListElement dle) {
        String server;
        String name = dle.getName();
        int i = name.lastIndexOf(58);
        int port = 8080;
        String context = "/p2pd";
        if (i == -1) {
            server = name;
        } else {
            server = name.substring(0, i);
            int slash = name.indexOf(47, i);
            try {
                port = slash == -1 ? Integer.parseInt(name.substring(i + 1)) : Integer.parseInt(name.substring(i + 1, slash));
            }
            catch (NumberFormatException nfx) {
                cat.warn("Invalid dispatcher configuration in Content Manager for the dispatcher named: \"", name, "\": cannot parse the value of port as an integer.");
                return null;
            }
            context = name.substring(slash);
        }
        server = server.toLowerCase();
        String dispatcherPath = context + PropertyInserter.getProperty("dispatcher.scriptname");
        NodeID nid = NodeID.getNodeID(server, port, dispatcherPath);
        if (dle.isSslEnabled()) {
            nid.setProtocol("https");
        } else {
            nid.setProtocol("http");
        }
        return nid;
    }

    public CandidateList getCandidateList(String providerName) {
        CandidateList candidateList = this.mapCandidateListByProvider.get(providerName);
        if (candidateList != null) {
            return candidateList;
        }
        candidateList = new CandidateList(20);
        this.updateCandidateList(candidateList, providerName);
        this.mapCandidateListByProvider.put(providerName, candidateList);
        return candidateList;
    }

    private void updateCandidateList(CandidateList cl, String serviceName) {
        double inProgressFactor = this.inProgressRequestFactor.getValueAsDouble(serviceName);
        cl.setInProgressRequestFactor(inProgressFactor);
        cat.debug("Using in-progress request factor ", inProgressFactor, " for service ", serviceName);
    }

    public synchronized Map<String, CandidateList> getAllCandidateLists() {
        return new HashMap<String, CandidateList>(this.mapCandidateListByProvider);
    }

    public Iterator<Map.Entry<NodeID, ClusterNodeView>> iterator() {
        return this.nodes_by_id.entrySet().iterator();
    }

    public boolean isLocalServiceAvailable(String serviceName) {
        CandidateList cl = this.getCandidateList(serviceName);
        if (cl != null) {
            return cl.isAvailableLocally(serviceName);
        }
        cat.error("unknown service: ", serviceName);
        return false;
    }

    public void updateConfiguration(Configuration newConfiguration) {
        this.inProgressRequestFactor.updateConfiguration(newConfiguration);
        this.updateCandidateLists(newConfiguration);
    }

    private void updateCandidateLists(Configuration newConfiguration) {
        for (Map.Entry<String, CandidateList> entry : this.getAllCandidateLists().entrySet()) {
            this.updateCandidateList(entry);
        }
    }

    private void updateCandidateList(Map.Entry<String, CandidateList> entry) {
        this.updateCandidateList(entry.getValue(), entry.getKey());
    }

    @Override
    public int getCandidateListSize(String serviceName) {
        return this.getCandidateList(serviceName).size();
    }
}

