/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.p2plb.model;

import com.cognos.p2plb.model.Node;
import com.cognos.p2plb.model.NodeID;
import com.cognos.p2plb.model.NodeTime;
import java.util.Observable;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class NodeView
extends Observable
implements Node {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(NodeView.class.getName());
    public static final int UP = 1;
    public static final int DOWN = 2;
    protected int state = 1;
    protected final NodeID nodeid;
    protected double weight = 1.0;
    private boolean sslRequired = false;
    private int inProgressRequestCount = 0;
    protected NodeTime node_time = new NodeTime();
    private String edition;

    public NodeView(NodeID id) {
        this.nodeid = id;
    }

    public NodeID getNodeID() {
        return this.nodeid;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public double getWeight() {
        return this.weight;
    }

    public void setSSLRequired(boolean sslRequired) {
        this.sslRequired = sslRequired;
    }

    public boolean getSSLRequired() {
        return this.sslRequired;
    }

    public int getState() {
        if (this.nodeid.isSelf()) {
            return 1;
        }
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setState(int state) {
        if (this.nodeid.isSelf()) {
            return;
        }
        NodeView nodeView = this;
        synchronized (nodeView) {
            if (this.state != state) {
                if (cat.isDebugEnabled()) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("node ").append(this.nodeid.toString()).append(" changed state from ").append(this.state).append(" to ").append(state);
                    cat.debug(sb.toString());
                }
                this.state = state;
                this.setChanged();
                this.notifyObservers(this);
            }
        }
    }

    public NodeTime getNodeTime() {
        return this.node_time;
    }

    public void setNodeTime(NodeTime nt) {
        this.node_time.assign(nt);
    }

    public int getInProgressRequestCount() {
        return this.inProgressRequestCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementInProgressRequestCount() {
        NodeView nodeView = this;
        synchronized (nodeView) {
            ++this.inProgressRequestCount;
            if (cat.isDebugEnabled()) {
                cat.debug("incremented in-progress count for " + this.nodeid.getURI() + " to: " + this.inProgressRequestCount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrementInProgressRequestCount(int count) {
        NodeView nodeView = this;
        synchronized (nodeView) {
            this.inProgressRequestCount -= count;
            if (cat.isDebugEnabled()) {
                cat.debug("decremented in-progress count for " + this.nodeid.getURI() + " to: " + this.inProgressRequestCount);
            }
        }
    }

    public String getEdition() {
        return this.edition;
    }

    public void setEdition(String edition) {
        this.edition = edition;
    }
}

