/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.async.impl;

import com.cognos.pogo.async.impl.AsyncContextImpl;
import com.cognos.pogo.util.threads.SafeTimerTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class AsyncContextMap {
    static final Logger logger = Hierarchy.getDefaultHierarchy().getLoggerFor(AsyncContextMap.class.getName());
    private HashMap<String, AsyncContextImpl> inProgressMap = new HashMap();
    private long checkIntervalms;
    private int abandonLimit;
    private int gracePeriod;
    private Timer expiryTimer;
    private String threadName;

    AsyncContextMap(String threadName, long checkIntervalms, int abandonLimit, int gracePeriod) {
        this.threadName = threadName;
        this.checkIntervalms = checkIntervalms;
        this.abandonLimit = abandonLimit;
        this.gracePeriod = gracePeriod;
        logger.debug("Created with threadName=" + threadName + ", checkIntervalms=" + checkIntervalms + ", abandonLimit=" + abandonLimit + ", gracePeriod=" + gracePeriod);
    }

    synchronized void start() {
        if (this.expiryTimer == null) {
            this.expiryTimer = new Timer(true);
            this.expiryTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    Thread.currentThread().setName(AsyncContextMap.this.threadName);
                }
            }, 0L);
            this.expiryTimer.schedule((TimerTask)new AsyncExpiryTask(), this.checkIntervalms, this.checkIntervalms);
        }
    }

    synchronized void stop() {
        if (this.expiryTimer != null) {
            this.expiryTimer.cancel();
            this.expiryTimer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AsyncContextImpl removeContext(String conversationID) {
        HashMap<String, AsyncContextImpl> hashMap = this.inProgressMap;
        synchronized (hashMap) {
            return this.inProgressMap.remove(conversationID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addContext(String conversationID, AsyncContextImpl asContext) {
        HashMap<String, AsyncContextImpl> hashMap = this.inProgressMap;
        synchronized (hashMap) {
            this.inProgressMap.put(conversationID, asContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AsyncContextImpl getContext(String conversationID) {
        HashMap<String, AsyncContextImpl> hashMap = this.inProgressMap;
        synchronized (hashMap) {
            return this.inProgressMap.get(conversationID);
        }
    }

    class AsyncExpiryTask
    extends SafeTimerTask {
        ArrayList<AsyncContextImpl> expiredContexts = new ArrayList();

        AsyncExpiryTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void safeRun() {
            this.expiredContexts.clear();
            HashMap hashMap = AsyncContextMap.this.inProgressMap;
            synchronized (hashMap) {
                Iterator it = AsyncContextMap.this.inProgressMap.entrySet().iterator();
                while (it.hasNext()) {
                    AsyncContextImpl context;
                    AsyncContextImpl asyncContextImpl = context = (AsyncContextImpl)it.next().getValue();
                    synchronized (asyncContextImpl) {
                        if (!context.isWaitPending()) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("AsyncExpiryTask run() - skipped because no wait is pending: " + context);
                            }
                            continue;
                        }
                        int tickCount = context.bumpTickCount();
                        if (logger.isDebugEnabled()) {
                            logger.debug("AsyncExpiryTask run() - checked: " + context + " tick count=" + tickCount);
                        }
                        if (tickCount == AsyncContextMap.this.abandonLimit) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("detected abandoned async conversation: " + context);
                            }
                            this.expiredContexts.add(context);
                        }
                        if (tickCount >= AsyncContextMap.this.gracePeriod) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("remove abandoned async conversation from the context map: " + context);
                            }
                            it.remove();
                        }
                    }
                }
            }
            for (AsyncContextImpl context : this.expiredContexts) {
                context.abandonRequest();
            }
            this.expiredContexts.clear();
        }
    }
}

