/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.async.impl;

import com.cognos.pogo.async.AsyncService;
import com.cognos.pogo.async.AsyncState;
import com.cognos.pogo.async.Asyncable;
import com.cognos.pogo.async.impl.AsyncContextImpl;
import com.cognos.pogo.async.impl.AsyncContextMap;
import com.cognos.pogo.async.impl.AsyncController;
import com.cognos.pogo.async.service.AsyncBIBusXMLHelper;
import com.cognos.pogo.bibus.RequestAffinity;
import com.cognos.pogo.capacity.ServiceCapacityConfiguration;
import com.cognos.pogo.capacity.ServiceCapacityMediator;
import com.cognos.pogo.impl.MessageContextImpl;
import com.cognos.pogo.monitoring.jmx.PogoMBeanServer;
import com.cognos.pogo.monitoring.jmx.ThreadQueueMetrics;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.Handler;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import java.util.Iterator;
import java.util.Timer;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Element;

public class AsyncHandler
extends BasicHandler {
    static final Logger logger = Hierarchy.getDefaultHierarchy().getLoggerFor(AsyncHandler.class.getName());
    private static final int DEFAULT_MAXTHREADS = 5;
    private static final String MONITOR_SERVICE = "MonitorServiceRequest";
    private Handler wrappedHandler;
    private Asyncable asyncableHandler;
    private AsyncController controller;
    private AsyncContextMap contextMap;
    private Handler onCompletionHandler;
    private String serviceName;
    private int maxThreadsInt = 5;
    private Timer notificationTimer = new Timer(true);
    private String myServerGroup;
    private String connectionProperty;
    private String peakConnectionProperty;
    private boolean suspended;
    private String threadName;
    private int expiryCheckIntervalms;
    private int abandonLimit;
    private int graceLimit;

    public AsyncHandler() {
        super(logger);
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        String action;
        RequestAffinity affinity;
        BIBusEnvelope requestEnvelope = (BIBusEnvelope)mc.getProperty("request.envelope");
        String method = null;
        Element body = requestEnvelope.getBody();
        Iterator children = body.elementIterator();
        if (children.hasNext()) {
            method = ((Element)children.next()).getName();
        }
        logger.debug("rxed request for method: " + method);
        String convID = requestEnvelope.getConversationContextID();
        mc.setProperty("request.conversationContextID", convID);
        if ("release".equals(method)) {
            AsyncContextImpl context;
            AsyncService asyncService = this.asyncableHandler.getAsyncRequest(mc);
            if (asyncService == null) {
                logger.error("received an unexpected \"release\"");
                return;
            }
            logger.debug("processing a release()");
            if (convID != null) {
                context = this.contextMap.getContext(convID);
                mc.setProperty("request.asyncContextImpl", context);
            }
            asyncService.release(mc);
            if (convID != null && (context = this.removeContextFromMap(convID)) != null) {
                context.release();
            }
            return;
        }
        if (method != null && (affinity = RequestAffinity.determineAffinity(action = (String)mc.getProperty("request.soapaction"))).isProcessSpecific()) {
            this.handleAbsoluteAndControlRequests(mc, method, convID);
            return;
        }
        AsyncService service = this.asyncableHandler.getAsyncRequest(mc);
        if (service == null) {
            logger.debug("Synchronous invocation.");
            this.wrappedHandler.invoke(mc);
            if (this.onCompletionHandler != null) {
                logger.debug("invoking completion handler");
                this.onCompletionHandler.invoke(mc);
            }
            return;
        }
        this.handleAsyncRequest(mc, requestEnvelope, service);
    }

    private void handleAsyncRequest(MessageContext mc, BIBusEnvelope requestEnvelope, AsyncService service) {
        AsyncContextImpl asContext;
        MessageContext asyncMC = this.createAsyncContext(mc);
        String newId = mc.getStrProperty("request.conversationContextID");
        if (newId == null || "".equals(newId)) {
            newId = mc.getStrProperty("requestID");
        }
        if ((asContext = this.contextMap.getContext(newId)) == null) {
            asContext = new AsyncContextImpl(newId, service, asyncMC);
            asContext.setCompletionHandler(this.onCompletionHandler);
            if (!requestEnvelope.isFromService(MONITOR_SERVICE)) {
                asContext.setServiceCapacityConfiguration(new ServiceCapacityConfiguration(this.serviceName, this.myServerGroup, 0));
            }
            this.contextMap.addContext(newId, asContext);
        } else {
            asContext.resetState();
            asContext.setMessageContext(asyncMC);
            asContext.setService(service);
        }
        this.notifyCapacityChange(asContext);
        this.controller.handleRequest(asContext);
        logger.debug("invokeImpl() - waiting for done: " + asContext);
        if (!asContext.waitForDone()) {
            logger.debug("request not done within async threshold, reply working " + asContext);
            asContext.working(mc);
        } else {
            logger.debug("request completed before async threshold");
            asContext.replyNow(mc);
            if (this.conversationContextStatusIsNotComplete(mc)) {
                this.removeContextFromMap(newId);
            }
        }
    }

    private MessageContext createAsyncContext(MessageContext mc) {
        MessageContextImpl asyncMC = ((MessageContextImpl)mc).createRequestContextCopy();
        this.getPerformanceIndicator().handleAsyncContext(asyncMC);
        return asyncMC;
    }

    private boolean conversationContextStatusIsNotComplete(MessageContext mc) {
        BIBusEnvelope responseEnv = (BIBusEnvelope)mc.getProperty(mc.getResponseName() + ".envelope");
        if (responseEnv != null) {
            String status = responseEnv.getConversationContextStatus();
            if (logger.isDebugEnabled()) {
                logger.debug("Checking if conversationContextStatus is complete. response status: " + status);
            }
            if ("complete".equals(status)) {
                return false;
            }
        }
        return true;
    }

    protected void handleAbsoluteAndControlRequests(MessageContext mc, String method, String convID) {
        if (convID == null || convID.equals("")) {
            logger.error("malformed absolute affinity request, no conversation ID.");
            mc.setFault(new Fault("NO_CONVERSATION_ID"));
            return;
        }
        AsyncContextImpl asyncContext = this.contextMap.getContext(convID);
        if (asyncContext == null) {
            logger.error("received a request for a non-existent conversation: " + convID);
            mc.setFault(new Fault("NO_SUCH_CONVERSATION"));
            return;
        }
        if ("wait".equals(method)) {
            this.handleWait(asyncContext, mc);
        } else if ("cancel".equals(method)) {
            asyncContext.cancelRequest(mc);
            if (logger.isDebugEnabled()) {
                logger.debug("Removing context because of cancel");
            }
            this.removeContextFromMap(convID);
        } else if ("getOutput".equals(method)) {
            asyncContext.getOutput(mc);
            if (logger.isDebugEnabled()) {
                logger.debug("Removing context because of getOutput");
            }
            this.removeContextFromMap(convID);
        } else {
            logger.debug("unexpected  absolute affinity method: " + method);
            mc.setFault(new Fault("unexpected  absolute affinity method"));
        }
    }

    private AsyncContextImpl removeContextFromMap(String convID) {
        AsyncContextImpl context;
        if (logger.isDebugEnabled()) {
            logger.debug("removing context from map:" + convID);
        }
        if ((context = this.contextMap.removeContext(convID)) != null) {
            this.notifyCapacityChange(context);
        }
        return context;
    }

    private void notifyCapacityChange(AsyncContextImpl asContext) {
        if (asContext.getServiceCapacityConfiguration() != null) {
            int maxThreads = this.controller.getMaxThreads();
            int busyThreadCount = this.controller.getBusyThreadCount();
            ServiceCapacityConfiguration serviceCapacityConfiguration = asContext.getServiceCapacityConfiguration();
            serviceCapacityConfiguration.capacity = maxThreads - busyThreadCount;
            ServiceCapacityMediator.getInstance().notify(serviceCapacityConfiguration);
        }
    }

    private void handleWait(AsyncContextImpl asyncContext, MessageContext mc) {
        logger.debug("handleWait() - waiting for done: " + asyncContext);
        asyncContext.waitReceived(mc);
        if (asyncContext.waitForDone()) {
            if (asyncContext.getState() == AsyncState.FAULTED) {
                logger.debug("handleWait() - request is done, response is a fault");
                asyncContext.replyNow(mc);
                if (logger.isDebugEnabled()) {
                    logger.debug("Removing context because of AsyncState is FAULTED");
                }
                this.removeContextFromMap(asyncContext.getConversationID());
            } else {
                AsyncBIBusXMLHelper xmlhelper;
                logger.debug("handleWait() - request is done, response is ready: " + asyncContext);
                asyncContext.responseReady(mc);
                MessageContext asyncMessageContext = asyncContext.getMessageContext();
                if (asyncMessageContext != null && (xmlhelper = (AsyncBIBusXMLHelper)asyncMessageContext.getProperty("xmlhelper")) != null) {
                    xmlhelper.changeCompletedPrimaryToWaitResponse(mc);
                }
                if (asyncContext.getState() == AsyncState.COMPLETE) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Removing context because of AsyncState is COMPLETE");
                    }
                    this.removeContextFromMap(asyncContext.getConversationID());
                }
            }
        } else {
            logger.debug("handleWait() - request not yet done by service: " + asyncContext);
            if (asyncContext.getState() == AsyncState.CANCELLED) {
                logger.debug("handleWait() - request has been cancelled, so reply with cancelled fault");
                mc.setFault(new Fault("REQUEST_CANCELLED"));
            } else {
                logger.debug("handleWait() - reply with stillWorking");
                asyncContext.stillWorking(mc);
            }
        }
    }

    private int getIntParamHelper(String name, int defValue) throws PogoException {
        String param = this.getRequiredAttribute(logger, name);
        try {
            return Integer.parseInt(param);
        }
        catch (NumberFormatException nfx) {
            logger.error("value of parameter " + name + " is not a number: " + param);
            return defValue;
        }
    }

    @Override
    public void compose_impl(PogoEngine engine) throws PogoException {
        String handlerName = this.getRequiredAttribute(logger, "wrappedHandler");
        this.wrappedHandler = engine.getHandlerPool().find(handlerName);
        if (this.wrappedHandler == null) {
            logger.error("cannot find wrapped handler \"" + handlerName + "\"");
            throw new PogoException("cannot find wrapped handler");
        }
        try {
            this.asyncableHandler = (Asyncable)((Object)this.wrappedHandler);
        }
        catch (ClassCastException ccx) {
            logger.error("wrapped handler does not implement AsyncInvocation");
        }
        this.threadName = this.getRequiredAttribute(logger, "threadBaseName");
        logger.debug("thread base name: " + this.threadName);
        this.serviceName = ((Element)this.getConfig().selectSingleNode("/service")).attributeValue("name");
        String onCompletionHandlerName = this.getConfig().attributeValue("onCompletionHandler");
        if (onCompletionHandlerName == null || onCompletionHandlerName.length() == 0) {
            logger.debug("no onCompletionHandler configured.");
        } else {
            logger.debug("configured name of onCompletionHandler is " + onCompletionHandlerName);
            this.onCompletionHandler = engine.getHandlerPool().find(onCompletionHandlerName);
            if (this.onCompletionHandler == null) {
                logger.error("cannot resolve onCompletionHandler.");
            } else {
                logger.debug("Resolved onCompletionHandler to " + this.onCompletionHandler.getName());
            }
        }
        this.connectionProperty = this.getOptionalAttribute("connectionProperty");
        this.peakConnectionProperty = this.getOptionalAttribute("peakConnectionProperty");
        if (this.peakConnectionProperty == null || this.peakConnectionProperty.length() < 1) {
            this.peakConnectionProperty = this.connectionProperty;
        }
        if (this.connectionProperty == null || this.connectionProperty.length() < 1) {
            String maxThreads = this.getOptionalAttribute("maxThreads");
            try {
                if (maxThreads != null && maxThreads.length() > 0) {
                    this.maxThreadsInt = Integer.parseInt(maxThreads);
                    if (this.maxThreadsInt < 1) {
                        this.maxThreadsInt = 5;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        ThreadQueueMetrics threadQueueMetrics = new ThreadQueueMetrics("threadQueue", this.serviceName);
        PogoMBeanServer.getInstance().registerMBean(threadQueueMetrics, this.serviceName);
        this.controller = new AsyncController(this.threadName, this.maxThreadsInt, threadQueueMetrics);
        this.expiryCheckIntervalms = this.getIntParamHelper("expiryCheckIntervalms", 5000);
        this.abandonLimit = this.getIntParamHelper("abandonLimit", 6);
        this.graceLimit = this.getIntParamHelper("graceLimit", 12);
        this.contextMap = new AsyncContextMap(this.threadName + "expiry", this.expiryCheckIntervalms, this.abandonLimit, this.graceLimit);
    }

    @Override
    public void start() {
        this.contextMap.start();
    }

    @Override
    public void stop() {
        ServiceCapacityMediator.getInstance().notify(new ServiceCapacityConfiguration(this.serviceName, this.myServerGroup, 0));
        this.suspended = true;
        if (this.contextMap != null) {
            this.contextMap.stop();
        }
        this.notificationTimer.cancel();
    }

    @Override
    public void suspend(boolean immediate) {
        ServiceCapacityMediator.getInstance().notify(new ServiceCapacityConfiguration(this.serviceName, this.myServerGroup, 0));
        this.suspended = true;
        super.suspend(immediate);
    }

    @Override
    public void resume() {
        ServiceCapacityMediator.getInstance().notify(new ServiceCapacityConfiguration(this.serviceName, this.myServerGroup, this.maxThreadsInt));
        this.suspended = false;
        super.resume();
    }

    @Override
    public void configure(Configuration configuration) {
        String inPeakDemandPeriod = configuration.getValue("inPeakDemandPeriod");
        String currentConnectionProperty = this.connectionProperty;
        if ("true".equalsIgnoreCase(inPeakDemandPeriod)) {
            currentConnectionProperty = this.peakConnectionProperty;
        }
        if (currentConnectionProperty != null && currentConnectionProperty.length() > 0) {
            String maxConnectionsStr = configuration.getValue(currentConnectionProperty);
            this.getConnectionValue(maxConnectionsStr);
            this.controller.setMaxThreads(this.maxThreadsInt);
        }
        this.myServerGroup = configuration.getLocalServerGroup();
        if (this.suspended) {
            ServiceCapacityMediator.getInstance().notify(new ServiceCapacityConfiguration(this.serviceName, this.myServerGroup, 0));
        } else {
            ServiceCapacityMediator.getInstance().notify(new ServiceCapacityConfiguration(this.serviceName, this.myServerGroup, this.maxThreadsInt));
        }
    }

    private void getConnectionValue(String maxConnectionsStr) {
        try {
            this.maxThreadsInt = Integer.parseInt(maxConnectionsStr);
        }
        catch (NumberFormatException ex) {
            if (logger.isWarnEnabled()) {
                StringBuffer strBuf = new StringBuffer("The value of runtime property '");
                strBuf.append(this.connectionProperty);
                strBuf.append("' does not contain a valid value (");
                strBuf.append(maxConnectionsStr);
                strBuf.append(")");
                logger.warn(strBuf.toString());
            }
            this.maxThreadsInt = 5;
        }
    }

    @Override
    public void reconfigure(Configuration configuration) {
        this.configure(configuration);
    }

    public String getThreadBaseName() {
        return this.threadName;
    }

    public int getExpiryCheckIntervalms() {
        return this.expiryCheckIntervalms;
    }

    public int getAbandonLimit() {
        return this.abandonLimit;
    }

    public int getGraceLimit() {
        return this.graceLimit;
    }

    public String getConnectionProperty() {
        return this.connectionProperty;
    }

    public String getPeakConnectionProperty() {
        return this.peakConnectionProperty;
    }

    public int getMaxThreadsInt() {
        return this.maxThreadsInt;
    }

    public String getWrappedHandlerName() {
        return this.wrappedHandler != null ? this.wrappedHandler.getClass().getName() : null;
    }
}

