/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.async.impl;

import com.cognos.pogo.async.impl.AsyncContextImpl;
import com.cognos.pogo.async.impl.AsyncController;
import com.cognos.pogo.util.threads.SafeThread;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class AsyncRequestThread
extends SafeThread {
    static final Logger logger = Hierarchy.getDefaultHierarchy().getLoggerFor(AsyncRequestThread.class.getName());
    private AsyncController controller;
    boolean alive = true;
    AsyncContextImpl asContext = null;

    AsyncRequestThread(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void safeRun() {
        while (this.alive) {
            try {
                if (!this.alive) break;
                while (this.alive && this.asContext != null) {
                    logger.debug("invoking runRequest on " + this.asContext);
                    this.asContext.runRequest(this);
                    logger.debug("returned from runRequest on " + this.asContext);
                    this.asContext = null;
                    if (!this.alive) continue;
                    logger.debug("tell controller this thread can run another request");
                    this.controller.notifyThreadAvailable(this);
                }
                if (!this.alive) break;
                AsyncRequestThread asyncRequestThread = this;
                synchronized (asyncRequestThread) {
                    try {
                        if (this.asContext == null) {
                            logger.debug("waiting for another request.");
                            this.wait();
                            logger.debug("woke up");
                        } else {
                            logger.debug("Async context not null, checking again");
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            catch (RuntimeException e) {
                logger.error("runtme exception in async thread", (Throwable)e);
            }
        }
        logger.debug("stopping.");
    }

    void setController(AsyncController controller) {
        this.controller = controller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminate() {
        AsyncRequestThread asyncRequestThread = this;
        synchronized (asyncRequestThread) {
            this.alive = false;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void wakeForRequest(AsyncContextImpl asContext) {
        logger.debug("wakeForRequest() - " + asContext);
        AsyncRequestThread asyncRequestThread = this;
        synchronized (asyncRequestThread) {
            this.asContext = asContext;
            this.notify();
        }
    }

    void setRequest(AsyncContextImpl asContext) {
        logger.debug("setRequest() - " + asContext);
        this.asContext = asContext;
    }
}

