/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.async.service;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.MessageContextValue;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.pogo.util.PogoLogger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class AsyncBIBusXMLHelper
implements MessageContextValue {
    static final PogoLogger logger = PogoLogger.getLogger();
    private static final int DEFAULT_PRIMARY_WAIT_THRESHOLD = 7;
    private static final int DEFAULT_SECONDARY_WAIT_THRESHOLD = 30;
    private static final boolean DEFAULT_ALWAYS_INCLUDE_PRIMARY_REQUEST = false;
    private static final String TRUE = "true";
    private static final String CANCEL = "cancel";
    private static final String RELEASE = "release";
    private static final String RUN = "run";
    private static final String RUN_SPECIFICATION = "runSpecification";
    private static final String VALIDATE = "validate";
    private static final String VALIDATE_SPECIFICATION = "validateSpecification";
    private static final String WAIT = "wait";
    private static final String COMPLETE = "complete";
    private static final String CONVERSATION = "conversation";
    private static final String CONVERSATION_COMPLETE = "conversationComplete";
    private static final String STILL_WORKING = "stillWorking";
    private static final String WORKING = "working";
    private static final String GET_OUTPUT = "getOutput";
    private static final String PRIMARY_WAIT_THRESHOLD = "primaryWaitThreshold";
    private static final String SECONDARY_WAIT_THRESHOLD = "secondaryWaitThreshold";
    private static final String OPTIONS_STR = "options";
    private static final String NAME_STR = "name";
    private static final String VALUE_STR = "value";
    private static final String ALWAYS_INCLUDE_PRIMARY_REQUEST = "alwaysIncludePrimaryRequest";
    private static final String SPECIFICATION = "specification";
    private static final String PARAMETER_VALUES = "parameterValues";
    private static final QName PRIMARY_REQUEST = DocumentHelper.createQName((String)"primaryRequest");
    private static final QName WAIT_RESPONSE = DocumentHelper.createQName((String)"waitResponse");
    private static final QName CANCEL_RESPONSE = DocumentHelper.createQName((String)"cancelResponse");
    private static final QName RELEASE_RESPONSE = DocumentHelper.createQName((String)"releaseResponse");
    private static final QName GET_OUTPUT_RESPONSE = DocumentHelper.createQName((String)"getOutputResponse");
    private static final QName RESULT = DocumentHelper.createQName((String)"result");
    private static final QName STATUS = DocumentHelper.createQName((String)"status");
    private static final QName ITEM = DocumentHelper.createQName((String)"item");
    private static final QName NAME = DocumentHelper.createQName((String)"name");
    private static final QName PARAMETER_VALUE_ARRAY = DocumentHelper.createQName((String)"parameterValueArray");
    private static final QName OPTION_ARRAY = DocumentHelper.createQName((String)"optionArray");
    private static final QName DETAIL_ARRAY = DocumentHelper.createQName((String)"optionArray");
    private static final QName PARAMETERS = DocumentHelper.createQName((String)"parameters");
    private static final QName OPTIONS = DocumentHelper.createQName((String)"options");
    private static final QName DETAILS = DocumentHelper.createQName((String)"details");
    private static final QName SECONDARY_REQUESTS = DocumentHelper.createQName((String)"secondaryRequests");
    private static final QName BUS_ASYNC_REQUEST = DocumentHelper.createQName((String)"asynchRequest", (Namespace)BIBusEnvelope.NS_BUS);
    private static final QName BUS_ASYNC_REPLY = DocumentHelper.createQName((String)"asynchReply", (Namespace)BIBusEnvelope.NS_BUS);
    private static final QName BUS_ASYNC_PARAMETERS = DocumentHelper.createQName((String)"parameters", (Namespace)BIBusEnvelope.NS_BUS);
    private static final QName BUS_ASYNC_SECONDARY_REQUEST = DocumentHelper.createQName((String)"asynchSecondaryRequest", (Namespace)BIBusEnvelope.NS_BUS);
    private static final QName BUS_ASYNC_REPLY_STATUS_ENUM = DocumentHelper.createQName((String)"asynchReplyStatusEnum", (Namespace)BIBusEnvelope.NS_BUS);
    private static final QName BUS_SPECIFICATION = DocumentHelper.createQName((String)"specification", (Namespace)BIBusEnvelope.NS_BUS);
    private static final QName BUS_ASYNC_SPECIFICATION = DocumentHelper.createQName((String)"asynchSpecification", (Namespace)BIBusEnvelope.NS_BUS);
    private boolean getOutputRequired = false;
    private boolean alwaysIncludePrimaryRequest = false;
    private String primaryRequestName;
    private Element primaryRequestElement;

    private Namespace getNamespaceForPrefix(Element element, String prefix) {
        String thisMethod = "AsyncBIBusXMLHelper.getNamespacesForPrefix: ";
        logger.debug(thisMethod, " looking for namespace for prefix ", prefix);
        while (element != null) {
            Namespace ns = element.getNamespaceForPrefix(prefix);
            if (ns != null) {
                logger.debug(thisMethod, " found namespace ", ns.getStringValue());
                return ns;
            }
            element = element.getParent();
        }
        return null;
    }

    private void sortNamespacesRecursive(Map<String, String> nsMap, Element requestElem, Element targetRoot, Element target) {
        String thisMethod = "AsyncBIBusXMLHelper.sortNamespacesRecursive: ";
        Iterator attributeIter = target.attributeIterator();
        while (attributeIter.hasNext()) {
            Namespace namespace;
            String namePrefix;
            Attribute attr = (Attribute)attributeIter.next();
            String value = attr.getValue();
            int prefixEndIndex = value.indexOf(":");
            if (prefixEndIndex <= 0 || this.getNamespaceForPrefix(target, namePrefix = value.substring(0, prefixEndIndex)) != null || (namespace = this.getNamespaceForPrefix(requestElem, namePrefix)) == null) continue;
            logger.debug(thisMethod, " addNamespace ", namePrefix, " ", namespace.getURI());
            nsMap.put(namePrefix, namespace.getURI());
        }
        Iterator childElementIterator = target.elementIterator();
        while (childElementIterator.hasNext()) {
            this.sortNamespacesRecursive(nsMap, requestElem, targetRoot, (Element)childElementIterator.next());
        }
    }

    private void sortNamespaces(Element requestElem, Element targetRoot) {
        String thisMethod = "AsyncBIBusXMLHelper.sortNamespaces: ";
        HashMap<String, String> nsMap = new HashMap<String, String>();
        this.sortNamespacesRecursive(nsMap, requestElem, targetRoot, targetRoot);
        for (String prefix : nsMap.keySet()) {
            String ns = (String)nsMap.get(prefix);
            logger.debug(thisMethod, " adding prefix ", prefix, " for ns ", ns);
            targetRoot.addNamespace(prefix, ns);
        }
    }

    private void addSecondaryRequest(Element secondaryRequests, String request) {
        Element itemElement = secondaryRequests.addElement(ITEM);
        itemElement.addAttribute(BIBusEnvelope.XSI_TYPE, BUS_ASYNC_SECONDARY_REQUEST.getQualifiedName());
        Element nameElement = itemElement.addElement(NAME);
        nameElement.addAttribute(BIBusEnvelope.XSI_TYPE, SOAPEnvelope.XSD_STRING);
        nameElement.setText(request);
        Element optionsElement = itemElement.addElement(OPTIONS);
        optionsElement.addAttribute(SOAPEnvelope.XSI_TYPE, OPTION_ARRAY.getQualifiedName());
        optionsElement.addAttribute(SOAPEnvelope.XSI_NIL, TRUE);
        Element paramsElement = itemElement.addElement(PARAMETERS);
        paramsElement.addAttribute(SOAPEnvelope.XSI_TYPE, PARAMETER_VALUE_ARRAY.getQualifiedName());
        paramsElement.addAttribute(SOAPEnvelope.XSI_NIL, TRUE);
    }

    private Element transformElement(Element element) {
        Element transformedElement;
        if (element.getName().equals(SPECIFICATION)) {
            transformedElement = DocumentHelper.createElement((QName)BUS_SPECIFICATION);
            transformedElement.addAttribute(BIBusEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
            transformedElement.addAttribute(BIBusEnvelope.SOAP_ENC_ARRAYTYPE, BUS_ASYNC_SPECIFICATION.getQualifiedName() + "[1]");
            Element item = element.createCopy(ITEM);
            transformedElement.add(item);
        } else {
            transformedElement = element.getName().equals(PARAMETER_VALUES) ? element.createCopy(BUS_ASYNC_PARAMETERS) : element.createCopy();
        }
        return transformedElement;
    }

    public static boolean getAlwaysIncludePrimaryRequest(Element request) {
        boolean alwaysIncludePrimaryRequest = false;
        List list = request.elements(OPTIONS_STR);
        if (!list.isEmpty()) {
            Element options = (Element)list.get(0);
            Iterator itElems = options.elementIterator();
            while (itElems.hasNext()) {
                Element option = (Element)itElems.next();
                Element name = (Element)option.elements(NAME_STR).get(0);
                if (!name.getText().equals(ALWAYS_INCLUDE_PRIMARY_REQUEST)) continue;
                Element value = (Element)option.elements(VALUE_STR).get(0);
                alwaysIncludePrimaryRequest = Boolean.valueOf(value.getText());
                break;
            }
        }
        return alwaysIncludePrimaryRequest;
    }

    public static int getPrimaryWaitThreshold(Element request) {
        int primaryWaitThreshold = 7;
        List list = request.elements(OPTIONS_STR);
        if (!list.isEmpty()) {
            Element options = (Element)list.get(0);
            Iterator itElems = options.elementIterator();
            while (itElems.hasNext()) {
                Element option = (Element)itElems.next();
                Element name = (Element)option.elements(NAME_STR).get(0);
                if (!name.getText().equals(PRIMARY_WAIT_THRESHOLD)) continue;
                Element value = (Element)option.elements(VALUE_STR).get(0);
                primaryWaitThreshold = Integer.parseInt(value.getText());
                break;
            }
        }
        return primaryWaitThreshold;
    }

    public static int getSecondaryWaitThreshold(MessageContext mc) {
        int secondaryWaitThreshold = 30;
        BIBusEnvelope reqEnv = (BIBusEnvelope)mc.getProperty("request.envelope");
        Iterator itElems = reqEnv.getBody().elementIterator();
        if (!itElems.hasNext()) {
            logger.error("empty body");
            return secondaryWaitThreshold;
        }
        Element request = (Element)itElems.next();
        List list = request.elements(OPTIONS_STR);
        if (!list.isEmpty()) {
            Element options = (Element)list.get(0);
            itElems = options.elementIterator();
            while (itElems.hasNext()) {
                Element option = (Element)itElems.next();
                Element name = (Element)option.elements(NAME_STR).get(0);
                if (!name.getText().equals(SECONDARY_WAIT_THRESHOLD)) continue;
                Element value = (Element)option.elements(VALUE_STR).get(0);
                secondaryWaitThreshold = Integer.parseInt(value.getText());
                break;
            }
        }
        return secondaryWaitThreshold;
    }

    public void cachePrimaryRequestInfo(BIBusEnvelope request, boolean alwaysIncludePrimaryRequest) {
        String thisMethod = "AsyncBIBusXMLHelper.cachePrimaryRequestInfo";
        logger.debug(thisMethod, " start");
        this.alwaysIncludePrimaryRequest = alwaysIncludePrimaryRequest;
        logger.debug(thisMethod, "create");
        this.primaryRequestElement = DocumentHelper.createElement((String)PRIMARY_REQUEST.getName());
        this.primaryRequestElement.addAttribute(BIBusEnvelope.XSI_TYPE, BUS_ASYNC_REQUEST.getQualifiedName());
        Element requestBody = request.getBody();
        List bodyContent = requestBody.content();
        logger.debug(thisMethod, "Body content size ", bodyContent.size());
        Element requestBodyMethod = null;
        for (int i = 0; i < bodyContent.size(); ++i) {
            if (!(bodyContent.get(i) instanceof Element)) continue;
            requestBodyMethod = (Element)bodyContent.get(i);
            break;
        }
        logger.debug(thisMethod, "method = ", requestBodyMethod.getName());
        this.primaryRequestName = requestBodyMethod.getName();
        Element conversation = null;
        if (this.primaryRequestName.equals(RUN) || this.primaryRequestName.equals(RUN_SPECIFICATION) || this.primaryRequestName.equals(VALIDATE_SPECIFICATION) || this.primaryRequestName.equals(VALIDATE)) {
            List content = requestBodyMethod.content();
            for (int i = 0; i < content.size(); ++i) {
                if (!(content.get(i) instanceof Element)) continue;
                Element childElem = (Element)content.get(i);
                Element childElemCopy = this.transformElement(childElem);
                logger.debug(thisMethod, "add child element name ", childElem.getName());
                this.primaryRequestElement.add(childElemCopy);
            }
        } else if (this.primaryRequestName.equals(WAIT) || this.primaryRequestName.equals(CANCEL) || this.primaryRequestName.equals(RELEASE)) {
            List content = requestBodyMethod.content();
            logger.debug(thisMethod, " Body Method content size ", content.size());
            for (int i = 0; i < content.size(); ++i) {
                if (!(content.get(i) instanceof Element)) continue;
                Element elem = (Element)content.get(i);
                logger.debug(thisMethod, "Body Method content element ", i, " ", elem.getName());
                if (!elem.getName().equals(CONVERSATION)) continue;
                conversation = (Element)content.get(i);
                break;
            }
            if (conversation != null) {
                List arContent = conversation.content();
                logger.debug(thisMethod, "asynchRequest content size ", arContent.size());
                for (int i = 0; i < arContent.size(); ++i) {
                    if (!(arContent.get(i) instanceof Element)) continue;
                    Element childElem = (Element)arContent.get(i);
                    Element childElemCopy = childElem.createCopy();
                    this.primaryRequestElement.add(childElemCopy);
                    logger.debug(thisMethod, "added child element name ", childElemCopy.getName());
                }
            }
        }
        if (conversation != null) {
            this.sortNamespaces(conversation, this.primaryRequestElement);
        } else if (requestBodyMethod != null) {
            // empty if block
        }
    }

    public void prepareCompletedPrimaryResponse(MessageContext mc) {
        BIBusEnvelope response = (BIBusEnvelope)mc.getProperty("response.envelope");
        Element body = response.getBody();
        String methodResponseName = this.primaryRequestName + "Response";
        Element methodResponseEl = body.element(methodResponseName);
        Element resultEl = null;
        if (methodResponseEl == null) {
            methodResponseEl = body.addElement(methodResponseName);
        } else {
            resultEl = methodResponseEl.element("result");
        }
        if (resultEl == null) {
            resultEl = methodResponseEl.addElement(RESULT);
        }
        resultEl.addAttribute(BIBusEnvelope.XSI_TYPE, BUS_ASYNC_REPLY.getQualifiedName());
        if (resultEl.element("details") == null) {
            Element details = resultEl.addElement(DETAILS);
            details.addAttribute(SOAPEnvelope.XSI_TYPE, DETAIL_ARRAY.getQualifiedName());
            details.addAttribute(SOAPEnvelope.XSI_NIL, TRUE);
        }
        if (resultEl.element("primaryRequest") == null) {
            resultEl.add(this.primaryRequestElement.createCopy());
        }
        if (resultEl.element("secondaryRequests") == null) {
            Element secondaryRequests = resultEl.addElement(SECONDARY_REQUESTS);
            response.addRequiredEnvNamespaces(secondaryRequests);
            secondaryRequests.addAttribute(BIBusEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
            if (this.getOutputRequired) {
                secondaryRequests.addAttribute(BIBusEnvelope.SOAP_ENC_ARRAYTYPE, BUS_ASYNC_SECONDARY_REQUEST.getQualifiedName() + "[1]");
                this.addSecondaryRequest(secondaryRequests, GET_OUTPUT);
            } else {
                secondaryRequests.addAttribute(BIBusEnvelope.SOAP_ENC_ARRAYTYPE, BUS_ASYNC_SECONDARY_REQUEST.getQualifiedName() + "[0]");
            }
        }
        if (resultEl.element("status") == null) {
            Element status = resultEl.addElement(STATUS);
            status.addAttribute(BIBusEnvelope.XSI_TYPE, BUS_ASYNC_REPLY_STATUS_ENUM.getQualifiedName());
            if (this.getOutputRequired) {
                status.setText(COMPLETE);
                response.setConversationContextStatus(COMPLETE);
            } else {
                status.setText(CONVERSATION_COMPLETE);
                response.setConversationContextStatus(CONVERSATION_COMPLETE);
            }
        }
    }

    public void changeCompletedPrimaryToWaitResponse(MessageContext mc) {
        BIBusEnvelope response = (BIBusEnvelope)mc.getProperty("response.envelope");
        Element methodResponse = response.getBody().element(this.primaryRequestName + "Response");
        if (methodResponse == null) {
            String msg = "did not find " + this.primaryRequestName + "Response element in response body";
            logger.error(msg);
            mc.setFault(new Fault(msg));
            return;
        }
        Element resultEl = methodResponse.element("result");
        if (resultEl == null) {
            String msg = "did not find result element in method response body";
            logger.error(msg);
            mc.setFault(new Fault(msg));
            return;
        }
        resultEl.detach();
        methodResponse.detach();
        Element waitResponse = response.getBody().addElement(WAIT_RESPONSE);
        waitResponse.add(resultEl);
    }

    public void prepareWorkingResponse(MessageContext mc) {
        BIBusEnvelope response = (BIBusEnvelope)mc.getProperty("response.envelope");
        QName PRIMARY_REQUEST_RESPONSE = DocumentHelper.createQName((String)(this.primaryRequestName + "Response"));
        Element waitResponse = response.getBody().addElement(PRIMARY_REQUEST_RESPONSE);
        response.addRequiredEnvNamespaces(waitResponse);
        Element result = waitResponse.addElement(RESULT);
        result.addAttribute(BIBusEnvelope.XSI_TYPE, BUS_ASYNC_REPLY.getQualifiedName());
        Element details = result.addElement(DETAILS);
        details.addAttribute(SOAPEnvelope.XSI_TYPE, DETAIL_ARRAY.getQualifiedName());
        details.addAttribute(SOAPEnvelope.XSI_NIL, TRUE);
        if (this.alwaysIncludePrimaryRequest) {
            result.add(this.primaryRequestElement.createCopy());
        }
        Element secondaryRequests = result.addElement(SECONDARY_REQUESTS);
        response.addRequiredEnvNamespaces(secondaryRequests);
        secondaryRequests.addAttribute(BIBusEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
        secondaryRequests.addAttribute(BIBusEnvelope.SOAP_ENC_ARRAYTYPE, BUS_ASYNC_SECONDARY_REQUEST.getQualifiedName() + "[2]");
        this.addSecondaryRequest(secondaryRequests, WAIT);
        this.addSecondaryRequest(secondaryRequests, CANCEL);
        Element status = result.addElement(STATUS);
        status.addAttribute(BIBusEnvelope.XSI_TYPE, BUS_ASYNC_REPLY_STATUS_ENUM.getQualifiedName());
        status.setText(WORKING);
        response.setConversationContextStatus(WORKING);
    }

    public void prepareStillWorkingResponse(MessageContext mc) {
        BIBusEnvelope response = (BIBusEnvelope)mc.getProperty("response.envelope");
        Element waitResponse = response.getBody().addElement(WAIT_RESPONSE);
        response.addRequiredEnvNamespaces(waitResponse);
        Element result = waitResponse.addElement(RESULT);
        result.addAttribute(BIBusEnvelope.XSI_TYPE, BUS_ASYNC_REPLY.getQualifiedName());
        Element details = result.addElement(DETAILS);
        details.addAttribute(SOAPEnvelope.XSI_TYPE, DETAIL_ARRAY.getQualifiedName());
        details.addAttribute(SOAPEnvelope.XSI_NIL, TRUE);
        if (this.alwaysIncludePrimaryRequest) {
            result.add(this.primaryRequestElement.createCopy());
        }
        Element secondaryRequests = result.addElement(SECONDARY_REQUESTS);
        response.addRequiredEnvNamespaces(secondaryRequests);
        secondaryRequests.addAttribute(BIBusEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
        secondaryRequests.addAttribute(BIBusEnvelope.SOAP_ENC_ARRAYTYPE, BUS_ASYNC_SECONDARY_REQUEST.getQualifiedName() + "[2]");
        this.addSecondaryRequest(secondaryRequests, WAIT);
        this.addSecondaryRequest(secondaryRequests, CANCEL);
        Element status = result.addElement(STATUS);
        status.addAttribute(BIBusEnvelope.XSI_TYPE, BUS_ASYNC_REPLY_STATUS_ENUM.getQualifiedName());
        status.setText(STILL_WORKING);
        response.setConversationContextStatus(STILL_WORKING);
    }

    public void prepareCancelResponse(MessageContext mc) {
        BIBusEnvelope response = (BIBusEnvelope)mc.getProperty("response.envelope");
        Element body = response.getBody();
        Element methodResponseEl = body.element(CANCEL_RESPONSE.getName());
        if (methodResponseEl == null) {
            response.getBody().addElement(CANCEL_RESPONSE);
        }
    }

    public void prepareReleaseResponse(MessageContext mc) {
        BIBusEnvelope response = (BIBusEnvelope)mc.getProperty("response.envelope");
        Element body = response.getBody();
        Element methodResponseEl = body.element(RELEASE_RESPONSE.getName());
        if (methodResponseEl == null) {
            response.getBody().addElement(RELEASE_RESPONSE);
        }
    }

    public void prepareGetOutputResponse(MessageContext mc) {
        BIBusEnvelope response = (BIBusEnvelope)mc.getProperty("response.envelope");
        Element body = response.getBody();
        Element methodResponseEl = body.element(GET_OUTPUT_RESPONSE.getName());
        if (methodResponseEl == null) {
            response.getBody().addElement(GET_OUTPUT_RESPONSE);
        }
    }

    public void setPrimaryRequestElementForTesting() {
        this.primaryRequestElement = DocumentHelper.createElement((String)PRIMARY_REQUEST.getName());
        this.primaryRequestElement.addAttribute(BIBusEnvelope.XSI_TYPE, BUS_ASYNC_REQUEST.getQualifiedName());
    }
}

