/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.auth;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.SigningSession;
import com.cognos.cclcfgapi.base64;
import com.cognos.pogo.bibus.CryptoFacility;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.RequestModifier;
import com.cognos.pogo.pdk.common.FormFieldVars;
import com.cognos.pogo.util.NameValuePair;
import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.URLEncoderDecoder;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.Principal;
import java.util.List;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;

public class CAMSystemRecoverableHandler
implements RequestModifier {
    private static final PogoLogger log = PogoLogger.getLogger();
    private static final String CAM_SECURITY_BLOB_REQUEST = "CAM_SecurityBlob=";
    private static final String CAM_SECURITY_BLOB_FORM = "CAM_SecurityBlob";
    private static final String CAM_CHECK_GATEWAY_FORM = "CAMCheckGateway";
    private static final String CAM_CHECK_GATEWAY_REQUEST = "CAMCheckGateway=";
    private static final String CAM_LOGONAS = "h_CAM_action=logonAs";
    private static final String CAM_NAMESPACE_REQUEST = "CAMNamespace=";
    private static final String ENV_VER = "Type=";
    private static final String ENV_DELIMITER = " , ";
    private static final String HASH_DELIMITER = " : ";
    private static final int ENV_BLOB = 1;
    private static final int IMPUSR_BLOB = 2;
    private static final String KERBEROS_DELIMITER = ":";
    private static final String KERBEROS_ERROR_FLAG = "1";
    private static final String KERBEROS_NO_BLOB_FLAG = "0";
    private static final int INITIAL_SIZE_FOR_REQUEST_FORM_FIELDS = 256;
    protected CAMFactory camFactory;
    protected boolean handleFailure;
    private int ssoType = 1;
    private String sequenceNumber = "";

    private Vector<String> getAskedEnvVariable(String securityBlob) {
        Vector<String> envVector = new Vector<String>();
        log.debug("Attempting to get environment variables from securityBlob: ", securityBlob);
        if (securityBlob != null) {
            byte[] decBlob = base64.decode((int)0, (String)securityBlob);
            String decodedSecurityBlob = new String(decBlob, 0, decBlob.length);
            log.debug("Decoded security blob: ", decodedSecurityBlob);
            if (decodedSecurityBlob.indexOf(ENV_VER) == 0) {
                this.ssoType = 1;
                String tempString = decodedSecurityBlob.substring(ENV_VER.length());
                char type = tempString.charAt(0);
                if (Character.getNumericValue(type) == 1) {
                    int beforePos;
                    String envString = tempString.substring(1);
                    int delimiterLen = ENV_DELIMITER.length();
                    while ((beforePos = envString.indexOf(ENV_DELIMITER)) != -1) {
                        int afterPos = envString.indexOf(ENV_DELIMITER, beforePos += delimiterLen);
                        String env = afterPos != -1 ? envString.substring(beforePos, afterPos) : envString.substring(beforePos);
                        log.debug("Found env variable: ", env);
                        envVector.add(env);
                        if (afterPos != -1) {
                            envString = envString.substring(afterPos);
                            continue;
                        }
                        break;
                    }
                } else {
                    this.handleFailure = true;
                }
            } else {
                this.ssoType = 2;
                log.debug("This is Kerberos securityBlb, the decodeBob is" + decodedSecurityBlob);
                this.parseKerberosRequest(decodedSecurityBlob);
                this.handleFailure = false;
            }
        }
        return envVector;
    }

    private void parseKerberosRequest(String decodeSecurityBlob) {
        if (decodeSecurityBlob == null) {
            return;
        }
        int index = decodeSecurityBlob.indexOf(KERBEROS_DELIMITER);
        if (index != -1 && index != 0) {
            this.sequenceNumber = decodeSecurityBlob.substring(0, index);
        }
        log.debug("Found Kerberos sequenceNumber: " + this.sequenceNumber);
    }

    protected String setRespSecurityBlob(HttpServletRequest request, Vector<String> envNameVector, boolean urlEncode) {
        String encBlob = null;
        if (this.ssoType == 1) {
            try {
                SigningSession camSignSession = this.camFactory.createSigningSession();
                String envValue = null;
                if (!this.handleFailure) {
                    StringBuffer respSecurityBlob = new StringBuffer(200);
                    respSecurityBlob.append(ENV_VER);
                    respSecurityBlob.append(1);
                    int vectorSize = envNameVector.size();
                    log.debug("CAM has asked for ", vectorSize, " variables");
                    for (int i = 0; i < vectorSize; ++i) {
                        String envName = envNameVector.elementAt(i).toString();
                        log.debug("Attempting to get: ", envName);
                        if (envName.equalsIgnoreCase("REMOTE_USER")) {
                            envValue = request.getRemoteUser();
                        } else if (envName.equalsIgnoreCase("AUTH_TYPE")) {
                            envValue = request.getAuthType();
                        } else if (envName.equalsIgnoreCase("REMOTE_ADDR")) {
                            envValue = request.getRemoteAddr();
                        } else if (envName.equalsIgnoreCase("REMOTE_HOST")) {
                            envValue = request.getRemoteHost();
                        } else if (envName.equalsIgnoreCase("REQUEST_METHOD")) {
                            envValue = request.getMethod();
                        } else if (envName.equalsIgnoreCase("PATH_INFO")) {
                            envValue = request.getPathInfo();
                        } else if (envName.equalsIgnoreCase("USER_PRINCIPAL")) {
                            Principal principal = request.getUserPrincipal();
                            if (principal != null) {
                                log.debug("***Principal = ", principal.getName());
                                envValue = principal.getName();
                            }
                        } else {
                            envValue = request.getHeader(envName);
                            if ((envValue == null || envValue.equals("")) && (envName.startsWith("http_") || envName.startsWith("HTTP_"))) {
                                envValue = request.getHeader(envName.substring(5));
                            }
                        }
                        respSecurityBlob.append(ENV_DELIMITER);
                        respSecurityBlob.append(envName);
                        respSecurityBlob.append("=");
                        if (envValue == null) continue;
                        StringBuffer escapedEnvValue = new StringBuffer(envValue.length() * 2 + 1);
                        this.escapeEnvValue(envValue, escapedEnvValue);
                        respSecurityBlob.append(escapedEnvValue);
                    }
                    log.debug("***respSecurityBlob = ", respSecurityBlob);
                    byte[] binHMAC = camSignSession.hmac(respSecurityBlob.toString().getBytes("UTF-8"));
                    StringBuffer finalRespSecurityBlob = new StringBuffer();
                    finalRespSecurityBlob.append(respSecurityBlob.toString());
                    finalRespSecurityBlob.append(HASH_DELIMITER);
                    byte[] textPart = finalRespSecurityBlob.toString().getBytes("UTF-8");
                    byte[] finalBlob = new byte[textPart.length + binHMAC.length];
                    System.arraycopy(textPart, 0, finalBlob, 0, textPart.length);
                    System.arraycopy(binHMAC, 0, finalBlob, textPart.length, binHMAC.length);
                    encBlob = this.base64URLEncode(finalBlob, urlEncode);
                }
            }
            catch (Exception e) {
                log.error("Caught exception in setRespSecurityBlob()", e);
                this.handleFailure = true;
            }
        } else {
            String blobBuffer = this.sequenceNumber + KERBEROS_DELIMITER + KERBEROS_ERROR_FLAG + KERBEROS_DELIMITER + KERBEROS_NO_BLOB_FLAG + KERBEROS_DELIMITER + "";
            log.debug("set Kerberos blob back: " + blobBuffer);
            encBlob = this.base64URLEncode(blobBuffer.getBytes(), urlEncode);
            log.debug("encoded Kerberos blob: " + encBlob);
        }
        return encBlob;
    }

    private final String base64URLEncode(byte[] finalBlob, boolean urlEncode) {
        String encBlob = null;
        String b64blob = base64.encode((int)0, (byte[])finalBlob);
        log.debug("Security blob before URL encoding", b64blob);
        if (urlEncode) {
            encBlob = this.urlEncode(b64blob);
            log.debug("Security blob after URL encoding", encBlob);
        } else {
            log.debug("URL encoding not necessary");
            encBlob = b64blob;
        }
        return encBlob;
    }

    String urlEncode(String b64blob) {
        try {
            return URLEncoder.encode(b64blob, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            log.warn("Cannot URL-encode: " + b64blob, e);
            return null;
        }
    }

    protected void modifyRequest(StringBuffer requestToExecute, String camSecurityBlob, String camNamespace) {
        if (this.handleFailure) {
            int startPos = requestToExecute.indexOf(CAM_CHECK_GATEWAY_REQUEST);
            if (startPos != -1) {
                int endPos = requestToExecute.indexOf("&", startPos);
                if (endPos == -1) {
                    endPos = requestToExecute.length();
                }
                requestToExecute.replace(startPos + CAM_CHECK_GATEWAY_REQUEST.length(), endPos, "true");
            } else {
                requestToExecute.append("&");
                requestToExecute.append(CAM_CHECK_GATEWAY_REQUEST);
                requestToExecute.append("true");
            }
        } else {
            int length = requestToExecute.length();
            int startPos = requestToExecute.indexOf(CAM_LOGONAS);
            if (startPos == -1) {
                if (length > 0) {
                    requestToExecute.append("&");
                }
                requestToExecute.append(CAM_LOGONAS);
            }
            if ((startPos = requestToExecute.indexOf(CAM_SECURITY_BLOB_REQUEST)) != -1) {
                int endPos = requestToExecute.indexOf("&", startPos);
                if (endPos == -1) {
                    endPos = requestToExecute.length();
                }
                requestToExecute.replace(startPos + CAM_SECURITY_BLOB_REQUEST.length(), endPos, camSecurityBlob);
            } else {
                requestToExecute.append("&");
                requestToExecute.append(CAM_SECURITY_BLOB_REQUEST);
                requestToExecute.append(camSecurityBlob);
            }
            if (camNamespace != null && camNamespace.length() > 0) {
                String encodedCamNamespace = camNamespace;
                try {
                    encodedCamNamespace = URLEncoderDecoder.encode(camNamespace, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                startPos = requestToExecute.indexOf(CAM_NAMESPACE_REQUEST);
                if (startPos == -1) {
                    requestToExecute.append("&");
                    requestToExecute.append(CAM_NAMESPACE_REQUEST);
                    requestToExecute.append(encodedCamNamespace);
                } else {
                    int endPos = requestToExecute.indexOf("&", startPos);
                    if (endPos == -1) {
                        endPos = requestToExecute.length();
                    }
                    requestToExecute.replace(startPos + CAM_NAMESPACE_REQUEST.length(), endPos, encodedCamNamespace);
                }
            }
        }
    }

    void modifyRequest(BIBusEnvelope requestToExecute, String securityBlob, String camNamespace) {
        if (this.handleFailure) {
            requestToExecute.setFormField(CAM_CHECK_GATEWAY_FORM, "true");
        } else {
            requestToExecute.setCAMaction("logonAs");
            requestToExecute.setFormField(CAM_SECURITY_BLOB_FORM, securityBlob);
            if (camNamespace != null && camNamespace.length() > 0) {
                requestToExecute.setFormField("CAMNamespace", camNamespace);
            }
        }
    }

    private void escapeEnvValue(String envValue, StringBuffer escapedEnvValue) {
        int length = envValue.length();
        for (int i = 0; i < length; ++i) {
            if (envValue.charAt(i) == ',') {
                escapedEnvValue.append("\\,");
                continue;
            }
            if (envValue.charAt(i) == '=') {
                escapedEnvValue.append("\\=");
                continue;
            }
            escapedEnvValue.append(envValue.charAt(i));
        }
    }

    @Override
    public void init() {
        try {
            this.camFactory = CryptoFacility.getCAMFactory("CAM_GATE");
            this.handleFailure = false;
        }
        catch (CAMCryptoException e) {
            this.handleFailure = true;
        }
    }

    @Override
    public void init(ServletConfig config) {
        this.init();
    }

    @Override
    public void destroy() {
        this.camFactory.terminate();
    }

    @Override
    public void alterRequest(HttpServletRequest requestAsReceived, BIBusEnvelope priorResponse, StringBuffer requestToExecute) {
        log.debug("--Enter alterRequest(StringBuffer)/requestToExecute--", requestToExecute);
        String modifiedSecurityBlob = null;
        String camNamespace = null;
        if (!this.handleFailure) {
            String securityBlobStr = this.getSecurityBlob(priorResponse);
            Vector<String> envNameVector = this.getAskedEnvVariable(securityBlobStr);
            modifiedSecurityBlob = this.setRespSecurityBlob(requestAsReceived, envNameVector, true);
            camNamespace = this.getCAMNamespace(priorResponse);
        }
        if (this.isWaitRequest(requestToExecute)) {
            FormFieldVars formFieldVars = priorResponse.getBiBusHeader().getHdrSession().getFormFieldVars();
            List<NameValuePair> responseFormFields = formFieldVars.getNamesAndValues();
            if (responseFormFields.isEmpty()) {
                log.debug("IsWaitRequest-Asychronus", "responseFormFields is empty");
                this.modifyRequest(requestToExecute, modifiedSecurityBlob, camNamespace);
                return;
            }
            log.debug("IsWaitRequest-Asynchronus", "responseFormField is NOT EMPTY");
            StringBuffer newRequest = this.createRequestString(responseFormFields);
            this.modifyRequest(newRequest, modifiedSecurityBlob, camNamespace);
            CAMSystemRecoverableHandler.replaceCompleteBuffer(requestToExecute, newRequest);
        } else {
            this.modifyRequest(requestToExecute, modifiedSecurityBlob, camNamespace);
        }
        log.debug("---Exit from alterRequest(StringBuffer)/requestToExecute--", requestToExecute);
    }

    private boolean isWaitRequest(StringBuffer request) {
        return request.indexOf("ui.action=wait") == 0 || request.indexOf("&ui.action=wait") != -1;
    }

    private StringBuffer createRequestString(List<NameValuePair> responseFormFields) {
        StringBuffer requestString = new StringBuffer(256);
        for (NameValuePair responseFormField : responseFormFields) {
            if (requestString.length() > 0) {
                requestString.append('&');
            }
            CAMSystemRecoverableHandler.appendPair(requestString, responseFormField);
        }
        return requestString;
    }

    static void replaceCompleteBuffer(StringBuffer Atarget, StringBuffer Bsource) {
        Atarget.replace(0, Atarget.length(), Bsource.toString());
    }

    private static void appendPair(StringBuffer buffer, NameValuePair pair) {
        buffer.append(pair.getName());
        buffer.append('=');
        String value = pair.getValue();
        if (value != null) {
            try {
                buffer.append(URLEncoderDecoder.encode(value, "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    String getSecurityBlob(BIBusEnvelope envelope) {
        return envelope != null ? envelope.getBiBusHeader().getCam().getException().getSecurityBlob() : null;
    }

    String getCAMNamespace(BIBusEnvelope envelope) {
        return envelope != null ? envelope.getBiBusHeader().getCam().getException().getNamespace() : null;
    }

    @Override
    public void alterRequest(HttpServletRequest requestAsReceived, BIBusEnvelope priorResponse, BIBusEnvelope requestToExecute) {
        String uiActionValue;
        String modifiedSecurityBlob = null;
        String camNamespace = null;
        if (!this.handleFailure) {
            String securityBlobStr = this.getSecurityBlob(priorResponse);
            Vector<String> envNameVector = this.getAskedEnvVariable(securityBlobStr);
            modifiedSecurityBlob = this.setRespSecurityBlob(requestAsReceived, envNameVector, false);
            camNamespace = this.getCAMNamespace(priorResponse);
        }
        if ("wait".equalsIgnoreCase(uiActionValue = requestToExecute.getFormValue("ui.action"))) {
            log.debug("Replacing ui.action=wait with form fields from CAM fault response");
            FormFieldVars requestFormFields = requestToExecute.getBiBusHeader().getHdrSession().getFormFieldVars();
            requestFormFields.importFormFieldVarsFrom(priorResponse);
        }
        this.modifyRequest(requestToExecute, modifiedSecurityBlob, camNamespace);
    }
}

