/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.auth;

import com.cognos.pogo.bibus.CryptoFacility;
import com.cognos.pogo.contentmanager.CommandFactory;
import com.cognos.pogo.contentmanager.ContentManagerQueryCommand;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.util.BIBusEnvelopeUtils;
import com.cognos.pogo.util.PogoLogger;

public class CapabilitiesCheckHandler
extends BasicHandler {
    private static PogoLogger log = PogoLogger.getLogger();
    private static CryptoFacility cryptoFacility = new CryptoFacility();

    public CapabilitiesCheckHandler() {
        super(log.getNativeLogger());
    }

    public CapabilitiesCheckHandler(PogoLogger log) {
        super(log.getNativeLogger());
        CapabilitiesCheckHandler.log = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        BIBusEnvelope requestEnvelope = (BIBusEnvelope)mc.getProperty("request.envelope");
        if (this.requestIsProperlySigned(requestEnvelope)) {
            log.debug("Request is signed.  Skipping capabilities check.");
            return;
        }
        ContentManagerQueryCommand query = CommandFactory.createUserCapabilitiesQueryCommand(mc);
        BIBusEnvelopeUtils.moveAuthenticatedHeaderFromOriginalRequest(query, requestEnvelope);
        BIBusEnvelope response = null;
        try {
            log.debug("Querying CM for userCapabilities");
            query.execute();
            response = query.getResponseEnvelope();
        }
        catch (Exception ex) {
            log.error("Cannot retrieve user capabilities, perhas CM is not running?", ex);
            mc.setFault(new Fault("CapabilitiesCheckHandler.queryFailed"));
            return;
        }
        finally {
            if (response == null) {
                return;
            }
            BIBusEnvelopeUtils.moveAuthenticatedHeaderToOriginalRequest(query, requestEnvelope);
        }
        this.checkPermission(mc, query);
    }

    private void checkPermission(MessageContext mc, ContentManagerQueryCommand query) {
        if (!query.containsResult("canUseServerAdministrationTool")) {
            log.debug("The user does not have 'canUseServerAdministrationTool' capability.  Sending SOAP fault.");
            mc.setFault(new Fault("CapabilitiesCheckHandler.requestNotAllowed"));
        }
    }

    boolean requestIsProperlySigned(BIBusEnvelope env) {
        try {
            return cryptoFacility.isContentSigned(env.getAsBytesForSignatureCheck());
        }
        catch (Exception e) {
            log.debug("Exception thrown while invoking crypto facility: ", e);
            return false;
        }
    }

    public static void setCryptoFacilityForTesting(CryptoFacility cryptoFacility) {
        CapabilitiesCheckHandler.cryptoFacility = cryptoFacility;
    }
}

