/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.auth;

import com.cognos.pogo.auth.Passport;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.pdk.common.Cam;
import com.cognos.pogo.util.PogoLogger;
import org.apache.commons.lang.StringUtils;

public class CheckForPassportIDhandler
extends BasicHandler {
    static final PogoLogger cat = PogoLogger.getLogger();

    public CheckForPassportIDhandler() {
        super(cat.getNativeLogger());
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        BIBusEnvelope env = (BIBusEnvelope)mc.getProperty("request.envelope");
        Passport passport = env.getPassport();
        if (passport.isSignedRequest()) {
            cat.debug("trusted request, skipping passport check.");
            return;
        }
        if (passport.getId() != null) {
            mc.setProperty("auth.passportid", passport.getId());
        }
        if (passport.isRejectionRequired()) {
            cat.warn("triggering request rejection.");
            this.createInvalidRequestFault(mc);
        }
        if (passport.isLogonRequired()) {
            cat.debug("triggering logon.");
            env.setCAMaction("logon");
        }
        if (passport.isAuthenticationRequired()) {
            String camAction = env.getCAMAction();
            if (camAction != null) {
                mc.setProperty("cam.action", camAction);
                cat.info("CAM action \"", camAction, "\" in request.");
            }
            cat.debug("triggering authentication.");
            mc.setProperty("auth.authenticate", Boolean.TRUE);
        }
    }

    private void createInvalidRequestFault(MessageContext mc) {
        Fault f = new Fault("NOT_FOUND");
        mc.setFault(f);
    }

    public static String searchForPassportID(BIBusEnvelope env) {
        return CheckForPassportIDhandler.checkAuthenticated(env);
    }

    public static String checkAuthenticated(BIBusEnvelope env) {
        return env.checkAuthenticated();
    }

    private static String getValueFromCookie(BIBusEnvelope env, String name) {
        String ppid = env.getCookieValue(name);
        if (ppid == null || ppid.length() == 0) {
            return null;
        }
        return ppid;
    }

    public static void copyClientTokens(BIBusEnvelope env) {
        CheckForPassportIDhandler.copyAuthenticityToken(env);
        CheckForPassportIDhandler.copyUserSessionID(env);
    }

    private static void copyAuthenticityToken(BIBusEnvelope env) {
        String authenticityToken = env.getFormValue("authenticitytoken");
        if (StringUtils.isNotEmpty((String)authenticityToken)) {
            CheckForPassportIDhandler.getCam(env).setAuthenticityToken(authenticityToken);
        }
    }

    private static void copyUserSessionID(BIBusEnvelope env) {
        String userSessionId = CheckForPassportIDhandler.getValueFromCookie(env, "usersessionid");
        if (StringUtils.isNotEmpty((String)userSessionId)) {
            CheckForPassportIDhandler.getCam(env).setUserSessionId(userSessionId);
        }
    }

    private static Cam getCam(BIBusEnvelope env) {
        return env.getBiBusHeader().getCam();
    }
}

