/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.auth;

import com.cognos.pogo.auth.NewAuthHandler;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.pdk.SOAPEnvelope;
import javax.mail.internet.InternetHeaders;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class CheckforNTCRHandler
extends BasicHandler {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(CheckforNTCRHandler.class.getName());

    public CheckforNTCRHandler() {
        super(cat);
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        if (!mc.isFaulted()) {
            return;
        }
        Fault fault = mc.getFault();
        if (!fault.isCreatedFromSOAPEnvelope()) {
            return;
        }
        SOAPEnvelope faultMsgEnvelope = fault.generateEnvelope();
        if (!(faultMsgEnvelope instanceof BIBusEnvelope)) {
            cat.warn("unexpected: fault envelope is not a BIBusEnvelope.");
            return;
        }
        boolean isSystemRecoverable = NewAuthHandler.isSystemRecoverable(faultMsgEnvelope);
        Boolean setCookieHere = (Boolean)mc.getProperty("setCookieInThisDispatcher");
        String fromGateway = this.getCognosGateway(mc);
        if (isSystemRecoverable && setCookieHere.booleanValue() && fromGateway != null) {
            cat.debug("detected camAuthSystemRecoverable, so will respond with 599");
            mc.setProperty("HTTP_Response_code", "599");
            mc.setProperty("HTML_error_page_flag", Boolean.FALSE);
        } else {
            mc.setProperty("HTTP_Response_code", "500");
        }
    }

    private String getCognosGateway(MessageContext mc) {
        InternetHeaders headers = (InternetHeaders)mc.getProperty("request.headers");
        return headers != null ? headers.getHeader("Cognos-Gateway", null) : null;
    }
}

