/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.auth;

import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.contentmanager.CommandFactory;
import com.cognos.pogo.contentmanager.ContentManagerCommand;
import com.cognos.pogo.handlers.engine.CookieToUserPreferencesConverterHandler;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.pdk.common.Cam;
import com.cognos.pogo.pdk.common.SetCookieVar;
import com.cognos.pogo.util.BIBusEnvelopeUtils;
import com.cognos.pogo.util.PogoLogger;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class RetrieveUserPreferencesHandler
extends BasicHandler {
    private static final PogoLogger cat = PogoLogger.getLogger();
    private String cn_original_request;

    public RetrieveUserPreferencesHandler() {
        super(cat.getNativeLogger());
    }

    @Override
    public void compose_impl(PogoEngine engine) throws PogoException {
        this.cn_original_request = this.getAttribute(cat, "cn_original_request");
    }

    protected void copyRequiredHeaderElements(BIBusEnvelope originalEnvelope, ContentManagerCommand queryCommand) {
        this.addLogonActionIfNeeded(originalEnvelope);
        BIBusEnvelopeUtils.moveAuthenticatedHeaderFromOriginalRequest(queryCommand, originalEnvelope);
    }

    private void addLogonActionIfNeeded(BIBusEnvelope request) {
        Cam cam = request.getBiBusHeader().getCam();
        if (this.needsLogonAction(cam)) {
            cam.setAction("logon");
        }
    }

    private boolean needsLogonAction(Cam cam) {
        return this.hasNoPassport(cam) && this.hasNoAction(cam);
    }

    private boolean hasNoPassport(Cam cam) {
        return StringUtils.isEmpty((String)cam.getCAMPassport().getId());
    }

    private boolean hasNoAction(Cam cam) {
        return StringUtils.isEmpty((String)cam.getAction());
    }

    private void doLogoff(MessageContext mc, BIBusEnvelope orig_env) {
        ContentManagerCommand emptyCommand;
        block2: {
            emptyCommand = CommandFactory.createEmptyCommand(mc);
            this.copyRequiredHeaderElements(orig_env, emptyCommand);
            try {
                emptyCommand.execute();
            }
            catch (CommandExecutionException ex) {
                if (emptyCommand.getResponseEnvelope() != null) break block2;
                mc.setFault(new Fault("UNABLE_TO_LOGOFF", ex));
                return;
            }
        }
        BIBusEnvelopeUtils.moveAuthenticatedHeaderToOriginalRequest(emptyCommand, orig_env);
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        this.invokeWithEmptyCommand(mc, CommandFactory.createEmptyCommand(mc));
    }

    void invokeWithEmptyCommand(MessageContext mc, ContentManagerCommand emptyCommand) throws PogoException {
        BIBusEnvelope orig_env = (BIBusEnvelope)mc.getProperty(this.cn_original_request + ".envelope");
        String camAction = (String)mc.getProperty("cam.action");
        if (camAction != null && camAction.equals("logoff")) {
            this.doLogoff(mc, orig_env);
            return;
        }
        if (this.requiresTrustedRequest(camAction)) {
            emptyCommand.setDoTrustedRequest(true);
        }
        this.copyRequiredHeaderElements(orig_env, emptyCommand);
        try {
            cat.debug("Sending request to CM for authentication: ", emptyCommand.getRequestEnvelope());
            emptyCommand.execute();
        }
        catch (CommandExecutionException ex) {
            BIBusEnvelope responseEnvelope = emptyCommand.getResponseEnvelope();
            if (responseEnvelope == null) {
                mc.setFault(new Fault("UNABLE_TO_TALK_TO_CM_FOR_AUTHENTICATION", ex));
            } else {
                responseEnvelope.copyBiBusHeaderTo(orig_env);
                cat.debug("Original request envelope after unsuccessful authentication: ", orig_env);
                mc.setFault(new Fault("PROBABLE_AUTHENTICATION_FAULT", responseEnvelope));
            }
            return;
        }
        BIBusEnvelopeUtils.moveAuthenticatedHeaderToOriginalRequest(emptyCommand, orig_env);
        String passportid = orig_env.getPassportID();
        mc.setProperty("auth.passportid", passportid);
        cat.debug("setting auth.passportid to ", passportid);
        CookieToUserPreferencesConverterHandler.copyLocaleFromUserPreferences(mc, orig_env);
        this.copySetCookiesToCookies(orig_env);
        cat.debug("Original request envelope after successful authentication: ", orig_env);
    }

    private boolean requiresTrustedRequest(String camAction) {
        return "clonePassport".equals(camAction);
    }

    void copySetCookiesToCookies(BIBusEnvelope envelope) {
        List<SetCookieVar> setCookies = envelope.getBiBusHeader().getHdrSession().getSetCookieVars().getSetCookies();
        for (SetCookieVar setCookieVar : setCookies) {
            envelope.setCookie(setCookieVar.getName(), setCookieVar.getValue());
        }
    }
}

