/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.auth;

import com.cognos.pogo.auth.CookieFactory;
import com.cognos.pogo.handlers.util.AdvancedSettingParameterHandler;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.pdk.common.SetCookieVar;
import com.cognos.pogo.util.PogoLogger;
import java.util.List;
import javax.servlet.http.Cookie;
import org.apache.commons.lang.StringUtils;

public class SetCookieHandler
extends BasicHandler {
    static final PogoLogger cat = PogoLogger.getLogger();
    private static final String REQUEST_ENVELOPE = "request.envelope";
    private static final String RESPONSE_ENVELOPE = "response.envelope";
    private String configDomain;
    private String configPath;
    private Boolean configSecure;
    public static final String DOMAIN_COOKIE_PROPERTY = "DoNotSetCookieDomainWhenEmpty";
    public static final String DOMAIN_COOKIE_DEFAULT = "false";

    public SetCookieHandler() {
        super(cat.getNativeLogger());
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        cat.debug("Using new SetCookieHandler");
        if (this.isLoadBalancedRequest(mc)) {
            cat.debug("Not setting cookies on load balanced request");
        } else if (this.isNotFirstDispatcher(mc)) {
            cat.debug("Not setting cookies, not first dispatcher");
        } else if (this.getResponseEnvelope(mc) == null) {
            cat.debug("Not setting cookies on request without an envelope");
        } else {
            this.modifyEnvelope(mc);
        }
    }

    private boolean isLoadBalancedRequest(MessageContext mc) {
        Boolean isBalanced = (Boolean)mc.getProperty("isBalanced");
        return isBalanced != null && isBalanced != false;
    }

    private boolean isNotFirstDispatcher(MessageContext mc) {
        Boolean isFirstDispatcher = (Boolean)mc.getProperty("setCookieInThisDispatcher");
        return isFirstDispatcher == null || isFirstDispatcher == false;
    }

    private BIBusEnvelope getResponseEnvelope(MessageContext mc) {
        return (BIBusEnvelope)mc.getProperty(RESPONSE_ENVELOPE);
    }

    private BIBusEnvelope getRequestEnvelope(MessageContext mc) {
        return (BIBusEnvelope)mc.getProperty(REQUEST_ENVELOPE);
    }

    private void modifyEnvelope(MessageContext mc) {
        BIBusEnvelope envelope = this.getResponseEnvelope(mc);
        this.removeFrontDispatcherTransportVar(envelope);
        this.removeCookieVars(envelope);
        this.addHttpCookies(envelope, mc);
    }

    private void removeFrontDispatcherTransportVar(BIBusEnvelope envelope) {
        envelope.removeDispatcherTransport("front");
    }

    private void removeCookieVars(BIBusEnvelope envelope) {
        envelope.getBiBusHeader().getHdrSession().getCookieVars().clear();
    }

    private void addHttpCookies(BIBusEnvelope envelope, MessageContext mc) {
        List<SetCookieVar> setCookies = this.getSetCookies(envelope);
        String defaultCookiePath = this.getDefaultCookiePath(mc, setCookies);
        for (SetCookieVar setCookie : setCookies) {
            this.addHttpCookie(mc, setCookie, defaultCookiePath);
        }
    }

    private List<SetCookieVar> getSetCookies(BIBusEnvelope envelope) {
        return envelope.getBiBusHeader().getHdrSession().getSetCookieVars().getSetCookies();
    }

    private String getDefaultCookiePath(MessageContext mc, List<SetCookieVar> setCookies) {
        return setCookies.isEmpty() ? null : this.getScriptPath(mc);
    }

    public String getScriptPath(MessageContext mc) {
        String scriptName = this.getScriptName(mc);
        return scriptName != null ? this.getPath(scriptName) : null;
    }

    private String getScriptName(MessageContext mc) {
        String scriptName = this.getRequestEnvelope(mc).getEnvironmentValue("SCRIPT_NAME");
        return scriptName != null ? scriptName : mc.getStrProperty("SCRIPT_NAME");
    }

    private String getPath(String scriptName) {
        int secondSlashPos = scriptName.indexOf(47, 1);
        return secondSlashPos != -1 ? scriptName.substring(0, secondSlashPos) : scriptName;
    }

    void addHttpCookie(MessageContext mc, SetCookieVar setCookie, String defaultPath) {
        String path = this.getPath(setCookie, defaultPath);
        String name = setCookie.getName();
        if (StringUtils.isNotEmpty((String)path) && StringUtils.isNotEmpty((String)name)) {
            this.addHttpCookie(mc, setCookie, path, this.getDomain(mc, setCookie));
        } else {
            cat.debug("No cookie path, cookie will not be set.");
        }
    }

    private String getPath(SetCookieVar setCookie, String defaultPath) {
        String path = setCookie.getPath();
        if (StringUtils.isEmpty((String)path)) {
            path = this.configPath;
        }
        if (StringUtils.isEmpty((String)path)) {
            path = defaultPath;
        }
        return path;
    }

    private boolean getDomainCookieProperty() {
        boolean propertyValue = Boolean.valueOf(AdvancedSettingParameterHandler.getValue(DOMAIN_COOKIE_PROPERTY, DOMAIN_COOKIE_DEFAULT).trim());
        cat.info(DOMAIN_COOKIE_PROPERTY, "=", propertyValue);
        return propertyValue;
    }

    private boolean useCookieDomain() {
        return !this.getDomainCookieProperty();
    }

    private String getDomain(MessageContext mc, SetCookieVar setCookie) {
        String domain = setCookie.getDomain();
        if (StringUtils.isEmpty((String)domain)) {
            domain = this.configDomain;
        }
        if (StringUtils.isEmpty((String)domain) && this.useCookieDomain()) {
            domain = this.getDomainFromHttpHost(mc);
        }
        return domain;
    }

    private String getDomainFromHttpHost(MessageContext mc) {
        String httpHost = this.getRequestEnvelope(mc).getEnvironmentValue("HTTP_HOST");
        if (httpHost == null) {
            httpHost = mc.getStrProperty("HTTP_HOST");
        }
        return CookieFactory.getDomainFromHttpHost(httpHost);
    }

    private void addHttpCookie(MessageContext mc, SetCookieVar setCookie, String path, String domain) {
        String name = setCookie.getName();
        String value = setCookie.getValue();
        Integer maxAge = setCookie.getOptionalMaxAge();
        Boolean secure = this.getSecure(setCookie);
        Cookie httpCookie = CookieFactory.createCookie(path, name, value, maxAge, secure, domain);
        mc.addCookie(httpCookie);
        if (cat.isDebugEnabled()) {
            this.logCookie(httpCookie, domain, setCookie);
        }
    }

    private Boolean getSecure(SetCookieVar setCookie) {
        Boolean secure = setCookie.getOptionalSecure();
        if (secure == null) {
            secure = this.configSecure;
        }
        return secure;
    }

    private void logCookie(Cookie httpCookie, String domain, SetCookieVar setCookie) {
        StringBuffer strBuf = new StringBuffer("add cookie to mc: ");
        strBuf.append(httpCookie.getName()).append("=").append(httpCookie.getValue());
        strBuf.append("; path=").append(httpCookie.getPath());
        if (domain != null) {
            strBuf.append("; domain=").append(httpCookie.getDomain());
        }
        if (setCookie.getOptionalSecure() != null) {
            strBuf.append("; secure=").append(httpCookie.getSecure());
        }
        if (setCookie.getOptionalMaxAge() != null) {
            strBuf.append("; maxAge=").append(httpCookie.getMaxAge());
        }
        cat.debug(strBuf.toString());
    }

    @Override
    public void configure(Configuration configuration) {
        this.reconfigure(configuration);
    }

    @Override
    public void reconfigure(Configuration configuration) {
        this.configDomain = configuration.getValue("cookieDomain");
        this.configPath = configuration.getValue("cookiePath");
        String cookieSecureValue = configuration.getValue("cookieSecure");
        this.configSecure = cookieSecureValue != null ? Boolean.valueOf(cookieSecureValue) : null;
    }
}

