/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.bibus;

import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.bibus.CommandExecutionFailureException;
import com.cognos.pogo.bibus.CommandExecutionIOException;
import com.cognos.pogo.bibus.SOAPBodyGenerator;
import com.cognos.pogo.bibus.SOAPMessageOutputter;
import com.cognos.pogo.bibus.SoapFaultException;
import com.cognos.pogo.http.ServerConnection;
import com.cognos.pogo.http.httpclient.RawHttpMethod;
import com.cognos.pogo.http.inprocess.LocalServerConnection;
import com.cognos.pogo.impl.DispatcherStrings;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.Cleanable;
import com.cognos.pogo.pdk.LimitedInputStream;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.common.BodyFault;
import com.cognos.pogo.pdk.common.BodyHandler;
import com.cognos.pogo.pdk.common.EnvelopeFactory;
import com.cognos.pogo.pdk.common.EnvelopeFactorySelector;
import com.cognos.pogo.util.Check;
import com.cognos.pogo.util.PogoLogger;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.mail.internet.InternetHeaders;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpException;
import org.apache.log.Logger;
import org.dom4j.Element;
import org.dom4j.IllegalAddException;
import org.dom4j.Namespace;
import org.dom4j.QName;

public abstract class BIBusCommand
implements Cleanable {
    private static final PogoLogger log = PogoLogger.getLogger();
    private static final PogoLogger perfLog = PogoLogger.getLoggerFor("perf." + BIBusCommand.class.getName());
    private static final String TEXT_XML = "text/xml";
    protected static final String SOAP_ACTION = "SOAPAction";
    public static final Namespace BUS_NAMESPACE = BIBusEnvelope.NS_BUS;
    protected static final QName BUS_MESSAGE = BIBusEnvelope.BUS_MESSAGE;
    protected static final QName BUS_EXCEPTION = BIBusEnvelope.BUS_EXCEPTION;
    protected static final QName BUS_PROVIDER = BIBusEnvelope.BUS_PROVIDER;
    protected static final QName BUS_CAMTRUSTEDPROCESS = new QName("CAMTrustedprocess", BUS_NAMESPACE);
    public static final QName BUS_USERPREFERENCE = new QName("userPreference", BUS_NAMESPACE);
    public static final QName BUS_VAR = new QName("var", BUS_NAMESPACE);
    protected static final String PROVIDER_NAME_ATTRIBUTE = "name";
    protected static final String PROVIDER_PATCH_ATTRIBUTE = "patch";
    protected static final String CAMTRUSTEDPROCESS_NAME_ATTRIBUTE = "name";
    protected static final String CAMTRUSTEDPROCESS_DISPATCHER = "dispatcher";
    public static final String VAR_NAME_ATTRIBUTE = "name";
    public static final String VAR_VALUE_ATTRIBUTE = "value";
    protected static final String ERRORCODE = "errorCode";
    protected static final String ERRORCODESTRING = "errorCodeString";
    protected static final String SEVERITY = "severity";
    protected static final String DETAIL = "detail";
    private BIBusEnvelope requestEnvelope;
    private BIBusEnvelope responseEnvelope;
    private ServerConnection connection;
    private boolean autoRelease = true;
    private boolean doTrustedRequest;
    private boolean responseReceived;
    private boolean autoRetry = true;
    boolean largeResponse;
    private int partialSaxMBValue = -1;
    private String serviceID = "DISP";
    private Iterator<InputStream> multiPartAttachments = Collections.emptyList().iterator();
    private String multiPartBoundary;
    private Iterator<InputStream> requestAttachments = Collections.emptyList().iterator();
    private int statusCode;
    private String statusString;
    protected MessageContext mc;
    private EnvelopeFactory envelopeFactory;
    private String cachedToString;
    protected InternetHeaders responseMimeHeaders = new InternetHeaders();

    public BIBusCommand() {
        this(null);
    }

    public BIBusCommand(MessageContext mc) {
        this.mc = mc;
        this.envelopeFactory = EnvelopeFactorySelector.getFactoryFor(mc);
        this.requestEnvelope = this.createBlankEnvelope();
    }

    private boolean isEmptyLine(InputStream inStream) throws IOException {
        boolean isEmptyLine = true;
        while (true) {
            int aByte;
            if ((aByte = inStream.read()) == 13) {
                continue;
            }
            if (aByte == 10 || aByte == -1) break;
            isEmptyLine = false;
        }
        return isEmptyLine;
    }

    private InputStream stripMIMEHeaders(InputStream inStream) throws IOException {
        while (!this.isEmptyLine(inStream)) {
        }
        log.debug("Consumed all HTTP headers in the MIME part");
        return inStream;
    }

    @Deprecated
    public void setPerformanceLogger(Logger l) {
    }

    protected void logPerformanceRequestSent() {
        perfLog.info("Request sent");
    }

    protected void logPerformanceResponseReceived() {
        perfLog.info("Response received");
    }

    public void execute() throws CommandExecutionException {
        try {
            this.executeCommand();
        }
        catch (SoapFaultException e) {
            this.handleSoapFaultException(e);
        }
        catch (CommandExecutionFailureException e) {
            throw e;
        }
        catch (Exception e) {
            this.handleDefaultException(e);
        }
        finally {
            if (this.autoRelease && null != this.connection) {
                this.connection.release();
            }
        }
    }

    private void executeCommand() throws Exception {
        this.sendRequest();
        if (this.shouldProcessResponse()) {
            this.processResponse();
        }
    }

    private boolean shouldProcessResponse() {
        log.debug("Response code = ", this.statusCode, " resaon= ", this.statusString);
        return this.statusCode != 304 && this.statusCode != 404;
    }

    private void sendRequest() throws Exception {
        this.prepareConnection();
        this.updateRequest();
        this.addHeaders();
        this.createMessageOutputter();
        this.logRequest();
        this.statusCode = this.connection.sendRequest(this.fetchRequestContext());
        this.statusString = this.connection.getStatusText();
        this.responseReceived = true;
        this.handleResponseMIMEHeaders(this.connection.getResponseHeaders());
    }

    private void prepareConnection() {
        this.connection = this.fetchServerConnection();
        this.connection.setAutoRetry(this.isAutoRetry());
    }

    private void addHeaders() {
        this.addExtraSOAPHeaders();
        this.addExtraHTTPHeaders(this.connection);
    }

    protected void createMessageOutputter() {
        SOAPMessageOutputter messageOutputter = new SOAPMessageOutputter(this.requestEnvelope, this.requestAttachments, null);
        this.connection.setRequestContentType(messageOutputter.getContentType());
        messageOutputter.setDoTrustedRequest(this.doTrustedRequest, this.serviceID);
        this.connection.setRequestBodySource(new SOAPBodyGenerator(messageOutputter));
        this.connection.setMessageOutputter(messageOutputter);
    }

    private void logRequest() {
        log.debug(this, " sending request envelope: ", this.requestEnvelope);
        this.logPerformanceRequestSent();
    }

    protected void processResponse() throws Exception {
        this.parseResponse();
        this.handleResponse();
        this.logPerformanceResponseReceived();
    }

    void parseResponse() throws Exception {
        if (this.largeResponse) {
            this.createEnvelopeFromLimitedInputStream(this.getInputStream());
        } else {
            this.createEnvelopeFromInputStream(this.getInputStream());
        }
    }

    private void createEnvelopeFromInputStream(InputStream inStream) throws Exception {
        this.responseEnvelope = this.connection.isLocal() ? this.getLocalResponseEnvelope(inStream) : this.createResponseEnvelope(inStream);
        log.debug("Received response envelope: ", this.responseEnvelope);
    }

    private BIBusEnvelope getLocalResponseEnvelope(InputStream inputStream) throws Exception {
        BIBusEnvelope localResponseEnvelope = this.getLocalResponseEnvelope();
        if (localResponseEnvelope == null) {
            return this.createResponseEnvelope(inputStream);
        }
        if (this.isCompatible(localResponseEnvelope)) {
            log.debug("Reusing response envelope from local servlet. ***No parsing required***.");
            return localResponseEnvelope;
        }
        return this.convertEnvelope(localResponseEnvelope, inputStream);
    }

    private BIBusEnvelope getLocalResponseEnvelope() {
        LocalServerConnection localServerConnection = (LocalServerConnection)this.connection;
        return localServerConnection.getResponseEnvelope();
    }

    private boolean isCompatible(BIBusEnvelope envelope) {
        EnvelopeFactory envelopeFactory = EnvelopeFactorySelector.getFactoryFor(this.mc);
        return envelopeFactory.isCompatibleWith(envelope);
    }

    private BIBusEnvelope convertEnvelope(BIBusEnvelope localResponseEnvelope, InputStream inputStream) throws Exception {
        EnvelopeFactory envelopeFactory = EnvelopeFactorySelector.getFactoryFor(this.mc);
        return (BIBusEnvelope)envelopeFactory.convertEnvelope(localResponseEnvelope, this.getResponseBodyHandler(), inputStream);
    }

    private BIBusEnvelope createResponseEnvelope(InputStream inStream) throws Exception {
        return (BIBusEnvelope)this.envelopeFactory.createEnvelope(inStream, this.getResponseBodyHandler());
    }

    private void createEnvelopeFromLimitedInputStream(InputStream inStream) throws Exception {
        LimitedInputStream readUptoLimit = new LimitedInputStream(inStream);
        readUptoLimit.setMaxReadLength(this.partialSaxMBValue);
        try {
            this.responseEnvelope = (BIBusEnvelope)this.envelopeFactory.createEnvelope(readUptoLimit, this.getResponseBodyHandler());
        }
        catch (Exception e) {
            if (readUptoLimit.hasExceededLimit()) {
                throw new CommandExecutionFailureException("ReportServerHandler.LimitedInputStreamError");
            }
            throw e;
        }
    }

    protected BodyHandler getResponseBodyHandler() {
        return null;
    }

    private InputStream getInputStream() throws Exception {
        return this.connection.isMultiPart() ? this.getMultipartInputStream() : this.getSinglePartInputStream();
    }

    private InputStream getMultipartInputStream() throws Exception {
        log.debug("BIBus response is multipart");
        this.multiPartBoundary = this.connection.getMultiPartBoundary();
        this.multiPartAttachments = this.connection.iterator();
        return this.getSoapEnvelopeFromMultipartResponse();
    }

    private InputStream getSoapEnvelopeFromMultipartResponse() throws Exception {
        return this.stripMIMEHeaders(this.multiPartAttachments.next());
    }

    private InputStream getSinglePartInputStream() throws Exception {
        log.debug("BIBus response is not multipart");
        InputStream inStream = this.connection.getContentLimitedInputStream();
        this.checkResponseContentType(this.connection, inStream);
        return inStream;
    }

    private void handleSoapFaultException(SoapFaultException e) throws CommandExecutionIOException, SoapFaultException {
        log.debug("SOAP Fault Exception: ", e);
        log.debug("SOAP Fault: ", this.responseEnvelope.getBodyFault());
        if (this.checkForInactiveCM()) {
            this.handleInactiveCM();
            throw new CommandExecutionIOException(e);
        }
        throw e;
    }

    private void handleInactiveCM() {
        this.connection.setBadInputStream();
    }

    private void handleDefaultException(Exception e) throws CommandExecutionException {
        log.debug("exception occured while executing BIBus cmd: ", e);
        this.connection.setBadInputStream();
        throw e instanceof IOException ? new CommandExecutionIOException(e, e.getMessage()) : new CommandExecutionException(e, e.getMessage());
    }

    protected boolean checkForInactiveCM() {
        return false;
    }

    protected void checkResponseContentType(ServerConnection connection, InputStream inStream) throws CommandExecutionException, IOException {
        String responseContentType = connection.getResponseContentType();
        if (responseContentType == null || !responseContentType.startsWith(TEXT_XML)) {
            String errorMessage = DispatcherStrings.getInstance().getString("BIBusCommand.badMIMEType");
            if (inStream != null) {
                DataInputStream dataStream = new DataInputStream(inStream);
                byte[] data = new byte[inStream.available()];
                dataStream.readFully(data);
                errorMessage = errorMessage + new String(data);
            }
            throw new CommandExecutionException(errorMessage);
        }
    }

    public Iterator<InputStream> getAttachments() {
        return this.multiPartAttachments;
    }

    public String getBoundary() {
        return this.multiPartBoundary;
    }

    protected void addExtraSOAPHeaders() {
    }

    protected void addExtraHTTPHeaders(ServerConnection connection) {
    }

    @Deprecated
    public void addToHeader(Element anElement) throws IllegalAddException {
        Check.notNull(anElement);
        Element headerElement = this.requestEnvelope.getBIBusHeader();
        headerElement.add(anElement);
    }

    public void setBIBusHeader(Element biBusHeaderElement) throws IllegalAddException {
        Check.notNull(biBusHeaderElement);
        Element headerElement = this.requestEnvelope.getHeader();
        Element currentBIBusHeader = headerElement.element(BIBusEnvelope.BUS_BIBUS_HEADER);
        if (currentBIBusHeader != null) {
            currentBIBusHeader.detach();
        }
        headerElement.add(biBusHeaderElement);
    }

    @Deprecated
    protected Element getResponseHeaderElement(String name) throws NoSuchElementException {
        Check.notNull(name);
        Element responseHeader = this.responseEnvelope.getBIBusHeader();
        Element headerElement = responseHeader.element(name);
        if (headerElement == null) {
            throw new NoSuchElementException(DispatcherStrings.getInstance().getString("BIBusCommand.missingHeader") + name);
        }
        return headerElement;
    }

    @Deprecated
    public Element getRequestCAMElement() {
        return this.requestEnvelope.getCAM();
    }

    @Deprecated
    public void addCAMElement(Element camElement) {
        Check.notNull(camElement);
        this.addToHeader(camElement);
    }

    private void handleResponse() throws CommandExecutionException, SoapFaultException {
        BodyFault bodyFault = this.responseEnvelope.getBodyFault();
        if (bodyFault.isPresent()) {
            throw this.envelopeFactory.createSoapFaultException(bodyFault);
        }
        this.processSetCookie();
        this.processResponseBody();
    }

    private void processSetCookie() {
        RawHttpMethod httpMethod = this.connection.getMethod();
        Header setCookie = httpMethod.getResponseHeader("Set-Cookie");
        if (setCookie != null) {
            try {
                this.responseEnvelope.addSetCookies(setCookie);
            }
            catch (HttpException e) {
                log.error("Set-Cookie not added to the response envelope for following: " + setCookie.toString(), e);
            }
        }
    }

    protected void processResponseBody() throws CommandExecutionException {
        Element bodyElement = this.responseEnvelope.getBody();
        if (bodyElement != null) {
            this.handleResponseImpl(bodyElement);
        } else {
            log.warn("Received SOAP response with no body: ", this.responseEnvelope);
        }
    }

    protected void handleResponseMIMEHeaders(Header[] headers) {
    }

    private BIBusEnvelope createBlankEnvelope() {
        return (BIBusEnvelope)this.getEnvelopeFactory().createEnvelope(this.getRequestBodyHandler());
    }

    protected BodyHandler getRequestBodyHandler() {
        return null;
    }

    public BIBusEnvelope getRequestEnvelope() {
        return this.requestEnvelope;
    }

    protected void setRequestEvelope(BIBusEnvelope envelope) {
        Check.notNull(envelope);
        this.requestEnvelope = envelope;
    }

    public BIBusEnvelope getResponseEnvelope() {
        return this.responseEnvelope;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setRequestAttachments(Iterator<InputStream> anIterator) {
        Check.notNull(anIterator);
        this.requestAttachments = anIterator;
    }

    public String getStatusString() {
        return this.statusString;
    }

    public void setAutoRelease(boolean release) {
        this.autoRelease = release;
    }

    public void setLargeResponseHint(int newPartialSaxLimit) {
        if (newPartialSaxLimit > 0) {
            this.largeResponse = true;
        }
        this.partialSaxMBValue = newPartialSaxLimit;
    }

    public void clearLargeResponseHint() {
        this.largeResponse = false;
        this.partialSaxMBValue = -1;
    }

    public int getLargeResponseHint() {
        return this.partialSaxMBValue;
    }

    protected void updateRequest() throws CommandExecutionException {
        this.executeImpl(this.requestEnvelope.getBody());
    }

    protected abstract void executeImpl(Element var1) throws CommandExecutionException;

    protected abstract void handleResponseImpl(Element var1) throws CommandExecutionException;

    protected abstract ServerConnection fetchServerConnection();

    protected abstract String fetchRequestContext();

    @Override
    public void clean(MessageContext mc) {
        if (this.canReleaseConnection()) {
            this.releaseConnection(mc);
        }
    }

    private boolean canReleaseConnection() {
        return !this.autoRelease && this.connection != null;
    }

    private void releaseConnection(MessageContext mc) {
        if (mc.isFaulted()) {
            this.connection.setBadInputStream();
        }
        this.connection.release();
    }

    public void setDoTrustedRequest(boolean doTrustedRequest) {
        this.setDoTrustedRequest(doTrustedRequest, "DISP");
    }

    public void setDoTrustedRequest(boolean doTrustedRequest, String serviceID) {
        this.doTrustedRequest = doTrustedRequest;
        if (serviceID != null) {
            this.serviceID = serviceID;
        }
    }

    public boolean isResponseReceived() {
        return this.responseReceived;
    }

    protected boolean isAutoRetry() {
        return this.autoRetry;
    }

    public void setAutoRetry(boolean autoRetry) {
        this.autoRetry = autoRetry;
    }

    protected void setConnection(ServerConnection sc) {
        this.connection = sc;
    }

    protected ServerConnection getConnection() {
        return this.connection;
    }

    protected void setResponseReceived(boolean b) {
        this.responseReceived = b;
    }

    public void setResponseEnvelope(BIBusEnvelope env) {
        this.responseEnvelope = env;
    }

    protected void setStatusCode(int i) {
        this.statusCode = i;
    }

    protected void setStatusText(String s) {
        this.statusString = s;
    }

    protected void setMultiPartAttachments(Iterator<InputStream> it) {
        this.multiPartAttachments = it;
    }

    protected void setMultiPartBoundary(String boundary) {
        this.multiPartBoundary = boundary;
    }

    public void setRequestEnvelope(BIBusEnvelope requestEnvelope) {
        this.requestEnvelope = requestEnvelope;
    }

    public EnvelopeFactory getEnvelopeFactory() {
        return this.envelopeFactory;
    }

    public void setEnvelopeFactory(EnvelopeFactory envelopeFactory) {
        this.envelopeFactory = envelopeFactory;
    }

    public boolean isLargeResponse() {
        return this.largeResponse;
    }

    public String toString() {
        if (this.cachedToString == null) {
            this.cachedToString = "[" + this.getClass().getSimpleName() + "]";
        }
        return this.cachedToString;
    }

    public Iterator<InputStream> getRequestAttachments() {
        return this.requestAttachments;
    }

    public InternetHeaders getResponseMIMEHeaders() {
        return this.responseMimeHeaders;
    }

    public InputStream getRawResponse() throws IOException {
        return this.connection.getUndecoratedInputStream();
    }

    public InternetHeaders getRawResponseHeaders() {
        return this.connection.getResponseHeadersAsInternetHeaders(true);
    }
}

