/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.bibus;

import com.cognos.pogo.bibus.BIBusCommand;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.pogo.util.Check;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.List;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;

public class BIBusResponse {
    private boolean hasFault;
    private BIBusEnvelope responseEnvelope = new BIBusEnvelope();
    private List<Element> responseList = new LinkedList<Element>();

    public void addResponse(Element aResponseElement) {
        Check.notNull(aResponseElement);
        this.responseList.add(aResponseElement);
    }

    public void addFault(Element aFaultElement) {
        Check.notNull(aFaultElement);
        this.responseList.add(aFaultElement);
        this.hasFault = true;
    }

    public void addFault(Exception anException) {
        Check.notNull(anException);
        Element exceptionElement = DocumentHelper.createElement((QName)BIBusCommand.BUS_EXCEPTION);
        exceptionElement.addAttribute("severity", "error");
        exceptionElement.addAttribute("errorCode", "");
        exceptionElement.addAttribute("errorCodeString", anException.getMessage());
        Element messageElement = exceptionElement.addElement(BIBusCommand.BUS_MESSAGE);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        anException.printStackTrace(new PrintStream(outStream));
        messageElement.addText(outStream.toString());
        this.addFault(exceptionElement);
    }

    public void addFault(String message) {
        Element exceptionElement = DocumentHelper.createElement((QName)BIBusCommand.BUS_EXCEPTION);
        exceptionElement.addAttribute("severity", "error");
        exceptionElement.addAttribute("errorCode", "");
        exceptionElement.addAttribute("errorCodeString", message);
        this.addFault(exceptionElement);
    }

    public void setBiBusHeader(Element biBusHeader) {
        this.responseEnvelope.setBIBusHeader(biBusHeader);
    }

    public BIBusEnvelope getResponseEnvelope() {
        return this.responseEnvelope;
    }

    public SOAPEnvelope getResponseEnvelope(String responseName) {
        if (!this.hasFault) {
            Element busResponse = this.responseEnvelope.getBody().addElement(new QName(responseName, BIBusEnvelope.NS_BUS));
            for (Element element : this.responseList) {
                busResponse.add(element);
            }
        } else {
            Element detailElement = this.createFaultElement().addElement("detail");
            for (Element element : this.responseList) {
                detailElement.add(element);
            }
        }
        return this.responseEnvelope;
    }

    private Element createFaultElement() {
        return this.responseEnvelope.createFaultElement("SOAP-ENV:Client", "Client Error", null);
    }
}

