/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.bibus;

public class RequestAffinity {
    public static final RequestAffinity ABSOLUTE = new RequestAffinity("absolute affinity", true);
    public static final RequestAffinity CONTROL = new RequestAffinity("control affinity ", true);
    public static final RequestAffinity HIGH = new RequestAffinity("high affinity", false);
    public static final RequestAffinity NONE = new RequestAffinity("no affinity", false);
    public static final RequestAffinity SESSION = new RequestAffinity("session affinity", false);
    public static final RequestAffinity SERVER = new RequestAffinity("server affinity", false);
    public static final RequestAffinity GET = new RequestAffinity("get affinity", true);
    private static boolean kubernetesMode = Boolean.parseBoolean(System.getenv("KUBERNETES_MODE"));
    private String affinityLabel;
    private boolean processSpecific;

    private RequestAffinity(String label, boolean processSpecific) {
        this.affinityLabel = label;
        this.processSpecific = processSpecific;
    }

    public String toString() {
        return this.affinityLabel;
    }

    public boolean isProcessSpecific() {
        return this.processSpecific;
    }

    public static RequestAffinity determineAffinity(String soapAction) {
        if (!kubernetesMode) {
            if (soapAction.endsWith(".absolute")) {
                return ABSOLUTE;
            }
            if (soapAction.endsWith(".control")) {
                return CONTROL;
            }
            if (soapAction.endsWith(".high")) {
                return HIGH;
            }
            if (soapAction.endsWith(".session")) {
                return SESSION;
            }
            if (soapAction.endsWith(".server")) {
                return SERVER;
            }
            if (soapAction.endsWith(".get")) {
                return GET;
            }
        }
        return NONE;
    }
}

