/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.bibus.passthrough;

import com.cognos.p2plb.model.NodeID;
import com.cognos.p2plb.model.NodeIdGuidMapper;
import com.cognos.pogo.bibus.BIBusCommand;
import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.bibus.SoapFaultException;
import com.cognos.pogo.bibus.passthrough.ActiveDispatcherPassThroughCommand;
import com.cognos.pogo.config.DispatcherList;
import com.cognos.pogo.config.DispatcherListElement;
import com.cognos.pogo.contentmanager.coordinator.CMUri;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.util.PogoLogger;
import javax.mail.internet.InternetHeaders;

public class ActiveDispatcherPassthroughHandler
extends BasicHandler {
    private static final PogoLogger log = PogoLogger.getLogger();
    private String property;
    private NodeID activeDispatcherNodeID;

    public ActiveDispatcherPassthroughHandler() {
        super(log.getNativeLogger());
    }

    @Override
    public void compose_impl(PogoEngine engine) throws PogoException {
        this.property = this.getAttribute(log, "property");
    }

    @Override
    public void configure(Configuration configuration) {
        NodeID cmNodeID = NodeIdGuidMapper.getContentManagerNID();
        DispatcherList dispatcherList = (DispatcherList)configuration.getDispatcherList();
        for (DispatcherListElement dle : dispatcherList.getDispatcherListElements()) {
            if (!cmNodeID.isSameDispatcher(dle.getNodeID())) continue;
            this.activeDispatcherNodeID = dle.getNodeID();
        }
    }

    @Override
    public void reconfigure(Configuration configuration) {
        this.configure(configuration);
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        if (this.activeCMIsLocal()) {
            log.debug("ActiveDispatcher request is local");
            mc.setProperty(this.property, "true");
        } else {
            this.forwardRequest(mc);
        }
    }

    private boolean activeCMIsLocal() {
        return CMUri.isActiveCMLocal();
    }

    private void forwardRequest(MessageContext mc) {
        log.debug("ActiveDispatcher request forwarded to: ", this.activeDispatcherNodeID);
        InternetHeaders headers = (InternetHeaders)mc.getProperty("request.headers");
        BIBusEnvelope envelope = (BIBusEnvelope)mc.getProperty("request.envelope");
        BIBusCommand command = this.createPassThroughCommand(headers, envelope);
        try {
            command.execute();
        }
        catch (SoapFaultException sfex) {
            mc.setFault(new Fault("", command.getResponseEnvelope()));
        }
        catch (CommandExecutionException e) {
            log.error("Exception caught while trying to relay a request to active CM dispatcher", e);
        }
        mc.setResponseName("response");
        mc.setProperty("response.envelope", command.getResponseEnvelope());
        mc.setProperty("response.headers", command.getResponseMIMEHeaders());
        mc.setProperty("response.status_code", Integer.toString(command.getStatusCode()));
    }

    protected BIBusCommand createPassThroughCommand(InternetHeaders headers, BIBusEnvelope envelope) {
        return new ActiveDispatcherPassThroughCommand(envelope, headers, this.activeDispatcherNodeID);
    }
}

