/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.config;

import com.cognos.p2plb.model.NodeID;
import com.cognos.pogo.config.DispatcherListService;
import com.cognos.pogo.config.NonSuspendableDispatcherListService;
import com.cognos.pogo.monitoring.jmx.PogoMBeanServer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class DispatcherListElement {
    private static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(DispatcherListElement.class.getName());
    public static final String MONITOR_SERVICE_NAME = "monitorService";
    private String path;
    private String guid;
    private String name;
    private String capacity;
    private String serverGroup;
    private String loadBalancingMode;
    private boolean sslEnabled = false;
    private boolean available = true;
    private HashMap<String, DispatcherListService> services = new HashMap();
    private String jmxUrl;
    private String stringName;
    private NodeID nodeID;
    private String edition;

    public DispatcherListElement(String guid, String name, String capacity, String path, String serverGroup, String loadBalancingMode, String edition) {
        if (name == null) {
            cat.warn("An dispatcher's name is null, path = " + path + ", guid = " + guid + ", capacity = " + capacity + ", serverGroup = " + serverGroup + ", loadBanlancingMode = " + loadBalancingMode);
            name = "";
        }
        if (name.startsWith("http://")) {
            this.name = name.substring("http://".length());
        } else if (name.startsWith("https://")) {
            this.sslEnabled = true;
            this.name = name.substring("https://".length());
        } else {
            this.name = name;
        }
        this.path = path;
        this.guid = guid;
        this.capacity = capacity;
        this.serverGroup = serverGroup;
        this.loadBalancingMode = loadBalancingMode;
        this.edition = edition;
    }

    public DispatcherListElement(String guid, String name, String capacity, String path, String serverGroup, String loadBalancingMode) {
        this(guid, name, capacity, path, serverGroup, loadBalancingMode, "");
    }

    private DispatcherListElement() {
    }

    public static DispatcherListElement createDispatcherListElementForTesting() {
        return new DispatcherListElement();
    }

    public boolean addService(String name, String disabled, String componentID) {
        boolean added = MONITOR_SERVICE_NAME.equals(name) ? this.addToServices(new NonSuspendableDispatcherListService(name, disabled, componentID)) : this.addToServices(new DispatcherListService(name, disabled, componentID));
        if (added && cat.isDebugEnabled()) {
            cat.debug("Adding service: " + name + " with state: " + disabled + " componentID: " + componentID);
        }
        return added;
    }

    private boolean addToServices(DispatcherListService dispatcherListService) {
        String key = dispatcherListService.getName() + dispatcherListService.getComponentID();
        return null == this.services.put(key, dispatcherListService);
    }

    public double getCapacityAsDouble() {
        double dcapacity = 0.0;
        if (this.capacity != null) {
            try {
                dcapacity = Double.parseDouble(this.capacity);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return dcapacity;
    }

    public Iterator<DispatcherListService> iterator() {
        return this.services.values().iterator();
    }

    public int getNumberOfServices() {
        return this.services.size();
    }

    public boolean isSslEnabled() {
        return this.sslEnabled;
    }

    public String getGuid() {
        return this.guid;
    }

    public String getName() {
        return this.name;
    }

    public String getServerGroup() {
        return this.serverGroup;
    }

    public String getLoadBalancingMode() {
        return this.loadBalancingMode;
    }

    public String getPath() {
        return this.path;
    }

    public String getJmxUrl() {
        if (this.jmxUrl != null) {
            return this.jmxUrl;
        }
        this.jmxUrl = PogoMBeanServer.getJmxUrl(this.isSslEnabled(), this.name);
        return this.jmxUrl;
    }

    public String toString() {
        if (this.stringName == null) {
            StringBuffer buffer = new StringBuffer();
            if (this.isSslEnabled()) {
                buffer.append("https://");
            } else {
                buffer.append("http://");
            }
            buffer.append(this.name);
            this.stringName = buffer.toString();
        }
        return this.stringName;
    }

    public synchronized NodeID getNodeID() {
        if (this.nodeID == null) {
            this.nodeID = NodeID.getNodeID(this.name);
            if (this.nodeID != null && this.isSslEnabled()) {
                this.nodeID.setProtocol("https");
            }
        }
        return this.nodeID;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public void setAvailable(boolean enabled) {
        this.available = enabled;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.capacity == null ? 0 : this.capacity.hashCode());
        result = 31 * result + (this.guid == null ? 0 : this.guid.hashCode());
        result = 31 * result + (this.loadBalancingMode == null ? 0 : this.loadBalancingMode.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (this.serverGroup == null ? 0 : this.serverGroup.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        DispatcherListElement other = obj instanceof DispatcherListElement ? (DispatcherListElement)obj : null;
        return other != null && StringUtils.equals((String)this.capacity, (String)other.capacity) && StringUtils.equals((String)this.guid, (String)other.guid) && StringUtils.equals((String)this.loadBalancingMode, (String)other.loadBalancingMode) && StringUtils.equals((String)this.name, (String)other.name) && StringUtils.equals((String)this.path, (String)other.path) && StringUtils.equals((String)this.serverGroup, (String)other.serverGroup) && this.available == other.available && this.compareServices(other.services);
    }

    private boolean compareServices(HashMap<String, DispatcherListService> otherServices) {
        if (!this.services.keySet().equals(otherServices.keySet())) {
            return false;
        }
        for (Map.Entry<String, DispatcherListService> entry : this.services.entrySet()) {
            if (otherServices.get(entry.getKey()).equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public String getEdition() {
        return this.edition;
    }
}

