/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.config;

import com.cognos.p2plb.model.NodeID;
import com.cognos.p2plb.model.NodeIdGuidMapper;
import com.cognos.pogo.bibus.BIBusResponse;
import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.config.AdminCommand;
import com.cognos.pogo.config.DispatcherList;
import com.cognos.pogo.config.DispatcherListElement;
import com.cognos.pogo.config.DispatcherNameParser;
import com.cognos.pogo.contentmanager.coordinator.ActiveCMControl;
import com.cognos.pogo.handlers.configurable.HandoffAdminCommand;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.threads.SafeThread;
import java.net.UnknownHostException;
import java.util.Iterator;
import org.dom4j.Element;
import org.dom4j.Node;

public class NotifyAdminCommand
extends AdminCommand {
    private Configuration configuration;
    static final PogoLogger log = PogoLogger.getLogger();

    public NotifyAdminCommand(Element e, MessageContext mc, PogoEngine engine, Configuration configuration) {
        super(e, mc);
        this.configuration = configuration;
    }

    @Override
    public boolean executeImpl(BIBusResponse response) {
        String cmURI = this.getCommandElement().selectSingleNode("notificationActiveContentManager/uri").getText();
        String popagateStr = this.getCommandElement().element("propagate").getText();
        boolean propagate = Boolean.valueOf(popagateStr);
        if (propagate) {
            SafeThread propThread = new SafeThread(new Runnable(){

                @Override
                public void run() {
                    NotifyAdminCommand.this.propagateNotify();
                }
            });
            propThread.start();
        }
        this.restartCmCommunication(cmURI);
        return true;
    }

    private void restartCmCommunication(String cmURI) {
        ActiveCMControl.getInstance().notifyCM(cmURI);
    }

    private void propagateNotify() {
        Element command = this.getCommandElement();
        Node n = command.selectSingleNode("//propagate");
        n.setText("false");
        DispatcherList dl = (DispatcherList)this.configuration.getDispatcherList();
        Iterator<DispatcherListElement> iter = dl.getAllDispatcherListElements();
        while (iter.hasNext()) {
            DispatcherListElement element = iter.next();
            NodeID dispatcherNodeId = NodeIdGuidMapper.getInstance().get(element.getGuid());
            if (dispatcherNodeId == null || dispatcherNodeId.isSelf()) continue;
            NotifyPropagater propThread = new NotifyPropagater(dispatcherNodeId, command);
            propThread.start();
        }
    }

    @Override
    DispatcherNameParser getNameParser() throws Exception {
        return this.nameParser;
    }

    @Override
    String getResponseName() {
        return "notifyResponse";
    }

    @Override
    protected boolean isSameDispatcher(DispatcherNameParser parser) throws PogoException, UnknownHostException {
        return true;
    }

    public class NotifyPropagater
    extends SafeThread {
        private Element command;
        private NodeID dispatcherNodeId;

        public NotifyPropagater(NodeID dispatcherNodeId, Element command) {
            super("NotifyPropagaterThread-" + dispatcherNodeId.toString());
            this.dispatcherNodeId = dispatcherNodeId;
            this.command = command;
        }

        @Override
        public void safeRun() {
            HandoffAdminCommand handoff = new HandoffAdminCommand(this.command, this.dispatcherNodeId, NotifyAdminCommand.this.soapAction);
            handoff.setDoTrustedRequest(true);
            try {
                log.debug("Propagating notify to: ", this.dispatcherNodeId);
                handoff.execute();
            }
            catch (CommandExecutionException e) {
                Fault f = new Fault("notifyHandoffFailed");
                f.setMessageParameters(new Object[]{this.dispatcherNodeId.toString()});
                NotifyAdminCommand.this.messageContext.setFault(f);
            }
        }
    }
}

