/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.config;

import com.cognos.pogo.bibus.BIBusResponse;
import com.cognos.pogo.config.AdminCommand;
import com.cognos.pogo.config.DispatcherNameParser;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.pogo.transport.PogoServlet;
import com.cognos.pogo.util.Version;
import java.util.Date;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class PingAdminCommand
extends AdminCommand {
    private boolean isDeprecatedVersion;

    public PingAdminCommand(Element e, MessageContext mc) {
        super(e, mc);
    }

    @Override
    public boolean executeImpl(BIBusResponse response) {
        try {
            if (this.isDeprecatedVersion) {
                this.generateDeprecatedResponse(response);
            } else {
                this.generateResponse(response);
            }
            return true;
        }
        catch (Exception e) {
            response.addFault(e);
            return false;
        }
    }

    private void generateResponse(BIBusResponse response) {
        Element pingReplyElement = DocumentHelper.createElement((String)"pingReply");
        pingReplyElement.add(this.createUptimeElement());
        pingReplyElement.add(this.createVersionElement());
        response.addResponse(pingReplyElement);
    }

    private void generateDeprecatedResponse(BIBusResponse response) {
        Element resp = this.createUptimeElement();
        response.addResponse(resp);
        resp = this.createVersionElement();
        response.addResponse(resp);
    }

    Element createUptimeElement() {
        Element resp = DocumentHelper.createElement((String)"upTime");
        resp.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_INT);
        Date now = new Date();
        long uptime = (now.getTime() - PogoServlet.starttime.getTime()) / 1000L;
        resp.addText(Long.toString(uptime));
        return resp;
    }

    Element createVersionElement() {
        Element resp = DocumentHelper.createElement((String)"version");
        resp.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_STRING);
        resp.addText(this.getVersion());
        return resp;
    }

    private String getVersion() {
        return Version.getVersionStr();
    }

    @Override
    DispatcherNameParser getNameParser() throws Exception {
        if (this.nameParser == null) {
            Element dispatcherElement = this.getDispatcherElement();
            String dispatcherName = dispatcherElement.getText();
            this.nameParser = new DispatcherNameParser(dispatcherName);
        }
        return this.nameParser;
    }

    Element getDispatcherElement() {
        Element serviceElement = this.getDispatcherPathElement();
        return serviceElement != null ? serviceElement : this.getDeprecatedDispatcherElement();
    }

    Element getDispatcherPathElement() {
        return this.getCommandElement().element("dispatcherPath");
    }

    Element getDeprecatedDispatcherElement() {
        this.isDeprecatedVersion = true;
        return this.getCommandElement().element("dispatcher");
    }

    @Override
    String getResponseName() {
        return "pingResponse";
    }
}

