/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.config;

import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.config.DispatcherNameParser;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Element;
import org.dom4j.Node;

public class ServiceNameParser
extends DispatcherNameParser {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(ServiceNameParser.class.getName());
    protected String service = null;

    public ServiceNameParser(String objectPath) {
        super(objectPath);
    }

    @Override
    protected void doQuery() throws CommandExecutionException {
        this.query.addQueryPropertyName("parent");
        this.query.addQueryPropertyName("objectClass");
        this.query.addQueryParentProperty("dispatcherPath");
        this.query.addQueryParentProperty("objectClass");
        this.query.addQueryParentProperty("runningState");
        this.query.addQueryPropertyName("dispatcherPath");
        this.query.addQueryPropertyName("runningState");
        this.query.addRefPropName("parent");
        this.query.setDoTrustedRequest(true);
        this.query.execute();
        Element elem = this.query.getQueryResponseElement();
        if (this.hasAlienParent(elem)) {
            cat.debug("Parent object is an alien dispatcher. Refuse request.");
            throw new CommandExecutionException("alien_parent");
        }
        if (this.isAlienDispatcher(elem)) {
            cat.debug("Target object is an alien dispatcher. Refuse request.");
            throw new CommandExecutionException("alien_dispatcher");
        }
        this.parseResult(elem);
        if (cat.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer("resolved target: ");
            sb.append("ssl=").append(this.ssl).append(" host=").append(this.host).append(" port=").append(this.port).append(" service=").append(this.service);
            cat.debug(sb.toString());
        }
    }

    @Override
    void parseResult(Element elem) {
        this.getHostPort(elem);
        Node value = elem.selectSingleNode("//queryResult/item/objectClass/value");
        if (value != null) {
            this.service = value.getText();
        }
    }

    private boolean hasAlienParent(Element qryResult) {
        Element val = (Element)qryResult.selectSingleNode("//parent/value/item/objectClass/value");
        String objectClass = val == null ? "--null--" : val.getText();
        cat.debug("object class of parent is: " + objectClass);
        if (!"dispatcher".equals(objectClass)) {
            return false;
        }
        val = (Element)qryResult.selectSingleNode("//parent/value/item/runningState/value");
        String runningState = val == null ? "--null--" : val.getText();
        cat.debug("Testing parent dispatcher runningState: " + runningState);
        return "standby".equals(runningState) || "disabled".equals(runningState);
    }

    private boolean isAlienDispatcher(Element elem) {
        Element val = (Element)elem.selectSingleNode("//item/objectClass/value");
        String objectClass = val == null ? "--null--" : val.getText();
        cat.debug("object class is: " + objectClass);
        if (!"dispatcher".equals(objectClass)) {
            return false;
        }
        val = (Element)elem.selectSingleNode("//item/runningState/value");
        String runningState = val == null ? "--null--" : val.getText();
        cat.debug("Testing dispatcher runningState: " + runningState);
        return "standby".equals(runningState) || "disabled".equals(runningState);
    }

    @Override
    public String getService() {
        return this.service;
    }
}

