/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager;

import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.config.ConfigurationImpl;
import com.cognos.pogo.contentmanager.ContentManagerMultipleQueryCommand;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.pogo.util.DomUtils;
import com.cognos.pogo.util.PogoLogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;

public class ContentManagerConfigurationCommand
extends ContentManagerMultipleQueryCommand {
    private PogoLogger log = PogoLogger.getLogger();
    private static final Namespace ns_SOAP_ENC = Namespace.get((String)"SOAP-ENC", (String)"http://schemas.xmlsoap.org/soap/encoding/");
    private final String SOAP_ENC_Array = ns_SOAP_ENC.getPrefix() + ":Array";
    private static final QName BUS_sortBy = new QName("sortBy", BUS_NAMESPACE);
    private static final QName BUS_propName = new QName("propName", BUS_NAMESPACE);
    private static final QName BUS_order = new QName("order", BUS_NAMESPACE);
    private static final String BUS_avPropEnum = BIBusEnvelope.NS_BUS.getPrefix() + ":propEnum";
    private static final String BUS_avOrderEnum = BIBusEnvelope.NS_BUS.getPrefix() + ":orderEnum";
    private static final String BUS_avSort = BIBusEnvelope.NS_BUS.getPrefix() + ":sort";
    private String[] configurationProperties;
    String[] defaultConfigurationProperties = new String[]{"lastConfigurationModificationTime", "defaultFont", "supportedFonts", "supportedCurrencies", "serverLocale", "cookieDomain", "cookiePath", "cookieSecure", "supportedProductLocales", "productLocaleMap", "supportedContentLocales", "contentLocaleMap", "serverTimeZoneID", "emailEncoding", "archiveLocationFileSchemeRoot", "periodicalDocumentVersionRetentionAge", "periodicalDocumentVersionRetentionCount", "glossaryURI", "metadataInformationURI"};
    private ConfigurationImpl configuration;
    private String lastModificationTime;
    private boolean queryEmpty;
    private String dispatcherName;
    private boolean noDispatcher = false;

    public ContentManagerConfigurationCommand(String objectName, String dispatcherName, ConfigurationImpl configuration, ArrayList<String> additionalConfigurationParameters) {
        super(objectName);
        this.dispatcherName = dispatcherName;
        this.configuration = configuration;
        this.configurationProperties = this.initializeConfigurationProperties(additionalConfigurationParameters);
        this.forceEnglishLocale();
    }

    private String[] initializeConfigurationProperties(ArrayList<String> additionalConfigurationParameters) {
        ArrayList<String> propertiesArrayList = new ArrayList<String>(Arrays.asList(this.defaultConfigurationProperties));
        propertiesArrayList.addAll(additionalConfigurationParameters);
        return propertiesArrayList.toArray(new String[propertiesArrayList.size()]);
    }

    private void forceEnglishLocale() {
        this.getRequestEnvelope().setUserPreference("productLocale", "en");
    }

    @Override
    protected void handleResponseImpl(Element bodyElement) throws CommandExecutionException {
        this.extractLastModificationTime(bodyElement);
        List<Element> parts = this.getQueryPart(bodyElement);
        Element configResult = parts.get(0);
        Element propResult = parts.get(1);
        Element g = configResult.element("item");
        g.detach();
        propResult.add(g);
        Element auditLevelResult = parts.get(4);
        Element auditLevelItem = auditLevelResult.element("item");
        if (auditLevelItem != null) {
            auditLevelItem.detach();
            propResult.add(auditLevelItem);
        } else {
            this.noDispatcher = true;
        }
        if (parts.size() >= 6) {
            this.handleAliasRoots(parts.get(5), propResult);
        }
        if (parts.size() == 7) {
            this.handleJobServices(parts.get(6), propResult);
        }
        this.log.debug("Calling ConfigurationImpl with the following properties: " + propResult.asXML());
        this.configuration.reconfigure(propResult);
        this.configuration.setDispatcherList(parts.get(2));
        this.configuration.setServiceList(parts.get(3));
    }

    protected void handleAliasRoots(Element sourceElem, Element destElem) {
        List<Element> aliasRootParts = this.getItemPart(sourceElem);
        if (!aliasRootParts.isEmpty()) {
            Element aliasesElem = destElem.addElement("aliasRoots");
            Element valueElem = aliasesElem.addElement("value");
            for (Element aliasRoot : aliasRootParts) {
                aliasRoot.detach();
                valueElem.add(aliasRoot);
            }
        }
    }

    private void handleJobServices(Element sourceElem, Element destElem) {
        try {
            Element eJobService = (Element)destElem.selectSingleNode("item[@*[contains(.,'jobService')]]/jsAuditLevel/value");
            if (eJobService == null && this.isMonitorServiceRunning(destElem)) {
                List<Element> jobServiceParts = this.getItemPart(sourceElem);
                if (!jobServiceParts.isEmpty()) {
                    AuditLevel auditLevelCurrent = AuditLevel.MINIMAL;
                    for (Element eJS : jobServiceParts) {
                        eJS.detach();
                        if (auditLevelCurrent == AuditLevel.FULL) continue;
                        AuditLevel auditLevelCandidate = this.getJobServiceAuditLevel(eJS);
                        if (!this.isJobServiceRunning(eJS) || auditLevelCandidate.compareTo(auditLevelCurrent) <= 0 && eJobService != null) continue;
                        eJobService = eJS;
                        auditLevelCurrent = auditLevelCandidate;
                    }
                    if (eJobService != null) {
                        Element eRunningStateValue = (Element)eJobService.selectSingleNode("runningState/value");
                        if (eRunningStateValue != null) {
                            eRunningStateValue.setText("standby");
                        }
                        destElem.add(eJobService);
                    }
                }
            } else {
                sourceElem.detach();
            }
        }
        catch (Exception e) {
            this.log.debug("Exception handling job services from the CM configuration response ", e);
        }
    }

    private AuditLevel getJobServiceAuditLevel(Element elem) {
        AuditLevel auditLevel = AuditLevel.MINIMAL;
        try {
            Element jsAuditLevelValue = (Element)elem.selectSingleNode("jsAuditLevel/value");
            auditLevel = AuditLevel.valueOf(jsAuditLevelValue.getText().toUpperCase());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return auditLevel;
    }

    private boolean isMonitorServiceRunning(Element elem) {
        boolean isMsRunning = false;
        Element eMsRunningStateValue = (Element)elem.selectSingleNode("//item[@*[contains(., 'monitorService')]]/runningState/value");
        if (eMsRunningStateValue != null && eMsRunningStateValue.getText().equalsIgnoreCase("running")) {
            isMsRunning = true;
        }
        return isMsRunning;
    }

    private boolean isJobServiceRunning(Element elem) {
        boolean isJsRunning = false;
        Element eJsRunningStateValue = (Element)elem.selectSingleNode("runningState/value");
        if (eJsRunningStateValue != null && eJsRunningStateValue.getText().equalsIgnoreCase("running")) {
            isJsRunning = true;
        }
        return isJsRunning;
    }

    private List<Element> getQueryPart(Element bodyElement) {
        return DomUtils.selectElements(bodyElement, "//queryResult");
    }

    private List<Element> getItemPart(Element bodyElement) {
        return DomUtils.selectElements(bodyElement, "item");
    }

    private void extractLastModificationTime(Element bodyElement) throws CommandExecutionException {
        Node timeElement = bodyElement.selectSingleNode("//lastConfigurationModificationTime/value");
        if (timeElement == null) {
            throw new CommandExecutionException("no lastConfigurationModificationTime");
        }
        this.setLastModificationTime(timeElement.getText());
    }

    public String getLastModificationTime() {
        return this.lastModificationTime;
    }

    public boolean isQueryEmpty() {
        return this.queryEmpty;
    }

    @Override
    protected void executeImpl(Element bodyElement) throws CommandExecutionException {
        Element requests = this.createRequestsElement(bodyElement);
        this.addConfigurationQueryProperties(requests);
        Element queryElement = requests.addElement(BUS_ITEM);
        queryElement.addAttribute(SOAPEnvelope.XSI_TYPE, QUERY_REQUEST);
        this.addSearchElements(queryElement);
        this.addDispatcherListQuery(requests);
        this.addServiceListQuery(requests);
        this.addDispatcherPropertiesQuery(requests);
        this.addSessionRequestIds("configPolling");
        this.addAliasRoot(requests);
        this.addJobServices(requests);
    }

    private void addConfigurationQueryProperties(Element requests) {
        String queryObjectName = "/configuration";
        String[] queryProperties = this.getConfigurationProperties();
        Element configurationQueryElement = this.addQueryElement(requests, queryObjectName, queryProperties);
        this.addSortBy(configurationQueryElement, "defaultName", true);
    }

    public String[] getConfigurationProperties() {
        return this.configurationProperties;
    }

    private void addDispatcherListQuery(Element element) {
        String queryObjectName = "/configuration/descendant::dispatcher";
        String[] queryProperties = new String[]{"dispatcherPath", "capacity", "searchPath", "serverGroup", "loadBalancingMode", "dispatcherID", "runningState", "edition"};
        this.addQueryElement(element, queryObjectName, queryProperties);
    }

    private void addServiceListQuery(Element element) {
        String queryObjectName = "/configuration/descendant::dispatcher/*";
        String[] queryProperties = new String[]{"objectClass", "runningState", "parent", "componentID"};
        this.addQueryElement(element, queryObjectName, queryProperties);
    }

    private void addDispatcherPropertiesQuery(Element anElement) {
        String searchPath = "/configuration/descendant::dispatcher[@dispatcherPath=\"" + this.dispatcherName + "\"]";
        String[] queryProperties = new String[]{"dispatcherAuditLevel", "peakDemandBeginHour", "nonPeakDemandBeginHour", "dispatcherID"};
        this.addQueryElement(anElement, searchPath, queryProperties);
    }

    protected void addAliasRoot(Element anElement) {
        String searchPath = "/configuration/*[@objectClass=\"aliasRoot\"]";
        String[] queryProperties = new String[]{"defaultName", "windowsURI", "unixURI"};
        this.addQueryElement(anElement, searchPath, queryProperties);
    }

    protected void addJobServices(Element anElement) {
        String searchPath = "/configuration/descendant::dispatcher/descendant::jobService";
        String[] queryProperties = new String[]{"jsAuditLevel", "runningState"};
        this.addQueryElement(anElement, searchPath, queryProperties);
    }

    private void addSortBy(Element elem, String sortByProp, boolean ascending) {
        Element eSortBy = elem.addElement(BUS_sortBy);
        eSortBy.addAttribute(SOAPEnvelope.XSI_TYPE, this.SOAP_ENC_Array);
        eSortBy.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":sort[1]");
        Element item = eSortBy.addElement(BUS_ITEM);
        item.addAttribute(SOAPEnvelope.XSI_TYPE, BUS_avSort);
        Element propName = item.addElement(BUS_propName);
        propName.addAttribute(SOAPEnvelope.XSI_TYPE, BUS_avPropEnum);
        propName.setText(sortByProp);
        Element order = item.addElement(BUS_order);
        order.addAttribute(SOAPEnvelope.XSI_TYPE, BUS_avOrderEnum);
        order.setText(ascending ? "ascending" : "descending");
    }

    public void setLastModificationTime(String lastModificationTime) {
        this.lastModificationTime = lastModificationTime;
    }

    public boolean isNoDispatcher() {
        return this.noDispatcher;
    }

    private static enum AuditLevel {
        MINIMAL,
        BASIC,
        REQUEST,
        TRACE,
        FULL;

    }
}

