/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager;

import com.cognos.p2plb.model.NodeIdGuidMapper;
import com.cognos.pogo.bibus.BIBusPassThroughCommand;
import com.cognos.pogo.http.ServerConnection;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.transport.DispatcherConnectionManager;
import com.cognos.pogo.transport.FormRequestProcessor;
import javax.mail.internet.InternetHeaders;

public class ContentManagerPassThroughCommand
extends BIBusPassThroughCommand {
    private InternetHeaders requestHeaders;

    public ContentManagerPassThroughCommand(BIBusEnvelope envelope, InternetHeaders headers) {
        super(envelope, headers);
        this.requestHeaders = headers;
    }

    @Override
    protected void addExtraHTTPHeaders(ServerConnection connection) {
        super.addExtraHTTPHeaders(connection);
        this.addSoapActionIfNotPresent(connection);
    }

    private void addSoapActionIfNotPresent(ServerConnection connection) {
        if (this.requestHasNoSoapActionHeader()) {
            connection.setRequestHeader("SOAPAction", FormRequestProcessor.CONTENT_MANAGER_SERVICE);
        }
    }

    private boolean requestHasNoSoapActionHeader() {
        String[] soapActionHeaders = this.requestHeaders.getHeader("SOAPAction");
        return soapActionHeaders == null || soapActionHeaders.length == 0;
    }

    @Override
    protected String fetchRequestContext() {
        return NodeIdGuidMapper.getContentManagerNID().getPath();
    }

    @Override
    protected ServerConnection fetchServerConnection() {
        return DispatcherConnectionManager.getContentManagerConnection();
    }
}

