/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager.cache;

import com.cognos.pogo.contentmanager.cache.AccountItems;
import com.cognos.pogo.contentmanager.cache.CacheContainer;
import com.cognos.pogo.contentmanager.cache.CacheElementMap;
import com.cognos.pogo.contentmanager.cache.CachedResponse;
import com.cognos.pogo.contentmanager.cache.PackageCache;
import com.cognos.pogo.contentmanager.cache.PackageItems;
import com.cognos.pogo.contentmanager.cache.ReportCache;
import com.cognos.pogo.contentmanager.cache.ReportItems;
import com.cognos.pogo.contentmanager.cache.ResponseCache;
import com.cognos.pogo.contentmanager.cache.SearchParameters;
import com.cognos.pogo.contentmanager.cache.SearchPathUtils;
import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.timer.PogoTimer;
import java.util.Map;
import org.apache.log.Priority;

public class AccountCache
extends CacheContainer {
    private static PogoLogger log = PogoLogger.getLogger();
    private final CacheElementMap<String, ReportCache> reportsByReportName = new CacheElementMap(this);
    private PogoTimer timer;

    public AccountCache(CacheContainer parent, AccountItems accountItems) {
        super(parent, accountItems);
    }

    public PogoTimer getTimer() {
        return this.timer;
    }

    public void setTimer(PogoTimer timer) {
        this.timer = timer;
    }

    public AccountItems getAccountItems() {
        return (AccountItems)this.getResponseItems();
    }

    @Override
    public ResponseCache getParent() {
        return (ResponseCache)super.getParent();
    }

    public PackageItems getPackageForPackageName(String packageName) {
        PackageCache packageCache = this.getPackageCache(packageName);
        return packageCache != null ? packageCache.getPackageItems() : null;
    }

    protected PackageCache getPackageCache(String packageName) {
        return (PackageCache)this.getContainer(packageName);
    }

    public ReportItems getReportForReportName(String packageName, String reportName) {
        PackageCache packageCache = this.getPackageCache(packageName);
        return packageCache != null ? packageCache.getReportForReportName(reportName) : null;
    }

    public void saveCachedResponse(CachedResponse cachedResponse) {
        PackageCache packageCache = this.updatePackageCache(cachedResponse);
        if (packageCache != null) {
            this.updateReportCache(cachedResponse, packageCache);
        }
        this.updateAccountItems(cachedResponse);
    }

    private PackageCache updatePackageCache(CachedResponse cachedResponse) {
        PackageItems packageItems = cachedResponse.getPackageItems();
        String packageName = packageItems != null ? packageItems.getPackageName() : null;
        return packageName != null ? this.savePackage(packageName, packageItems, cachedResponse) : null;
    }

    private PackageCache savePackage(String packageName, PackageItems packageItems, CachedResponse cachedResponse) {
        PackageCache packageCache = this.getPackageCache(packageName);
        if (packageCache == null) {
            packageCache = this.addNewPackageCache(packageName, packageItems, cachedResponse);
        }
        packageCache.saveCachedResponse(cachedResponse);
        return packageCache;
    }

    private PackageCache addNewPackageCache(String packageName, PackageItems packageItems, CachedResponse cachedResponse) {
        PackageCache packageCache = new PackageCache((CacheContainer)this, packageItems);
        this.savePackageCache(packageName, packageCache);
        return packageCache;
    }

    private void savePackageCache(String packageName, PackageCache packageCache) {
        this.saveChildContainer(packageName, packageCache);
    }

    private void updateReportCache(CachedResponse cachedResponse, PackageCache packageCache) {
        ReportCache reportCache = packageCache.getReportCache(cachedResponse);
        if (reportCache != null) {
            this.saveReportCache(reportCache);
        }
    }

    private void saveReportCache(ReportCache reportCacheFromCM) {
        log.debug(this, ".saveReportCache(", reportCacheFromCM, ")");
        this.removeReportIfMovedToADifferentPackage(reportCacheFromCM);
        this.reportsByReportName.put(reportCacheFromCM.getName(), reportCacheFromCM);
    }

    private void removeReportIfMovedToADifferentPackage(ReportCache reportCacheFromCM) {
        PackageCache packageCacheFromCM;
        PackageCache packageCacheFromCache;
        ReportCache reportCacheFromCache = this.reportsByReportName.get(reportCacheFromCM.getName());
        PackageCache packageCache = packageCacheFromCache = reportCacheFromCache != null ? reportCacheFromCache.getParent() : null;
        if (packageCacheFromCache != null && (packageCacheFromCM = reportCacheFromCM.getParent()) != packageCacheFromCache) {
            packageCacheFromCache.removeChildContainer(reportCacheFromCache);
        }
    }

    private void updateAccountItems(CachedResponse responseFromCM) {
        AccountItems accountItemsFromTheCache;
        AccountItems accountItemsFromCM = responseFromCM.getAccountItems();
        if (accountItemsFromCM.hasCacheValidatorNewerThan(accountItemsFromTheCache = this.getAccountItems())) {
            this.useAccountItemsFromCM(accountItemsFromCM, accountItemsFromTheCache);
        } else {
            this.useAccountItemsFromTheCache(responseFromCM, accountItemsFromCM, accountItemsFromTheCache);
        }
    }

    private void useAccountItemsFromCM(AccountItems accountItemsFromCM, AccountItems accountItemsFromTheCache) {
        accountItemsFromCM.importCamElementsFromTheCache(accountItemsFromTheCache);
        this.setResponseItems(accountItemsFromCM);
    }

    private void useAccountItemsFromTheCache(CachedResponse responseFromCM, AccountItems accountItemsFromCM, AccountItems accountItemsFromTheCache) {
        responseFromCM.setAccountItems(accountItemsFromTheCache);
    }

    public void notifyReportRemoved(String reportName) {
        this.removeReportCache(reportName);
    }

    private void removeReportCache(String reportName) {
        log.debug(this, ".removeReportCache(", reportName, ")");
        this.reportsByReportName.remove(reportName);
    }

    public CachedResponse getCachedResponse(SearchParameters searchParameters) {
        ReportItems reportItems = this.getReportItems(searchParameters);
        String packageName = this.getPackageName(searchParameters, reportItems);
        PackageItems packageItems = this.getPackageForPackageName(packageName);
        return this.buildCachedRespone(reportItems, packageItems);
    }

    private ReportItems getReportItems(SearchParameters searchParameters) {
        return searchParameters.isSearchingForReport() ? this.getReportItems(searchParameters.getObjectPath()) : null;
    }

    private ReportItems getReportItems(String reportName) {
        ReportCache reportCache = this.getReportCache(reportName);
        return reportCache != null ? reportCache.getReportItems() : null;
    }

    protected ReportCache getReportCache(String reportName) {
        return reportName != null ? this.reportsByReportName.get(reportName) : null;
    }

    private String getPackageName(SearchParameters searchParameters, ReportItems reportItems) {
        if (searchParameters.isSearchingForPackage()) {
            return searchParameters.getObjectPath();
        }
        if (searchParameters.isSearchingForModel()) {
            return SearchPathUtils.getPackageFromModel(searchParameters.getObjectPath());
        }
        if (searchParameters.isSearchingForDatasourceSignon()) {
            return SearchPathUtils.getPackageFromDatasourceSignon(searchParameters.getObjectPath());
        }
        if (reportItems != null) {
            return reportItems.getPackageName();
        }
        return null;
    }

    private CachedResponse buildCachedRespone(ReportItems reportItems, PackageItems packageItems) {
        AccountItems accountItems = this.getAccountItems();
        CachedResponse cachedResponse = new CachedResponse(accountItems.getAccountName());
        cachedResponse.setAccountItems(accountItems);
        cachedResponse.setPackageItems(packageItems);
        cachedResponse.setReportItems(reportItems);
        return cachedResponse;
    }

    @Override
    protected void renewCacheValidators(CachedResponse responseFromCM) {
        this.renewCacheValidators(responseFromCM.getAccountItems());
        this.renewCacheValidatorsForPackageAndReport(responseFromCM.getPackageName(), responseFromCM);
    }

    private void renewCacheValidatorsForPackageAndReport(String packageName, CachedResponse responseFromCM) {
        if (packageName != null) {
            this.renewCacheValidators(packageName, responseFromCM);
        } else {
            this.renewCacheValidatorForIndividualReport(responseFromCM);
        }
    }

    private void renewCacheValidatorForIndividualReport(CachedResponse responseFromCM) {
        ReportCache reportCache;
        String reportName = responseFromCM.getReportName();
        ReportCache reportCache2 = reportCache = reportName != null ? this.reportsByReportName.get(reportName) : null;
        if (reportCache != null) {
            reportCache.renewCacheValidators(responseFromCM);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(PogoLogger log, String indent) {
        super.dump(log, indent, "Packages: ");
        indent = indent + "   ";
        log.debug(indent, "Reports: ");
        Object object = this.reportsByReportName.getMutex();
        synchronized (object) {
            for (Map.Entry<String, ReportCache> entry : this.reportsByReportName.entrySet()) {
                log.debug(indent + "   ", "Report name: ", entry.getKey());
                entry.getValue().dump(log, indent + "   ");
            }
        }
    }

    public static void setLogPriority(Priority priority) {
        log.setPriority(priority);
    }

    @Override
    public String toString() {
        return super.toString("Passport");
    }
}

