/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager.cache;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.pogo.contentmanager.cache.CMCacheRequestBodyHandler;
import com.cognos.pogo.contentmanager.cache.CMCacheService;
import com.cognos.pogo.contentmanager.cache.CacheValidator;
import com.cognos.pogo.contentmanager.cache.HandlerConfig;
import com.cognos.pogo.contentmanager.cache.HandlerSession;
import com.cognos.pogo.contentmanager.cache.HandlerSessionFactory;
import com.cognos.pogo.contentmanager.cache.ResponseCache;
import com.cognos.pogo.impl.DispatcherStrings;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.common.BodyHandler;
import com.cognos.pogo.pdk.common.BodyHandlerFactory;
import com.cognos.pogo.pdk.common.Envelope;
import com.cognos.pogo.util.PogoLogger;
import java.util.Collection;
import java.util.Locale;
import javax.mail.internet.InternetHeaders;

public class CMCacheHandler
extends BasicHandler
implements BodyHandlerFactory {
    private static final PogoLogger log = PogoLogger.getLogger();
    protected static final String cacheDisabledMessageCode = "contentManagerCacheService.disabled";
    protected static final String backwardCompatibleMessageCode = "contentManagerCacheService is disabled";
    private ResponseCache responseCache = new ResponseCache();
    private HandlerConfig handlerConfig;
    private HandlerSessionFactory factory;

    public CMCacheHandler() {
        this(new HandlerSessionFactory());
    }

    public CMCacheHandler(HandlerSessionFactory factory) {
        super(log.getNativeLogger());
        this.factory = factory;
    }

    @Override
    public void invokeImpl(MessageContext mc) {
        if (CMCacheService.isEnabled()) {
            this.handleRequest(mc);
        } else {
            this.tryToSendCacheDisabledFault(mc);
        }
    }

    private void handleRequest(MessageContext mc) {
        HandlerSession session = this.factory.createHandlerSession(mc, this.responseCache, this.handlerConfig);
        session.handleRequest();
    }

    private void tryToSendCacheDisabledFault(MessageContext mc) {
        try {
            this.sendCacheDisabledFault(mc);
        }
        catch (Exception e) {
            log.warn("Exception while attempting to send SOAP response: ", e);
        }
    }

    private void sendCacheDisabledFault(MessageContext mc) throws Exception {
        mc.setFault(this.getCacheDisabledFault(mc));
        mc.setProperty("response.status_code", "500");
        mc.setProperty("response.status_msg", "Internal Server Error");
        mc.setProperty("response.headers", new InternetHeaders());
        mc.setProperty("response.envelope", this.getFaultEnvelope(mc));
        mc.respond("response");
    }

    private Fault getCacheDisabledFault(MessageContext mc) {
        Fault fault = new Fault(backwardCompatibleMessageCode);
        fault.setDetailMessasge(this.getMessageString(mc));
        return fault;
    }

    private String getMessageString(MessageContext mc) {
        Locale locale = (Locale)mc.getProperty("locale");
        return DispatcherStrings.getInstance().getString(cacheDisabledMessageCode, locale);
    }

    private Envelope getFaultEnvelope(MessageContext mc) {
        Fault fault = mc.getFault();
        BIBusEnvelope requestEnvelope = (BIBusEnvelope)mc.getProperty("request.envelope");
        return fault.generateEnvelope(requestEnvelope);
    }

    private void updateConfiguration(Configuration config) {
        try {
            this.handlerConfig = new HandlerConfig(config);
            CMCacheService.setConfig(this.handlerConfig);
            CacheValidator.updateConfiguration(this.handlerConfig);
            this.responseCache.updateConfiguration(this.handlerConfig);
        }
        catch (Exception e) {
            log.error("Exception while attempting to update the handler configuration: ", e);
        }
    }

    @Override
    public void configure(Configuration config) {
        this.logConfiguration("configure", config);
        this.updateConfiguration(config);
    }

    private void logConfiguration(String callerMethodName, Configuration config) {
        log.debug("Entered ", callerMethodName, "() with the following configuration parameters:");
        if (log.isDebugEnabled()) {
            this.tryToLogAllConfigParameters(config);
        }
    }

    private void tryToLogAllConfigParameters(Configuration config) {
        try {
            this.logAllConfigParameters(config);
        }
        catch (Exception e) {
            log.debug("Failed to log configuration parameters");
        }
    }

    private void logAllConfigParameters(Configuration config) throws CCLConfigurationException {
        ICCLConfiguration cclConfig = config.getICCLConfiguration();
        Collection parameterNames = cclConfig.getParameterNames();
        for (String parameterName : parameterNames) {
            log.debug("   ", parameterName, " = ", config.getValue(parameterName));
        }
    }

    @Override
    public void reconfigure(Configuration config) {
        this.logConfiguration("reconfigure", config);
        this.updateConfiguration(config);
    }

    @Override
    public void resume() {
        log.enter();
        CMCacheService.setSuspended(false);
    }

    @Override
    public void suspend(boolean immediate) {
        log.enter();
        CMCacheService.setSuspended(true);
    }

    public int getHeapLimit() {
        return this.responseCache.getHeapLimit();
    }

    @Override
    public BodyHandler createBodyHandler() {
        return new CMCacheRequestBodyHandler();
    }
}

