/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager.cache;

import com.cognos.pogo.contentmanager.cache.SearchType;
import com.cognos.pogo.contentmanager.cache.remote.QueryRequests;
import com.cognos.pogo.pdk.stax.StaxBodyHandler;
import com.cognos.pogo.pdk.stax.cam.StaxEntries;
import com.cognos.pogo.stax.utils.StaxBase;
import com.cognos.pogo.stax.utils.StaxItemArray;
import com.cognos.pogo.stax.utils.StaxNameValuePairArray;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang.StringUtils;

public class CMCacheRequestBodyHandler
extends StaxBase
implements StaxBodyHandler {
    private static final String[] SUPPORTED_METHODS = new String[]{"queryCache", "custom"};
    private static final String CMCS = "CMCS";
    private static final String CMCS_URI = "http://developer.cognos.com/schemas/contentManagerCacheService/1";
    private static final String OBJECT_PATH = "objectPath";
    private static final String SEARCH_PATH_SINGLE_OBJECT = "searchPathSingleObject";
    private static final String SEARCH_TYPE = "searchType";
    private static final String ENTRIES = "entries";
    private static final String CLASS_ENUM = "classEnum";
    private static final String OPTIONS = "options";
    private static final String CONTEXT_URI = "http://developer.cognos.com/ceba/constants/contentManagerCacheOptionEnum#context";
    private String methodName;
    private SearchType searchType;
    private String objectPath;
    private StaxEntries entries = StaxEntries.NULL;
    private StaxNameValuePairArray options = StaxNameValuePairArray.NULL;
    private QueryRequests queryRequests = QueryRequests.NULL;

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public boolean canParse(String entryName) {
        for (String method : SUPPORTED_METHODS) {
            if (!method.equals(entryName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void parse(XMLStreamReader xsr, String entryName) throws XMLStreamException {
        this.methodName = entryName;
        super.parse(xsr, entryName);
    }

    @Override
    public boolean isPresent() {
        return this.methodName != null;
    }

    @Override
    protected void parseElement(XMLStreamReader xsr, String localName) throws XMLStreamException {
        if (localName.equals(OBJECT_PATH)) {
            this.objectPath = xsr.getElementText();
        } else if (localName.equals(SEARCH_TYPE)) {
            this.searchType = this.parseSearchType(xsr);
        } else if (localName.equals(ENTRIES)) {
            this.entries = new StaxEntries(xsr);
        } else if (localName.equals(OPTIONS)) {
            this.options = new StaxNameValuePairArray(xsr, localName);
        } else if (this.queryRequests.canParse(localName)) {
            this.queryRequests = new QueryRequests(xsr);
        }
    }

    private SearchType parseSearchType(XMLStreamReader xsr) throws XMLStreamException {
        String searchTypeText = xsr.getElementText();
        return StringUtils.isEmpty((String)searchTypeText) ? SearchType.NULL : SearchType.getValueOf(searchTypeText);
    }

    public String getContextValue() {
        return this.options.get(CONTEXT_URI);
    }

    public SearchType getSearchType() {
        return this.searchType;
    }

    public String getObjectPath() {
        return this.objectPath;
    }

    public StaxItemArray getEntries() {
        return this.entries;
    }

    public QueryRequests getQueryRequests() {
        return this.queryRequests;
    }

    @Override
    public void writeXML(XMLStreamWriter xsw, boolean writeNamespace) throws XMLStreamException {
        CMCacheRequestBodyHandler.writeStartServiceElement(this.methodName, CMCS, CMCS_URI, xsw);
        this.writeObjectPath(xsw);
        this.writeSearchType(xsw);
        this.writeEntries(xsw);
        this.writeOptions(xsw);
        this.writeQueryRequests(xsw);
        xsw.writeEndElement();
        xsw.flush();
    }

    private void writeObjectPath(XMLStreamWriter xsw) throws XMLStreamException {
        if (this.objectPath != null) {
            CMCacheRequestBodyHandler.writeBusElement(OBJECT_PATH, this.objectPath, SEARCH_PATH_SINGLE_OBJECT, xsw);
        }
    }

    private void writeSearchType(XMLStreamWriter xsw) throws XMLStreamException {
        if (this.searchType != null) {
            CMCacheRequestBodyHandler.writeBusElement(SEARCH_TYPE, this.searchType.name().toLowerCase(), CLASS_ENUM, xsw);
        }
    }

    private void writeEntries(XMLStreamWriter xsw) throws XMLStreamException {
        if (this.entries != null) {
            this.entries.writeXML(xsw, false);
        }
    }

    private void writeQueryRequests(XMLStreamWriter xsw) throws XMLStreamException {
        if (this.queryRequests.isPresent()) {
            this.queryRequests.writeXML(xsw, false);
        }
    }

    private void writeOptions(XMLStreamWriter xsw) throws XMLStreamException {
        if (this.options.isPresent()) {
            this.options.writeXML(xsw, false);
        }
    }

    @Override
    public String getReportPath() {
        return null;
    }
}

