/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager.cache;

import com.cognos.pogo.contentmanager.cache.StringPoolUser;
import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.StringUtils;
import com.cognos.pogo.util.timer.PogoTime;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log.Priority;

public abstract class CacheElement
extends StringPoolUser {
    private static PogoLogger log = PogoLogger.getLogger();
    private static int maxLogLengthForStrings = 80;
    private static PogoTime cacheTime = new PogoTime();
    private static boolean isAccessTimeUpdateEnabled = true;
    private AtomicLong lastAccessTime = new AtomicLong();
    private CacheElement parent;

    public CacheElement() {
        this(null);
    }

    public CacheElement(CacheElement parent) {
        this.setParent(parent);
        this.updateAccessTime();
    }

    public void setParent(CacheElement parent) {
        this.parent = parent;
    }

    public CacheElement getParent() {
        return this.parent;
    }

    public static void setCacheTime(PogoTime cacheTime) {
        CacheElement.cacheTime = cacheTime;
    }

    protected String formatStringForDebugLogging(String s) {
        return "(" + this.getLength(s) + " bytes) " + StringUtils.shorten(s, 20);
    }

    protected void handleRemovalFromCache() {
        this.setParent(null);
    }

    protected String getClassName() {
        return this.getClass().getSimpleName();
    }

    protected int getLength(String s) {
        return s != null ? s.length() : 0;
    }

    protected void handleElementRemovedFromCache(CacheElement removedElement) {
        removedElement.handleRemovalFromCache();
    }

    protected void handleElementRemovedFromCache(String key, CacheElement removedElement) {
        this.handleElementRemovedFromCache(removedElement);
    }

    public void updateAccessTime() {
        if (isAccessTimeUpdateEnabled) {
            this.updateAccessTime(cacheTime.getCurrentTime());
        }
    }

    private void updateAccessTime(long lastAccessTime) {
        this.lastAccessTime.set(lastAccessTime);
        this.updateParentAccessTime();
    }

    private void updateParentAccessTime() {
        if (this.parent != null) {
            this.parent.updateAccessTime(this.getLastAccessTime());
        }
    }

    public long getLastAccessTime() {
        return this.lastAccessTime.get();
    }

    public long getInactiveTime() {
        return cacheTime.getCurrentTime() - this.getLastAccessTime();
    }

    public static void disableAccessTimeUpdates() {
        isAccessTimeUpdateEnabled = false;
    }

    public static void enableAccessTimeUpdates() {
        isAccessTimeUpdateEnabled = true;
    }

    protected int getAgeDifference(CacheElement other) {
        return (int)(this.getLastAccessTime() - other.getLastAccessTime());
    }

    public void dump(PogoLogger log, String indent) {
        log.debug(indent, this, ": ");
        indent = indent + "   ";
        log.debug(indent, "parent: ", this.getParent());
        log.debug(indent, "lastAccessTime: ", this.lastAccessTime);
    }

    protected String getStringForLogging(String string) {
        if (string == null) {
            return "(null value)";
        }
        return "(" + string.length() + " bytes) " + StringUtils.shorten(string, maxLogLengthForStrings);
    }

    public static void setMaxLogLength(int maxLogLength) {
        maxLogLengthForStrings = maxLogLength;
    }

    public static void setLogPriority(Priority priority) {
        log.setPriority(priority);
    }

    public String toString() {
        return this.getClassName();
    }
}

