/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager.cache;

import com.cognos.pogo.contentmanager.cache.AccountItems;
import com.cognos.pogo.contentmanager.cache.CacheContainer;
import com.cognos.pogo.contentmanager.cache.Model;
import com.cognos.pogo.contentmanager.cache.PackageItems;
import com.cognos.pogo.contentmanager.cache.QueryResult;
import com.cognos.pogo.contentmanager.cache.ReportItems;
import com.cognos.pogo.contentmanager.cache.ResponseItems;
import com.cognos.pogo.contentmanager.cache.SearchParameters;
import com.cognos.pogo.contentmanager.cache.context.CacheContext;
import com.cognos.pogo.util.PogoLogger;
import org.apache.commons.lang.StringUtils;

public class CachedResponse {
    private static final PogoLogger log = PogoLogger.getLogger();
    private String passport;
    private AccountItems accountItems;
    private PackageItems packageItems;
    private ReportItems reportItems;
    private String cacheValidator;
    private String temporaryHeader;
    private String fault;
    private String faultErrorCode;

    public CachedResponse(String passport) {
        this.setPassport(passport);
    }

    public String getPassport() {
        return this.passport;
    }

    public void setPassport(String passport) {
        this.passport = passport;
    }

    public void setReportItems(ReportItems reportItems) {
        this.reportItems = reportItems;
    }

    public void setPackageItems(PackageItems packageItems) {
        this.packageItems = packageItems;
    }

    public void setAccountItems(AccountItems accountItems) {
        this.accountItems = accountItems;
        this.saveHeader(accountItems);
    }

    private void saveHeader(AccountItems accountItems) {
        if (this.temporaryHeader != null) {
            accountItems.setHeader(this.temporaryHeader);
        }
        this.temporaryHeader = null;
    }

    public ReportItems getReportItems() {
        return this.reportItems;
    }

    public PackageItems getPackageItems() {
        return this.packageItems;
    }

    public AccountItems getAccountItems() {
        return this.accountItems;
    }

    public boolean hasAccountItems() {
        return this.accountItems != null && this.accountItems.hasAccountData();
    }

    public QueryResult getQueryResultFor(String itemName, SearchParameters searchParameters) {
        QueryResult queryResult = this.getQueryResult(this.accountItems, itemName, searchParameters);
        if (queryResult.isEmpty() && (queryResult = this.getQueryResult(this.packageItems, itemName, searchParameters)).isEmpty()) {
            queryResult = this.getQueryResult(this.reportItems, itemName, searchParameters);
        }
        return queryResult;
    }

    private QueryResult getQueryResult(ResponseItems responseItems, String itemName, SearchParameters searchParameters) {
        return responseItems != null ? responseItems.getQueryResultFor(itemName, searchParameters) : QueryResult.NULL;
    }

    public String getCacheValidator() {
        return this.cacheValidator;
    }

    public void setCacheValidator(String cacheValidator) {
        this.cacheValidator = cacheValidator;
    }

    public String getHeader() {
        return this.accountItems != null ? this.accountItems.getHeader() : this.temporaryHeader;
    }

    public void setHeader(String header) {
        this.temporaryHeader = header;
        if (this.accountItems != null) {
            this.saveHeader(this.accountItems);
        }
    }

    public boolean hasNoFault() {
        return !this.hasFault();
    }

    public boolean hasFault() {
        return this.getFault() != null;
    }

    public String getFault() {
        return this.fault;
    }

    public void setFault(String fault) {
        this.fault = fault;
    }

    public boolean hasHeaderFault() {
        return StringUtils.equals((String)this.getFaultErrorCode(), (String)"cmHeaderFault");
    }

    public boolean hasNoReadFault() {
        return StringUtils.equals((String)this.getFaultErrorCode(), (String)"cmNoRead");
    }

    public String getFaultErrorCode() {
        return this.faultErrorCode;
    }

    public void setFaultErrorCode(String faultErrorCode) {
        this.faultErrorCode = faultErrorCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append(": ");
        sb.append("Passport: ").append(this.getPassport());
        sb.append(", Account: ").append(this.getAccountName());
        sb.append(", Package: ").append(this.getPackageName());
        sb.append(", Report: ").append(this.getReportName());
        return sb.toString();
    }

    public String getReportName() {
        return this.reportItems != null ? this.reportItems.getReportName() : null;
    }

    public String getPackageName() {
        return this.packageItems != null ? this.packageItems.getPackageName() : null;
    }

    public String getAccountName() {
        return this.accountItems != null ? this.accountItems.getAccountName() : null;
    }

    public boolean hasCacheValidatorsNewerThan(CachedResponse responseInTheCache) {
        return responseInTheCache == null || this.failedCachedValidation(this.accountItems, responseInTheCache.accountItems) || this.failedCachedValidation(this.packageItems, responseInTheCache.packageItems) || this.failedCachedValidation(this.reportItems, responseInTheCache.reportItems);
    }

    private boolean failedCachedValidation(ResponseItems responseItemsFromCM, ResponseItems responseItemsFromTheCache) {
        return responseItemsFromCM != null && responseItemsFromCM.hasCacheValidatorNewerThan(responseItemsFromTheCache);
    }

    public boolean hasLingeringCacheValidator(SearchParameters searchParameters) {
        if (searchParameters.isSearchingForReport()) {
            return this.hasReportLingeringCacheValidator();
        }
        if (searchParameters.isSearchingForModel() || searchParameters.isSearchingForPackage()) {
            return this.hasPackageLingeringCacheValidator();
        }
        if (searchParameters.isSearchingForDatasourceSignon()) {
            return this.hasDataSourceLingeringCacheValidator();
        }
        if (searchParameters.isSearchingForAccount()) {
            return this.hasAccountLingeringCacheValidator();
        }
        return false;
    }

    private boolean hasAccountLingeringCacheValidator() {
        return this.hasLingeringCacheValidator(this.accountItems);
    }

    private boolean hasDataSourceLingeringCacheValidator() {
        return this.hasLingeringCacheValidator(this.packageItems);
    }

    private boolean hasPackageLingeringCacheValidator() {
        return this.hasAccountLingeringCacheValidator() && this.hasDataSourceLingeringCacheValidator();
    }

    private boolean hasReportLingeringCacheValidator() {
        return this.hasAccountLingeringCacheValidator() && this.hasDataSourceLingeringCacheValidator() && this.hasLingeringCacheValidator(this.reportItems);
    }

    private boolean hasLingeringCacheValidator(ResponseItems responseItems) {
        return responseItems != null && responseItems.hasLingeringCacheValidator();
    }

    public boolean hasAnExpiredCacheValidator() {
        return this.hasAnExpiredCacheValidatorIn(this.accountItems) || this.hasAnExpiredCacheValidatorIn(this.packageItems) || this.hasAnExpiredCacheValidatorIn(this.reportItems);
    }

    private boolean hasAnExpiredCacheValidatorIn(ResponseItems responseItems) {
        return responseItems != null && responseItems.hasAnExpiredCacheValidator();
    }

    public String getCacheContext(SearchParameters searchParameters) {
        CacheContext cacheContext = CacheContext.createEmptyCacheContext();
        cacheContext.addLocalNodeID();
        cacheContext.addResponseItems(this.reportItems, searchParameters);
        cacheContext.addResponseItems(this.packageItems, searchParameters);
        cacheContext.addResponseItems(this.accountItems, searchParameters);
        return cacheContext.toString();
    }

    public ResponseItems getResponseItemsFor(String queryName, String searchPath) {
        if (this.accountItems != null && this.accountItems.canHandleQuery(queryName, searchPath)) {
            return this.accountItems;
        }
        if (this.packageItems != null && this.packageItems.canHandleQuery(queryName, searchPath)) {
            return this.packageItems;
        }
        if (this.reportItems != null && this.reportItems.canHandleQuery(queryName, searchPath)) {
            return this.reportItems;
        }
        return null;
    }

    public boolean hasDatasource(String datasourceSearchPath) {
        return this.packageItems != null && this.packageItems.hasDatasource(datasourceSearchPath);
    }

    public Model getModel(String modelSearchPath) {
        return this.packageItems != null ? this.packageItems.getModel(modelSearchPath) : null;
    }

    public void expireLingerTime(SearchParameters searchParameters) {
        if (searchParameters.isSearchingForReport()) {
            this.expireReportLingerTime();
        } else if (searchParameters.isSearchingForModel() || searchParameters.isSearchingForPackage()) {
            this.expirePackageLingerTime();
        } else if (searchParameters.isSearchingForDatasourceSignon()) {
            this.expireDatasourceSignonLingerTime();
        } else if (searchParameters.isSearchingForAccount()) {
            this.expireAccountLingerTime();
        }
    }

    private void expireReportLingerTime() {
        this.expireLingerTime(this.accountItems);
        this.expireLingerTime(this.packageItems);
        this.expireLingerTime(this.reportItems);
    }

    private void expirePackageLingerTime() {
        this.expireLingerTime(this.accountItems);
        this.expireLingerTime(this.packageItems);
    }

    private void expireAccountLingerTime() {
        this.expireLingerTime(this.accountItems);
    }

    private void expireDatasourceSignonLingerTime() {
        this.expireLingerTime(this.packageItems);
    }

    private void expireLingerTime(ResponseItems responseItems) {
        if (responseItems != null) {
            responseItems.expireLingerTime();
        }
    }

    public boolean hasPackageItemsFor(String objectPath) {
        return objectPath.equals(this.getPackageName()) && !this.getPackageItems().isEmpty();
    }

    public boolean hasReportItemsFor(String objectPath) {
        if (!objectPath.equals(this.getReportName())) {
            return false;
        }
        if (this.hasReportItems()) {
            return true;
        }
        this.handleReportWithEmptyItems();
        return false;
    }

    private boolean hasReportItems() {
        return this.reportItems != null && !this.reportItems.isEmpty();
    }

    private void handleReportWithEmptyItems() {
        CacheContainer reportCache = this.getReportItems().getOwner();
        log.warn("Removing report with empty items from the cache: ", reportCache);
        reportCache.leaveCache();
        this.setReportItems(null);
    }
}

