/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager.cache;

import com.cognos.pogo.contentmanager.cache.CacheElement;
import com.cognos.pogo.contentmanager.cache.DatasourceSignon;
import com.cognos.pogo.contentmanager.cache.SearchParameters;
import com.cognos.pogo.contentmanager.cache.SearchPathUtils;
import com.cognos.pogo.contentmanager.cache.context.CacheContext;
import com.cognos.pogo.contentmanager.cache.level2.Level2Query;
import com.cognos.pogo.contentmanager.cache.level2.QueryRequest;
import com.cognos.pogo.util.PogoLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class DatasourceSignons
extends CacheElement {
    private final Map<String, DatasourceSignon> datasourceSignonsByName = Collections.synchronizedMap(new LinkedHashMap());

    private DatasourceSignon getOrCreateDatasourceSignon(String datasourceSignonSearchPath) {
        DatasourceSignon datasourceSignon = this.getDatasourceSignon(datasourceSignonSearchPath);
        if (datasourceSignon == null) {
            datasourceSignon = this.createDatasourceSignon(datasourceSignonSearchPath);
        }
        return datasourceSignon;
    }

    public DatasourceSignon getDatasourceSignon(String datasourceSignonSearchPath) {
        String datasourceSignonName = SearchPathUtils.getDatasourceSignonSearchPath(datasourceSignonSearchPath);
        return this.datasourceSignonsByName.get(datasourceSignonName);
    }

    protected DatasourceSignon createDatasourceSignon(String datasourceSignonSearchPath) {
        String datasourceSignonName = SearchPathUtils.getDatasourceSignonSearchPath(datasourceSignonSearchPath);
        DatasourceSignon datasourceSignon = new DatasourceSignon(datasourceSignonName);
        this.datasourceSignonsByName.put(datasourceSignonName, datasourceSignon);
        return datasourceSignon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAllDatasourceSignonsToQuery(Level2Query query, SearchParameters searchParameters, CacheContext cacheContext) {
        Map<String, DatasourceSignon> map = this.datasourceSignonsByName;
        synchronized (map) {
            for (DatasourceSignon datasourceSignon : this.datasourceSignonsByName.values()) {
                datasourceSignon.addRequestToQuery(query, searchParameters, cacheContext);
            }
        }
    }

    public QueryRequest addRequestToQuery(Level2Query query, SearchParameters searchParameters, CacheContext cacheContext) {
        String datasourceSignonSearchPath = searchParameters.getObjectPath();
        DatasourceSignon datasourceSignon = this.getDatasourceSignon(datasourceSignonSearchPath);
        if (datasourceSignon != null) {
            return datasourceSignon.addRequestToQuery(query, searchParameters, cacheContext);
        }
        return DatasourceSignons.addRequestForDatasourceSignonQuery(query, datasourceSignonSearchPath);
    }

    private static QueryRequest addRequestForDatasourceSignonQuery(Level2Query query, String datasourceSignonSearchPath) {
        String datasourceSignonName = SearchPathUtils.getDatasourceSignonSearchPath(datasourceSignonSearchPath);
        return DatasourceSignon.addRequestForUnknownItem(query, datasourceSignonName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAllItems() {
        ArrayList<String> items = new ArrayList<String>();
        Map<String, DatasourceSignon> map = this.datasourceSignonsByName;
        synchronized (map) {
            for (DatasourceSignon datasourceSignon : this.datasourceSignonsByName.values()) {
                items.addAll(datasourceSignon.getAllItemValues());
            }
        }
        return items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void intern() {
        Map<String, DatasourceSignon> map = this.datasourceSignonsByName;
        synchronized (map) {
            HashMap<String, DatasourceSignon> snapshot = new HashMap<String, DatasourceSignon>(this.datasourceSignonsByName);
            this.datasourceSignonsByName.clear();
            for (Map.Entry entry : snapshot.entrySet()) {
                String datasourceSignonName = (String)entry.getKey();
                DatasourceSignon datasourceSignon = (DatasourceSignon)entry.getValue();
                this.datasourceSignonsByName.put(this.intern(datasourceSignonName), datasourceSignon.intern());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRemovalFromCache() {
        super.handleRemovalFromCache();
        Map<String, DatasourceSignon> map = this.datasourceSignonsByName;
        synchronized (map) {
            for (DatasourceSignon datasourceSignon : this.datasourceSignonsByName.values()) {
                datasourceSignon.handleRemovalFromCache();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(PogoLogger log, String indent) {
        super.dump(log, indent);
        indent = indent + "   ";
        Map<String, DatasourceSignon> map = this.datasourceSignonsByName;
        synchronized (map) {
            for (Map.Entry<String, DatasourceSignon> entry : this.datasourceSignonsByName.entrySet()) {
                log.debug(indent, "datasourceSignonName: ", entry.getKey());
                log.debug(indent, "datasourceSignon: ", entry.getValue());
            }
        }
    }

    public void importDatasourceSignonsFromTheCache(DatasourceSignons datasourceSignonsFromTheCache) {
        for (DatasourceSignon datasourceSignonFromCache : this.getDatasourceSignonList(datasourceSignonsFromTheCache)) {
            this.addDatasourceSignonFromCacheIfNeeded(datasourceSignonFromCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DatasourceSignon> getDatasourceSignonList(DatasourceSignons datasourceSignons) {
        Map<String, DatasourceSignon> map = datasourceSignons.datasourceSignonsByName;
        synchronized (map) {
            return new ArrayList<DatasourceSignon>(datasourceSignons.datasourceSignonsByName.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDatasourceSignonFromCacheIfNeeded(DatasourceSignon datasourceSignonFromCache) {
        Map<String, DatasourceSignon> map = this.datasourceSignonsByName;
        synchronized (map) {
            String datasourceSignonName = datasourceSignonFromCache.getKey();
            DatasourceSignon datasourceSignonFromCM = this.datasourceSignonsByName.get(datasourceSignonName);
            if (datasourceSignonFromCM == null || datasourceSignonFromCM.isEmpty()) {
                this.addDatasourceSignon(datasourceSignonFromCache);
            }
        }
    }

    private void addDatasourceSignon(DatasourceSignon datasourceSignon) {
        this.datasourceSignonsByName.put(datasourceSignon.getKey(), datasourceSignon);
    }

    public void importDatasourceSignonsFromCM(DatasourceSignons datasourceSignonsFromCM) {
        for (DatasourceSignon datasourceFromCM : this.getDatasourceSignonList(datasourceSignonsFromCM)) {
            this.addDatasourceSignonFromCmIfNeeded(datasourceFromCM);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDatasourceSignonFromCmIfNeeded(DatasourceSignon datasourceSignonFromCM) {
        Map<String, DatasourceSignon> map = this.datasourceSignonsByName;
        synchronized (map) {
            if (datasourceSignonFromCM != null && !datasourceSignonFromCM.isEmpty()) {
                this.addDatasourceSignon(datasourceSignonFromCM);
            }
        }
    }

    public void parseResponse(String responseName, Map<String, String> attributes, XMLStreamReader reader) throws XMLStreamException {
        String datasourceSignonSearchPath = attributes.get("searchPath");
        DatasourceSignon datasourceSignon = this.getOrCreateDatasourceSignon(datasourceSignonSearchPath);
        datasourceSignon.parseResponse(responseName, attributes, reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasDatasourceSignonWithFailedValidation() {
        Map<String, DatasourceSignon> map = this.datasourceSignonsByName;
        synchronized (map) {
            for (DatasourceSignon datasourceSignon : this.datasourceSignonsByName.values()) {
                if (!datasourceSignon.hasFailedValidation()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAnExpiredCacheValidator() {
        Map<String, DatasourceSignon> map = this.datasourceSignonsByName;
        synchronized (map) {
            for (DatasourceSignon datasourceSignon : this.datasourceSignonsByName.values()) {
                if (!datasourceSignon.hasAnExpiredCacheValidator()) continue;
                return true;
            }
        }
        return false;
    }

    public void renewCacheValidators(DatasourceSignons datasourceSignonsFromCM) {
        for (DatasourceSignon datasourceSignonFromCM : this.getDatasourceSignonList(datasourceSignonsFromCM)) {
            this.renewCacheValidator(datasourceSignonFromCM);
        }
    }

    private void renewCacheValidator(DatasourceSignon datasourceSignonFromCM) {
        String datasourceSignonName = datasourceSignonFromCM.getKey();
        DatasourceSignon datasourceSignonFromCache = this.datasourceSignonsByName.get(datasourceSignonName);
        if (datasourceSignonFromCache != null) {
            datasourceSignonFromCache.renewCacheValidator(datasourceSignonFromCM);
        }
    }

    public List<DatasourceSignon> getDatasourceSignonList() {
        return this.getDatasourceSignonList(this);
    }
}

