/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager.cache;

import java.util.ArrayList;
import java.util.List;

public class QueryResult {
    public static final QueryResult NULL = new QueryResult();
    private List<String> elementStrings;
    private int nrOfElements;

    public QueryResult(List<String> elementStrings, int nrOfItems) {
        this.elementStrings = elementStrings;
        this.nrOfElements = nrOfItems;
    }

    public QueryResult(List<String> elementStrings) {
        this(elementStrings, elementStrings.size());
    }

    public QueryResult() {
        this(new ArrayList<String>(), 0);
    }

    public QueryResult(String element) {
        this();
        this.elementStrings.add(element);
        this.nrOfElements = 1;
    }

    public List<String> getStrings() {
        return this.elementStrings;
    }

    public int getNrOfElements() {
        return this.nrOfElements;
    }

    public void add(QueryResult result) {
        if (this == NULL) {
            throw new RuntimeException("Can't change NULL object");
        }
        this.elementStrings.addAll(result.getStrings());
        this.nrOfElements += result.getNrOfElements();
    }

    public void add(String item) {
        if (this == NULL) {
            throw new RuntimeException("Can't change NULL object");
        }
        this.elementStrings.add(item);
        ++this.nrOfElements;
    }

    public boolean isEmpty() {
        return this.elementStrings.isEmpty();
    }

    public String get(int i) {
        return this.elementStrings.get(i);
    }

    public boolean equals(QueryResult otherQueryResult) {
        if (this.isSizeDifferentThan(otherQueryResult)) {
            return false;
        }
        for (int i = 0; i < this.elementStrings.size(); ++i) {
            if (this.elementStrings.get(i).equals(otherQueryResult.elementStrings.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean isSizeDifferentThan(QueryResult otherQueryResult) {
        return this.nrOfElements != otherQueryResult.nrOfElements || this.elementStrings.size() != otherQueryResult.elementStrings.size();
    }

    public boolean isSameAs(QueryResult otherQueryResult) {
        if (this.isSizeDifferentThan(otherQueryResult)) {
            return false;
        }
        for (int i = 0; i < this.elementStrings.size(); ++i) {
            if (this.elementStrings.get(i) == otherQueryResult.elementStrings.get(i)) continue;
            return false;
        }
        return true;
    }
}

