/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager.cache;

import com.cognos.pogo.contentmanager.cache.Model;
import com.cognos.pogo.contentmanager.cache.PackageItems;
import com.cognos.pogo.contentmanager.cache.QueryResult;
import com.cognos.pogo.contentmanager.cache.ResponseItems;
import com.cognos.pogo.contentmanager.cache.SearchParameters;
import com.cognos.pogo.contentmanager.cache.SearchPathUtils;
import com.cognos.pogo.contentmanager.cache.SoapTokens;
import com.cognos.pogo.contentmanager.cache.context.CacheContext;
import com.cognos.pogo.contentmanager.cache.level2.Level2Query;
import com.cognos.pogo.contentmanager.cache.level2.QueryRequest;
import com.cognos.pogo.contentmanager.cache.remote.RemoteDispatcherResponse;
import com.cognos.pogo.stax.utils.StaxUtils;
import com.cognos.pogo.util.XmlUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang.StringUtils;

public class ReportItems
extends ResponseItems {
    private static final int NUMBER_OF_REPORT_ELEMENTS = 4;
    private static final int NUMBER_OF_REPORT_CACHE_ELEMENTS = 2;
    private static final String QUERY_NAME = "reportQuery";
    private static final String MAIN_ITEM_NAME = "report";
    private static final Collection<String> keyItemAliases = new ArrayList<String>();
    private String modelName;

    @Override
    public String getQueryName(SearchParameters searchParameters) {
        return QUERY_NAME;
    }

    @Override
    protected boolean isKeyItemName(String itemName) {
        return keyItemAliases.contains(itemName);
    }

    @Override
    protected String getMainItemNameFor(String itemName) {
        return this.isKeyItemName(itemName) ? MAIN_ITEM_NAME : itemName;
    }

    @Override
    public PackageItems getParent() {
        return (PackageItems)super.getParent();
    }

    @Override
    protected void parseResponse(XMLStreamReader reader) throws XMLStreamException {
        this.parseQueryResponse(reader);
        this.parseHints(reader);
    }

    void parseHints(XMLStreamReader reader) throws XMLStreamException {
        if ("hints".equals(reader.getLocalName())) {
            while (StaxUtils.iterateChildrenElement("hint", reader)) {
                if (!StaxUtils.iterateChildrenElement("metadataModel", reader)) continue;
                this.setModelName(reader);
            }
        }
    }

    private void setModelName(XMLStreamReader reader) throws XMLStreamException {
        String modelSearchPath = reader.getElementText();
        this.setModelName(SearchPathUtils.getModelName(modelSearchPath));
    }

    @Override
    public ReportItems intern() {
        this.setModelName(this.intern(this.getModelName()));
        return (ReportItems)super.intern();
    }

    private String getModelName() {
        return this.modelName;
    }

    private String getFullModelName() {
        return this.getPackageName() + '/' + this.modelName;
    }

    public String getReportName() {
        return this.getKey();
    }

    public void setReportName(String searchPath) {
        this.setKey(searchPath);
    }

    public String getPackageName() {
        PackageItems packageItems = this.getParent();
        return packageItems != null ? packageItems.getPackageName() : null;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public static void addRequestForUnknownItemIfNeeded(Level2Query query, SearchParameters searchParameters, CacheContext cacheContext) {
        if (searchParameters.isSearchingForReport()) {
            QueryRequest request = query.addQueryRequest(QUERY_NAME);
            request.setSearchPath(searchParameters.getObjectPath());
            request.setId(query.getQueryReportId());
        }
    }

    @Override
    public QueryRequest addRequestToQuery(Level2Query query, SearchParameters searchParameters, CacheContext cacheContext) {
        if (this.hasLingeringCacheValidator()) {
            return null;
        }
        QueryRequest request = super.addRequestToQuery(query, searchParameters, cacheContext);
        request.setSearchPath(this.getReportName());
        if (this.isPackageUnknown()) {
            request.setId(query.getQueryReportId());
        }
        return request;
    }

    private boolean isPackageUnknown() {
        return this.getPackageName() == null;
    }

    @Override
    public QueryResult getQueryResultFor(String itemName, SearchParameters searchParameters) {
        if (this.isReportCache(itemName) || this.isReportMetadata(itemName)) {
            return this.getAllItemsFor(itemName);
        }
        if (this.isModel(itemName)) {
            return this.getModelItem();
        }
        if (this.isModelView(itemName)) {
            return this.getModelViewItems();
        }
        return super.getQueryResultFor(itemName, searchParameters);
    }

    private QueryResult getModelViewItems() {
        Model modelItem = this.getModel();
        return modelItem != null ? modelItem.getAllModelViews() : QueryResult.NULL;
    }

    private QueryResult getModelItem() {
        Model modelItem = this.getModel();
        return modelItem != null ? modelItem.getModelItem() : QueryResult.NULL;
    }

    private Model getModel() {
        return this.getModel(this.getParent());
    }

    protected Model getModel(PackageItems packageItems) {
        Model model = null;
        if (packageItems != null) {
            if (this.modelName != null) {
                model = packageItems.getModel(this.modelName);
            } else {
                List<Model> models = packageItems.getModels().getModelList();
                if (models.size() == 1) {
                    model = models.get(0);
                }
            }
        }
        return model;
    }

    private boolean isReportCache(String itemName) {
        return "reportCache".equals(itemName);
    }

    private boolean isReportMetadata(String itemName) {
        return "reportMetadata".equals(itemName);
    }

    private boolean isModel(String itemName) {
        return "model".equals(itemName);
    }

    private boolean isModelView(String itemName) {
        return "modelView".equals(itemName);
    }

    @Override
    protected void addResponseAttributes(StringBuilder sb, QueryRequest queryRequest) {
        this.addQueryReportIdIfNeeded(sb, queryRequest);
        super.addResponseAttributes(sb, queryRequest);
    }

    private void addQueryReportIdIfNeeded(StringBuilder sb, QueryRequest queryRequest) {
        String queryReportId = queryRequest.getId();
        if (!StringUtils.isEmpty((String)queryReportId)) {
            sb.append(" id=\"").append(queryReportId).append("\"");
        }
    }

    @Override
    protected void addFullRepliesElement(RemoteDispatcherResponse response, QueryRequest queryRequest) {
        response.addResponseLine(SoapTokens.getStartReplies(4));
        this.addItem(response, this.getItem(MAIN_ITEM_NAME));
        this.addReportCacheItems(response);
        this.addItem(response, this.getItem("reportMetadata"));
        response.addResponseLine(SoapTokens.getEndReplies());
    }

    private void addReportCacheItems(RemoteDispatcherResponse response) {
        List<String> reportCacheItems = this.getValuesFor("reportCache");
        for (String reportCacheItem : reportCacheItems) {
            this.addReportCacheElement(response, reportCacheItem);
        }
        this.addEmptyReportCacheElementsIfNeeded(response, reportCacheItems);
    }

    private void addReportCacheElement(RemoteDispatcherResponse response, String reportCacheItem) {
        response.addResponseLine(SoapTokens.getStartReportCacheItemElement());
        response.addResponseLine(reportCacheItem);
        response.addResponseLine(SoapTokens.getEndItemElement());
    }

    private void addEmptyReportCacheElementsIfNeeded(RemoteDispatcherResponse response, List<String> reportCacheItems) {
        int numberOfEmptyReportCacheElementsNeeded = 2 - reportCacheItems.size();
        for (int i = 0; i < numberOfEmptyReportCacheElementsNeeded; ++i) {
            response.addResponseLine(SoapTokens.getEmptyQueryResultElement());
        }
    }

    @Override
    protected void addHintsElement(RemoteDispatcherResponse response) {
        if (this.hasModelName()) {
            this.addModelHintTo(response);
        }
    }

    private boolean hasModelName() {
        return !StringUtils.isEmpty((String)this.getModelName());
    }

    private void addModelHintTo(RemoteDispatcherResponse response) {
        response.addResponseLines(SoapTokens.getStartModelHint(), this.getXmlEncodedModel(), SoapTokens.getEndModelHint());
    }

    private String getXmlEncodedModel() {
        return XmlUtils.xmlEncodeElement(this.getFullModelName());
    }

    static {
        keyItemAliases.add(MAIN_ITEM_NAME);
        keyItemAliases.add("dataSet2");
        keyItemAliases.add("query");
        keyItemAliases.add("analysis");
        keyItemAliases.add("powerPlay8Report");
        keyItemAliases.add("powerPlay8ReportView");
        keyItemAliases.add("reportView");
        keyItemAliases.add("interactiveReport");
        keyItemAliases.add("drillPath");
    }
}

