/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager.cache;

import com.cognos.pogo.contentmanager.cache.AccountItems;
import com.cognos.pogo.contentmanager.cache.CachedResponse;
import com.cognos.pogo.contentmanager.cache.PackageItems;
import com.cognos.pogo.contentmanager.cache.ReportItems;
import com.cognos.pogo.contentmanager.cache.ResponseHandler;
import com.cognos.pogo.contentmanager.cache.ResponseItems;
import com.cognos.pogo.contentmanager.cache.SearchParameters;
import com.cognos.pogo.contentmanager.cache.SearchPathUtils;
import com.cognos.pogo.stax.utils.StaxUtils;
import com.cognos.pogo.util.PogoLogger;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class ResponseBodyHandler
extends ResponseHandler {
    private static PogoLogger log = PogoLogger.getLogger();
    private ReportItems reportItems = new ReportItems();
    private PackageItems packageItems = new PackageItems();
    private AccountItems accountItems = new AccountItems();
    private ResponseItems[] validResponseItems = new ResponseItems[]{this.reportItems, this.packageItems, this.accountItems};

    public ResponseBodyHandler(CachedResponse cachedResponse) {
        this(cachedResponse, null);
    }

    public ResponseBodyHandler(CachedResponse cachedResponse, SearchParameters searchParameters) {
        super(cachedResponse);
        this.setSearchParameters(searchParameters);
    }

    private void setSearchParameters(SearchParameters searchParameters) {
        if (searchParameters == null) {
            return;
        }
        String searchPath = searchParameters.getObjectPath();
        if (searchParameters.isSearchingForPackage()) {
            this.packageItems.setPackageName(searchPath);
        } else if (searchParameters.isSearchingForModel()) {
            this.packageItems.setPackageName(SearchPathUtils.getPackageFromModel(searchPath));
        } else if (searchParameters.isSearchingForDatasourceSignon()) {
            this.packageItems.setPackageName(SearchPathUtils.getPackageFromDatasourceSignon(searchPath));
        } else if (searchParameters.isSearchingForReport()) {
            this.reportItems.setReportName(searchPath);
        }
    }

    @Override
    public void handle(XMLStreamReader reader) throws XMLStreamException {
        this.updateAccountItemsWithPassport();
        this.parseResponses(reader);
        this.updateCachedResponse();
    }

    private void updateAccountItemsWithPassport() {
        this.accountItems.setAccountName(this.getCachedResponse().getPassport());
    }

    private void parseResponses(XMLStreamReader reader) throws XMLStreamException {
        StaxUtils.iterateChildrenElement("responses", reader);
        while (StaxUtils.iterateChildrenElement("response", reader)) {
            this.parseResponse(reader);
        }
    }

    private void parseResponse(XMLStreamReader reader) throws XMLStreamException {
        Map<String, String> responseAttributes = this.getResponseAttributes(reader);
        String responseName = responseAttributes.get("name");
        this.parseResponse(responseName, responseAttributes, reader);
    }

    private Map<String, String> getResponseAttributes(XMLStreamReader reader) {
        int nrOfAttributes = reader.getAttributeCount();
        HashMap<String, String> attributes = new HashMap<String, String>(nrOfAttributes);
        for (int i = 0; i < nrOfAttributes; ++i) {
            attributes.put(reader.getAttributeLocalName(i), reader.getAttributeValue(i));
        }
        return attributes;
    }

    private void parseResponse(String responseName, Map<String, String> responseAttributes, XMLStreamReader reader) throws XMLStreamException {
        ResponseItems responseItems = this.findResponseItems(responseName);
        if (responseItems != null) {
            responseItems.parseResponse(responseName, responseAttributes, reader);
        }
    }

    private ResponseItems findResponseItems(String responseName) {
        for (ResponseItems responseItems : this.validResponseItems) {
            if (!responseItems.canHandleResponse(responseName)) continue;
            return responseItems;
        }
        log.warn("Invalid response name received from CM: ", responseName);
        return null;
    }

    private void updateCachedResponse() {
        CachedResponse cachedResponse = this.getCachedResponse();
        cachedResponse.setReportItems(this.reportItems);
        cachedResponse.setPackageItems(this.packageItems);
        cachedResponse.setAccountItems(this.accountItems);
    }
}

