/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager.cache;

import com.cognos.pogo.contentmanager.cache.CachedResponse;
import com.cognos.pogo.contentmanager.cache.HeaderStreamReaderDelegate;
import com.cognos.pogo.contentmanager.cache.ResponseHandler;
import com.cognos.pogo.stax.stream.XMLStreamFactory;
import com.cognos.pogo.stax.utils.StaxUtils;
import com.cognos.pogo.util.StreamFactory;
import java.io.StringWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang.StringUtils;

public class ResponseHeaderHandler
extends ResponseHandler {
    public ResponseHeaderHandler(CachedResponse cachedResponse) {
        super(cachedResponse);
    }

    @Override
    public void handle(XMLStreamReader reader) throws XMLStreamException {
        if (this.isAnonynomousRequest()) {
            this.getAndParseResponseHeader(reader);
        } else {
            this.getResponseHeader(reader);
        }
    }

    private boolean isAnonynomousRequest() {
        String passport = this.getCachedResponse().getPassport();
        return StringUtils.isEmpty((String)passport);
    }

    private void getAndParseResponseHeader(XMLStreamReader reader) throws XMLStreamException {
        HeaderStreamReaderDelegate headerReader = new HeaderStreamReaderDelegate(reader);
        this.getResponseHeader(headerReader);
        String passportId = headerReader.getPassportId();
        this.getCachedResponse().setPassport(passportId);
    }

    private void getResponseHeader(XMLStreamReader reader) throws XMLStreamException {
        StringWriter headerWriter = StreamFactory.createStringWriter();
        XMLStreamWriter xmlWriter = XMLStreamFactory.createXMLStreamWriter(headerWriter);
        StaxUtils.moveToElement("biBusHeader", reader);
        StaxUtils.copyCurrentElement(reader, xmlWriter);
        this.getCachedResponse().setHeader(headerWriter.toString());
    }
}

