/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager.cache.level2;

import com.cognos.p2plb.model.NodeID;
import com.cognos.pogo.contentmanager.cache.AccountItems;
import com.cognos.pogo.contentmanager.cache.CMCacheService;
import com.cognos.pogo.contentmanager.cache.CachedResponse;
import com.cognos.pogo.contentmanager.cache.HandlerConfig;
import com.cognos.pogo.contentmanager.cache.LocalDispatcherSession;
import com.cognos.pogo.contentmanager.cache.PackageItems;
import com.cognos.pogo.contentmanager.cache.QueryCacheElement;
import com.cognos.pogo.contentmanager.cache.ReportItems;
import com.cognos.pogo.contentmanager.cache.ResponseBodyHandler;
import com.cognos.pogo.contentmanager.cache.ResponseFaultHandler;
import com.cognos.pogo.contentmanager.cache.ResponseHeaderHandler;
import com.cognos.pogo.contentmanager.cache.SearchParameters;
import com.cognos.pogo.contentmanager.cache.SoapTokens;
import com.cognos.pogo.contentmanager.cache.context.CacheContext;
import com.cognos.pogo.contentmanager.cache.level2.Level2Query;
import com.cognos.pogo.pdk.common.BiBusHeader;
import com.cognos.pogo.pdk.common.Cam;
import com.cognos.pogo.pdk.common.UserPreferenceVars;
import com.cognos.pogo.pdk.stax.StaxBiBusHeader;
import com.cognos.pogo.pdk.stax.StaxUserPreferenceVars;
import com.cognos.pogo.pdk.stax.cam.StaxCam;
import com.cognos.pogo.stax.connection.SOAPConnection;
import com.cognos.pogo.stax.connection.SOAPConnectionFactory;
import com.cognos.pogo.transport.FormRequestProcessor;
import com.cognos.pogo.util.PerfLogger;
import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.StringUtils;
import org.apache.log.Priority;

public class Level2Client {
    public static final String CM_SOAP_ACTION = FormRequestProcessor.CONTENT_MANAGER_SERVICE;
    private static final PogoLogger log = PogoLogger.getLogger();
    private PerfLogger perfLogger;
    private final HandlerConfig handlerConfig;
    private CachedResponse responseReceivedFromCM;
    private QueryCacheElement queryCacheElement;
    private SearchParameters searchParameters;
    private SOAPConnection connection;
    private Level2Query level2Query;
    private String passport;
    private CacheContext cacheContext;
    private Cam camElement;
    private UserPreferenceVars userPrefs;
    private BiBusHeader fullHeader;

    public Level2Client(HandlerConfig handlerConfig, PerfLogger perfLogger) {
        this.handlerConfig = handlerConfig;
        this.perfLogger = perfLogger.cloneIfEnabled(this.getClass());
    }

    public CachedResponse sendQuery(LocalDispatcherSession clientRequestSession, CachedResponse cachedResponse) {
        this.passport = clientRequestSession.getPassport();
        BiBusHeader biBusHeader = clientRequestSession.getRequestEnvelope().getBiBusHeader();
        this.camElement = biBusHeader.getCam();
        this.userPrefs = biBusHeader.getUserPreferenceVars();
        this.queryCacheElement = clientRequestSession.getQueryCacheElement();
        this.cacheContext = this.queryCacheElement.getCacheContext();
        this.searchParameters = this.queryCacheElement.createSearchParameters();
        return this.createAndSendQuery(cachedResponse);
    }

    private CachedResponse createAndSendQuery(CachedResponse cachedResponse) {
        return this.createAndSendQuery(cachedResponse, false);
    }

    private CachedResponse createAndSendQuery(CachedResponse cachedResponse, boolean trusted) {
        this.createQuery(cachedResponse);
        this.sendQuery(trusted);
        return this.responseReceivedFromCM;
    }

    private void createQuery(CachedResponse cachedResponse) {
        this.level2Query = this.queryCacheElement.createLevel2Query();
        this.addQueryRequests(cachedResponse);
        this.createNewResponse();
        this.setResponseHandlers();
        this.setBiBusHeader();
        this.setSoapAction();
    }

    private void addQueryRequests(CachedResponse cachedResponse) {
        this.addReportQuery(cachedResponse);
        this.addPackageQuery(cachedResponse);
        this.addAccountQuery(cachedResponse);
    }

    private void addReportQuery(CachedResponse cachedResponse) {
        ReportItems reportItems;
        ReportItems reportItems2 = reportItems = cachedResponse != null ? cachedResponse.getReportItems() : null;
        if (reportItems != null) {
            reportItems.addRequestToQuery(this.level2Query, this.searchParameters, this.cacheContext);
        } else {
            ReportItems.addRequestForUnknownItemIfNeeded(this.level2Query, this.searchParameters, this.cacheContext);
        }
    }

    private void addPackageQuery(CachedResponse cachedResponse) {
        PackageItems packageItems;
        PackageItems packageItems2 = packageItems = cachedResponse != null ? cachedResponse.getPackageItems() : null;
        if (packageItems != null) {
            packageItems.addRequestToQuery(this.level2Query, this.searchParameters, this.cacheContext);
        } else {
            PackageItems.addRequestForUnknownItem(this.level2Query, this.searchParameters, cachedResponse, this.cacheContext);
        }
    }

    private void addAccountQuery(CachedResponse cachedResponse) {
        AccountItems accountItems;
        AccountItems accountItems2 = accountItems = cachedResponse != null ? cachedResponse.getAccountItems() : null;
        if (accountItems != null) {
            accountItems.addRequestToQuery(this.level2Query, this.searchParameters, this.cacheContext);
        } else {
            AccountItems.addRequestForUnknownItemIfNeeded(this.level2Query, this.searchParameters, this.cacheContext);
        }
    }

    private void createNewResponse() {
        this.responseReceivedFromCM = new CachedResponse(this.passport);
    }

    private void setResponseHandlers() {
        this.setResponseHeaderHandler();
        this.setResponseBodyHandler();
        this.setResponseFaultHandler();
    }

    private void setResponseHeaderHandler() {
        ResponseHeaderHandler headerHandler = new ResponseHeaderHandler(this.responseReceivedFromCM);
        this.level2Query.setResponseHeaderHandler(headerHandler);
    }

    private void setResponseBodyHandler() {
        ResponseBodyHandler bodyHandler = new ResponseBodyHandler(this.responseReceivedFromCM, this.searchParameters);
        this.level2Query.setResponseBodyHandler(bodyHandler);
    }

    private void setResponseFaultHandler() {
        ResponseFaultHandler faultHandler = new ResponseFaultHandler(this.responseReceivedFromCM);
        this.level2Query.setResponseFaultHandler(faultHandler);
    }

    private void setBiBusHeader() {
        String biBusHeader = this.fullHeader != null ? this.getFullHeader() : this.createShortHeader();
        this.level2Query.setBusHeader(biBusHeader);
    }

    private String getFullHeader() {
        StaxBiBusHeader staxFullHeader = (StaxBiBusHeader)this.fullHeader;
        return StaxBiBusHeader.toString(staxFullHeader, false);
    }

    private String createShortHeader() {
        StaxCam staxCam = (StaxCam)this.camElement;
        StaxUserPreferenceVars staxUserPrefs = this.getLocalesPreferenceVars();
        if (staxUserPrefs == null) {
            return SoapTokens.getBiBusHeader(StaxCam.toString(staxCam, false));
        }
        return SoapTokens.getBiBusHeader(StaxUserPreferenceVars.toString(staxUserPrefs, false), StaxCam.toString(staxCam, false));
    }

    private StaxUserPreferenceVars getLocalesPreferenceVars() {
        String productLocale = this.userPrefs.getValue("productLocale");
        String contentLocale = this.userPrefs.getValue("contentLocale");
        if (StringUtils.isEmpty(productLocale) && StringUtils.isEmpty(contentLocale)) {
            return null;
        }
        StaxUserPreferenceVars localePrefVars = new StaxUserPreferenceVars();
        localePrefVars.setValue("productLocale", productLocale);
        localePrefVars.setValue("contentLocale", contentLocale);
        return localePrefVars;
    }

    private void setSoapAction() {
        this.queryCacheElement.setQueryTarget(this.level2Query);
        String soapAction = this.queryCacheElement.isQueryingRemoteDispatcher() ? CMCacheService.SOAP_ACTION : CM_SOAP_ACTION;
        this.level2Query.setSOAPAction(soapAction);
    }

    private void sendQuery(boolean trusted) {
        if (this.connection == null) {
            this.connection = this.createSoapConnection();
        }
        if (trusted) {
            this.connection.doTrustedRequest();
        }
        this.executeQuery(this.connection, this.queryCacheElement.getQueryURL());
    }

    private SOAPConnection createSoapConnection() {
        SOAPConnectionFactory soapConnectionFactory = this.handlerConfig.getSoapConnectionFactory();
        return soapConnectionFactory.createConnection(this.perfLogger, this.queryCacheElement.getNodeID());
    }

    private void executeQuery(SOAPConnection connection, String queryURL) {
        log.debug("Sending query to ", queryURL, ", nodeID: ", this.queryCacheElement.getNodeID());
        try {
            connection.execute(this.level2Query, queryURL);
        }
        catch (Exception e) {
            this.handleConnectionException(queryURL, e);
        }
    }

    private void handleConnectionException(String queryURL, Exception e) {
        NodeID nodeID = this.queryCacheElement.getNodeID();
        String nodeIdString = nodeID != null ? ", nodeID: " + nodeID : "";
        String errorMessage = "Error connecting to " + queryURL + nodeIdString;
        log.warn(errorMessage, e);
        throw new RuntimeException(errorMessage, e);
    }

    public CachedResponse resendQueryUsingFullHeader(LocalDispatcherSession clientRequestSession, CachedResponse cachedResponse) {
        return this.resendQuery(clientRequestSession, cachedResponse, false);
    }

    public CachedResponse resendQueryUsingFullTrustedHeader(LocalDispatcherSession clientRequestSession, CachedResponse cachedResponse) {
        return this.resendQuery(clientRequestSession, cachedResponse, true);
    }

    private CachedResponse resendQuery(LocalDispatcherSession clientRequestSession, CachedResponse cachedResponse, boolean trusted) {
        log.debug("Resending query to nodeID [", this.queryCacheElement.getNodeID(), "] using full BiBus header");
        this.fullHeader = clientRequestSession.getRequestEnvelope().getBiBusHeader();
        return this.createAndSendQuery(cachedResponse, trusted);
    }

    public static void setLogPriority(Priority priority) {
        log.setPriority(priority);
    }
}

