/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager.cache.level2;

import com.cognos.pogo.contentmanager.cache.level2.QueryRequest;
import com.cognos.pogo.contentmanager.cache.remote.QueryRequests;
import com.cognos.pogo.stax.BusCommand;
import com.cognos.pogo.stax.stream.XMLStreamFactory;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class Level2Query
extends BusCommand {
    private static final AtomicInteger idCount = new AtomicInteger();
    private final QueryRequests queries = new QueryRequests();
    private QueryRequest currentRequest;
    private final String queryReportId = "queryReport" + idCount.incrementAndGet();

    public String getQueryReportId() {
        return this.queryReportId;
    }

    public static void resetQueryReportIdForTesting() {
        idCount.set(0);
    }

    public QueryRequest addQueryRequest(String name) {
        this.currentRequest = new QueryRequest(name);
        this.queries.add(this.currentRequest);
        return this.currentRequest;
    }

    public List<QueryRequest> getQueryRequests() {
        return this.queries.getQueryRequestList();
    }

    @Override
    public void writeBody(Writer writer) throws IOException {
        try {
            this.writeBusElement(writer);
        }
        catch (XMLStreamException e) {
            throw new IOException(e.getMessage());
        }
    }

    private void writeBusElement(Writer writer) throws XMLStreamException {
        XMLStreamWriter xsw = XMLStreamFactory.createXMLStreamWriter(writer);
        this.writeStartBus("custom", xsw);
        this.writeCustomFunction(xsw);
        this.writeFunctionSteps(xsw);
        xsw.writeEndElement();
        xsw.flush();
    }

    private void writeCustomFunction(XMLStreamWriter xsw) throws XMLStreamException {
        xsw.writeStartElement("customFunction");
        xsw.writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "type", "xsd:string");
        xsw.writeCharacters("customReportQuery");
        xsw.writeEndElement();
    }

    private void writeFunctionSteps(XMLStreamWriter xsw) throws XMLStreamException {
        this.queries.writeXML(xsw, false);
    }

    public boolean hasNoPackageHints() {
        for (QueryRequest queryRequest : this.queries.getQueryRequestList()) {
            if (!queryRequest.hasPackageHints()) continue;
            return false;
        }
        return true;
    }
}

