/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager.cache.level2;

import com.cognos.pogo.contentmanager.cache.CacheContainer;
import com.cognos.pogo.contentmanager.cache.Hint;
import com.cognos.pogo.contentmanager.cache.Hints;
import com.cognos.pogo.contentmanager.cache.PackageItems;
import com.cognos.pogo.contentmanager.cache.level2.QueryRequestHints;
import com.cognos.pogo.stax.utils.StaxBase;
import com.cognos.pogo.stax.utils.StaxUtils;
import com.cognos.pogo.util.PogoLogger;
import java.util.Collection;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class QueryRequest
extends StaxBase {
    private static final String FUNCTION_STEP = "functionStep";
    private static final String SEARCH_PATH = "searchPath";
    private static final String VALIDATOR = "validator";
    private static final String SOURCE = "source";
    private static final String ID = "id";
    private static final String UNKNOWN_VALIDATOR = "?";
    private String name;
    private String searchPath;
    private String cacheValidator;
    private String queryReportId;
    private String source;
    private Hints hints;

    public QueryRequest(String name) {
        this.name = name;
        this.cacheValidator = UNKNOWN_VALIDATOR;
    }

    public QueryRequest(XMLStreamReader xsr) throws XMLStreamException {
        this.parse(xsr, FUNCTION_STEP);
    }

    @Override
    public boolean canParse(String entryName) {
        return FUNCTION_STEP.equals(entryName);
    }

    @Override
    public void parse(XMLStreamReader xsr, String entryName) throws XMLStreamException {
        this.parseAttributes(xsr);
        while (StaxUtils.moveToNextElementWithinParent(entryName, xsr)) {
            this.parseElement(xsr, xsr.getLocalName());
        }
    }

    private void parseAttributes(XMLStreamReader xsr) {
        int attributeCount = xsr.getAttributeCount();
        for (int i = 0; i < attributeCount; ++i) {
            this.parseAttribute(xsr, i);
        }
    }

    private void parseAttribute(XMLStreamReader xsr, int attributeIndex) {
        String attributeName = xsr.getAttributeName(attributeIndex).getLocalPart();
        if ("name".equalsIgnoreCase(attributeName)) {
            this.name = xsr.getAttributeValue(attributeIndex);
        } else if (ID.equalsIgnoreCase(attributeName)) {
            this.queryReportId = xsr.getAttributeValue(attributeIndex);
        }
    }

    @Override
    protected void parseElement(XMLStreamReader xsr, String localName) throws XMLStreamException {
        if (SEARCH_PATH.equalsIgnoreCase(localName)) {
            this.searchPath = xsr.getElementText();
        } else if (VALIDATOR.equalsIgnoreCase(localName)) {
            this.cacheValidator = xsr.getElementText();
        } else if (QueryRequestHints.NULL.canParse(localName)) {
            this.hints = new QueryRequestHints(xsr);
        }
    }

    @Override
    public boolean isPresent() {
        return this.name != null || this.searchPath != null || this.cacheValidator != UNKNOWN_VALIDATOR || this.queryReportId != null || this.source != null || this.hints != null;
    }

    @Override
    public void writeXML(XMLStreamWriter xsw, boolean writeNamespace) throws XMLStreamException {
        this.writeStartElement(xsw);
        this.writeOptionalSearchPath(xsw);
        this.writeOptionalValidator(xsw);
        this.writeOptionalHints(xsw);
        xsw.writeEndElement();
    }

    private void writeStartElement(XMLStreamWriter xsw) throws XMLStreamException {
        xsw.writeStartElement(FUNCTION_STEP);
        if (this.name != null) {
            xsw.writeAttribute("name", this.name);
        }
        if (this.queryReportId != null) {
            xsw.writeAttribute(ID, this.queryReportId);
        }
    }

    private void writeOptionalSearchPath(XMLStreamWriter xsw) throws XMLStreamException {
        if (this.hasSearchPathElement()) {
            this.writeSearchPath(xsw, this.source, this.searchPath);
        }
    }

    private void writeSearchPath(XMLStreamWriter xsw, String source, String searchPath) throws XMLStreamException {
        xsw.writeStartElement(SEARCH_PATH);
        if (source != null) {
            xsw.writeAttribute(SOURCE, source);
        }
        if (searchPath != null) {
            xsw.writeCharacters(searchPath);
        }
        xsw.writeEndElement();
    }

    private void writeOptionalValidator(XMLStreamWriter xsw) throws XMLStreamException {
        if (this.cacheValidator != null) {
            QueryRequest.writeElement(VALIDATOR, this.cacheValidator, xsw);
        }
    }

    private void writeOptionalHints(XMLStreamWriter xsw) throws XMLStreamException {
        if (this.hasHints()) {
            this.writeHints(xsw, this.hints);
        }
    }

    private void writeHints(XMLStreamWriter xsw, Hints hints) throws XMLStreamException {
        xsw.writeStartElement("hints");
        for (Hint hint : hints.getHints()) {
            this.writeHint(xsw, hint);
        }
        xsw.writeEndElement();
    }

    private void writeHint(XMLStreamWriter xsw, Hint hint) throws XMLStreamException {
        xsw.writeStartElement("hint");
        QueryRequest.writeElement(SEARCH_PATH, hint.getName(), xsw);
        QueryRequest.writeElement(VALIDATOR, this.getValidator(hint), xsw);
        xsw.writeEndElement();
    }

    private String getValidator(Hint hint) {
        String validator = hint.getValidator();
        return validator != null ? validator : this.getNullCacheValidator(hint);
    }

    private String getNullCacheValidator(Hint hint) {
        this.logHintWithNoCacheValidator(hint);
        return "null";
    }

    private void logHintWithNoCacheValidator(Hint hint) {
        CacheContainer cacheContainer;
        log.info("Found hint with no cache validator: ", hint.getClass().getSimpleName(), ", ", hint.getName());
        CacheContainer cacheContainer2 = cacheContainer = hint instanceof CacheContainer ? (CacheContainer)hint : null;
        if (cacheContainer != null) {
            cacheContainer.dump(log, "");
        }
    }

    public String getName() {
        return this.name;
    }

    public void setSearchPath(String searchPath) {
        this.searchPath = searchPath;
    }

    public String getSearchPath() {
        return this.searchPath;
    }

    public void setCacheValidator(String cacheValidator) {
        this.cacheValidator = cacheValidator;
    }

    public void setCacheValidator(String validatorFromCacheContext, String validatorFromCache) {
        if (this.isCacheValidatorUnknown(validatorFromCacheContext, validatorFromCache)) {
            this.setCacheValidator(UNKNOWN_VALIDATOR);
        } else {
            this.setCacheValidator(validatorFromCache);
        }
    }

    private boolean isCacheValidatorUnknown(String validatorFromCacheContext, String validatorFromCache) {
        return validatorFromCacheContext == null && validatorFromCache == null || validatorFromCacheContext != null && !validatorFromCacheContext.equals(validatorFromCache);
    }

    public String getCacheValidator() {
        return this.cacheValidator;
    }

    public void setId(String queryReportId) {
        this.queryReportId = queryReportId;
    }

    public String getId() {
        return this.queryReportId;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public boolean hasSearchPathElement() {
        return this.searchPath != null || this.source != null;
    }

    public void setHints(Hints hints) {
        this.hints = hints;
    }

    public boolean hasHints() {
        return this.hints != null;
    }

    public boolean hasPackageHints() {
        return this.getName().equals(PackageItems.getPackageQueryName()) && this.hasHints();
    }

    public Collection<Hint> getHints() {
        return this.hints.getHints();
    }

    public void dump(PogoLogger log, String indent) {
        log.debug(indent, this.getClass().getSimpleName(), ": ");
        indent = indent + "   ";
        log.debug(indent, "name: ", this.name);
        log.debug(indent, "searchPath: ", this.searchPath);
        log.debug(indent, "cacheValidator: ", this.cacheValidator);
        log.debug(indent, "queryReportId: ", this.queryReportId);
        log.debug(indent, "source: ", this.source);
        if (this.hasHints()) {
            this.dumpHints(log, indent);
        }
    }

    private void dumpHints(PogoLogger log, String indent) {
        log.debug(indent, this.hints.getClass().getSimpleName(), ": ");
        indent = indent + "   ";
        for (Hint hint : this.hints.getHints()) {
            this.dumpHint(log, indent, hint);
        }
    }

    private void dumpHint(PogoLogger log, String indent, Hint hint) {
        log.debug(indent, hint.getClass().getSimpleName(), ": ");
        indent = indent + "   ";
        log.debug(indent, "name: ", hint.getName());
        log.debug(indent, "validator: ", hint.getValidator());
    }
}

