/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager.cache.remote;

import com.cognos.pogo.contentmanager.cache.level2.QueryRequest;
import com.cognos.pogo.stax.utils.StaxBase;
import com.cognos.pogo.util.PogoLogger;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class QueryRequests
extends StaxBase {
    public static final QueryRequests NULL = new QueryRequests();
    private static final String FUNCTION_STEPS = "functionSteps";
    private List<QueryRequest> queryRequests = new ArrayList<QueryRequest>();

    public QueryRequests(XMLStreamReader xsr) throws XMLStreamException {
        this.parse(xsr, FUNCTION_STEPS);
    }

    public QueryRequests() {
    }

    @Override
    public boolean canParse(String entryName) {
        return FUNCTION_STEPS.equals(entryName);
    }

    @Override
    protected void parseElement(XMLStreamReader xsr, String localName) throws XMLStreamException {
        this.add(new QueryRequest(xsr));
    }

    @Override
    public boolean isPresent() {
        return !this.queryRequests.isEmpty();
    }

    public void add(QueryRequest queryRequest) {
        this.queryRequests.add(queryRequest);
    }

    public QueryRequest get(String queryName) {
        for (QueryRequest queryResult : this.queryRequests) {
            if (!queryName.equals(queryResult.getName())) continue;
            return queryResult;
        }
        return null;
    }

    public void dump(PogoLogger log, String indent) {
        log.debug(indent, this.getClass().getSimpleName(), ": ");
        indent = indent + "   ";
        for (QueryRequest queryRequest : this.queryRequests) {
            queryRequest.dump(log, indent);
        }
    }

    public List<QueryRequest> getQueryRequestList() {
        return this.queryRequests;
    }

    @Override
    public void writeXML(XMLStreamWriter xsw, boolean writeNamespace) throws XMLStreamException {
        xsw.writeStartElement(FUNCTION_STEPS);
        for (QueryRequest queryRequest : this.queryRequests) {
            queryRequest.writeXML(xsw, writeNamespace);
        }
        xsw.writeEndElement();
    }
}

