/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager.cache.remote;

import com.cognos.pogo.contentmanager.cache.CMCacheRequestBodyHandler;
import com.cognos.pogo.contentmanager.cache.CachedResponse;
import com.cognos.pogo.contentmanager.cache.SearchParameters;
import com.cognos.pogo.contentmanager.cache.SearchType;
import com.cognos.pogo.contentmanager.cache.level2.QueryRequest;
import com.cognos.pogo.contentmanager.cache.remote.QueryRequests;
import com.cognos.pogo.pdk.common.Envelope;
import com.cognos.pogo.util.PogoLogger;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class RemoteDispatcherRequest {
    private final QueryRequests queryRequests;
    private final CMCacheRequestBodyHandler requestBody;

    public static RemoteDispatcherRequest createInstance(Envelope requestEnvelope) {
        return new RemoteDispatcherRequest(requestEnvelope);
    }

    public RemoteDispatcherRequest(Envelope requestEnvelope) {
        this.requestBody = (CMCacheRequestBodyHandler)requestEnvelope.getBodyHandler();
        this.queryRequests = this.requestBody.getQueryRequests();
    }

    public SearchParameters createSearchParameters() {
        QueryRequest queryRequest = this.getReportQuery();
        if (queryRequest != null) {
            return new SearchParameters(SearchType.REPORT, queryRequest.getSearchPath());
        }
        queryRequest = this.getPackageQuery();
        if (queryRequest != null) {
            return new SearchParameters(SearchType.PACKAGE, queryRequest.getSearchPath());
        }
        queryRequest = this.getAccountQuery();
        if (queryRequest != null) {
            return new SearchParameters(SearchType.ACCOUNT, queryRequest.getSearchPath());
        }
        queryRequest = this.getDataSourceSignonQuery();
        if (queryRequest != null) {
            return new SearchParameters(SearchType.DATASOURCESIGNON, queryRequest.getSearchPath());
        }
        return new SearchParameters(SearchType.NULL, "");
    }

    private QueryRequest getReportQuery() {
        return this.queryRequests.get("reportQuery");
    }

    private QueryRequest getPackageQuery() {
        return this.queryRequests.get("packageQuery");
    }

    private QueryRequest getAccountQuery() {
        QueryRequest queryRequest = this.queryRequests.get("accountQuery");
        return queryRequest != null ? queryRequest : this.queryRequests.get("accountQueryCAM");
    }

    private QueryRequest getDataSourceSignonQuery() {
        return this.queryRequests.get("dataSourceSignonQuery");
    }

    public List<QueryRequest> getQueryRequests() {
        return this.queryRequests.getQueryRequestList();
    }

    public void addMissingSearchPaths(CachedResponse responseFromCache) {
        this.setSearchPathIfNeeded(this.getPackageQuery(), responseFromCache.getPackageName());
        this.setSearchPathIfNeeded(this.getAccountQuery(), responseFromCache.getAccountName());
    }

    private void setSearchPathIfNeeded(QueryRequest queryRequest, String searchPath) {
        if (queryRequest != null && StringUtils.isEmpty((String)queryRequest.getSearchPath())) {
            queryRequest.setSearchPath(searchPath);
        }
    }

    public void dump(PogoLogger log, String indent) {
        log.debug(indent, this.getClass().getSimpleName(), ": ");
        indent = indent + "   ";
        this.queryRequests.dump(log, indent);
    }
}

