/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager.coordinator;

import com.cognos.pogo.contentmanager.coordinator.ActiveCMControl;
import com.cognos.pogo.http.SimpleHttpConnection;
import com.cognos.pogo.transport.DispatcherConnectionManager;
import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.threads.SafeTimerTask;
import com.cognos.pogo.util.timer.NullTimer;
import java.util.Timer;
import java.util.TimerTask;

public class ActiveCMChecker {
    private static final PogoLogger cat = PogoLogger.getLogger();
    private int heartbeatInMillis;
    private Timer checkTimer = NullTimer.getInstance();
    private ActiveCMControl cmControl;
    protected SimpleHttpConnection cmConnection;
    protected String activeCmUri;

    public ActiveCMChecker(int heartbeatInMillis, String activeCmUri) throws Exception {
        this(heartbeatInMillis, activeCmUri, ActiveCMControl.getInstance());
    }

    public ActiveCMChecker(int heartbeatInMillis, String activeCmUri, ActiveCMControl instance) throws Exception {
        this.heartbeatInMillis = heartbeatInMillis;
        this.activeCmUri = activeCmUri;
        this.cmControl = instance;
        this.cmConnection = this.createSimpleHttpConnection();
        this.setTimeouts(heartbeatInMillis);
    }

    private void setTimeouts(int heartbeatInMillis) {
        this.cmConnection.setConnectionTimeout(heartbeatInMillis);
        this.cmConnection.setSocketTimeout(heartbeatInMillis);
    }

    public void startChecking() {
        cat.debug("Starting CM check. Active CM: ", this.activeCmUri);
        this.startTimer();
    }

    public void stopChecking() {
        cat.debug("Stopping CM check");
        this.stopTimer();
        this.stopCmControlTimer();
    }

    private void stopCmControlTimer() {
        this.cmControl.stopTimer();
    }

    public void updateCmUri(String newCmUri) {
        if (!newCmUri.equals(this.activeCmUri)) {
            cat.debug("Updating active CM URI: from ", this.activeCmUri, " to ", newCmUri);
            this.activeCmUri = newCmUri;
            this.cmConnection = this.createSimpleHttpConnection();
        }
    }

    private SimpleHttpConnection createSimpleHttpConnection() {
        try {
            return this.getNewSimpleHttpConnection();
        }
        catch (Exception e) {
            cat.error("Unable to create connection to " + this.activeCmUri + " Will not ping for failover", e);
            return null;
        }
    }

    protected SimpleHttpConnection getNewSimpleHttpConnection() throws Exception {
        return DispatcherConnectionManager.createSimpleHttpConnection(this.activeCmUri);
    }

    public String getCmUriForTesting() {
        return this.activeCmUri;
    }

    private void startTimer() {
        this.checkTimer = this.getNewTimer();
        this.checkTimer.scheduleAtFixedRate((TimerTask)new CMCheckTask(), this.getHeartbeatInMillis(), (long)this.getHeartbeatInMillis());
    }

    protected Timer getNewTimer() {
        return new Timer(true);
    }

    private void stopTimer() {
        this.checkTimer.cancel();
    }

    protected int getHeartbeatInMillis() {
        return this.heartbeatInMillis;
    }

    private void checkCM() {
        if (this.cmConnection == null) {
            return;
        }
        if (this.isCmConnectionOK()) {
            this.notifySuccess();
        } else {
            this.notifyFailure();
        }
    }

    private boolean isCmConnectionOK() {
        cat.debug("Checking CM: ", this.activeCmUri);
        String cmResponse = this.cmConnection.get();
        return this.isCmResponseOK(cmResponse);
    }

    private boolean isCmResponseOK(String cmResponse) {
        return cmResponse != null && (cmResponse.contains(">Running<") || cmResponse.contains(">Running suspended<"));
    }

    private void notifySuccess() {
        cat.debug("CM OK");
        this.cmControl.cMOkNotify();
    }

    private void notifyFailure() {
        cat.debug("CM connection failed");
        this.cmControl.cMIOErrorNotify();
    }

    private class CMCheckTask
    extends SafeTimerTask {
        public CMCheckTask() {
            super("CMHeartBeat");
        }

        @Override
        public void safeRun() {
            ActiveCMChecker.this.checkCM();
        }
    }
}

